/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Document;

public class ExtractOutline
extends BaseTextExtraction {
    public ExtractOutline(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractOutline(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        this.fileName = file_name;
        if (this.openPDFFile()) {
            Document outline = this.getPDFTextOutline();
            try (InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");){
                TransformerFactory tFactory = SecureTransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(stylesheet));
                String name = "demo";
                int pointer = file_name.lastIndexOf(separator);
                if (pointer != -1) {
                    name = file_name.substring(pointer + 1, file_name.length() - 4);
                }
                String outputDir = this.output_dir + name + separator;
                DOMSource source = new DOMSource(outline);
                if (source.getNode() != null) {
                    File output = new File(outputDir + "outline.xml");
                    if (!output.exists()) {
                        File createDir = new File(outputDir);
                        createDir.mkdirs();
                        output.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(output);
                    StreamResult result = new StreamResult(fos);
                    transformer.transform(source, result);
                }
            }
            catch (IOException | TransformerException e) {
                throw new PdfException(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        int len = args.length;
        switch (len) {
            case 0: {
                System.out.println("Example takes 2 parameters");
                System.out.println("Value 1 is the file name or directory of PDF files to process");
                System.out.println("Value 2 is Directory for writing the data as text files");
                System.exit(0);
            }
            case 2: {
                try {
                    ExtractOutline.writeAllOutlinesToDir(args[0], args[1]);
                }
                catch (PdfException e) {
                    LogWriter.writeLog(e);
                }
                break;
            }
            default: {
                System.out.println("too many arguments entered - run with no values to see defaults");
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
                System.exit(0);
            }
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.OUTLINE;
        super.init();
    }

    public static void writeAllOutlinesToDir(String inputDir, String outputDir) throws PdfException {
        ExtractOutline extract = new ExtractOutline(inputDir);
        extract.setup(outputDir);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    private void setup(String outputDir) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.output_dir = outputDir;
    }

    public Document getPDFTextOutline() {
        return this.decode_pdf.getOutlineAsXML();
    }
}

