/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.border.Border;
import org.jpedal.FileAccess;
import org.jpedal.FileAccessHelper;
import org.jpedal.Parser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.EmptyActionHandler;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfDecoderServer
implements PdfDecoderInt {
    public static final String version;
    private final DecoderOptions options = new DecoderOptions();
    private final ExternalHandlers externalHandlers = new ExternalHandlers();
    private final PdfResources res = new PdfResources();
    private final FileAccess fileAccess = new FileAccess(this.externalHandlers, this.res, this.options);
    private final DecoderResults resultsFromDecode = new DecoderResults();
    private final Parser parser = new Parser(this.externalHandlers, this.options, this.fileAccess, this.res, this.resultsFromDecode);
    private final DPIFactory scalingdpi = new DPIFactory();
    private boolean isNewRotationSet;
    private int displayRotation;
    private int x_size = 100;
    private int y_size = 100;
    private float scaling = 1.0f;
    private boolean alwaysEncryptFile;

    @Override
    public void setEncryptTempFiles() {
        this.alwaysEncryptFile = true;
    }

    @Override
    public boolean isOpen() {
        return this.fileAccess.isOpen();
    }

    @Override
    public Document getMarkedContent() {
        return new MarkedContentGenerator().getMarkedContentTree(this.res, this.fileAccess.getPdfPageData(), this.getIO());
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    @Override
    public int getPageNumber() {
        return this.fileAccess.getPageNumber();
    }

    @Override
    public void setDisplayRotation(int newRotation) {
        this.displayRotation = newRotation;
    }

    @Override
    public Display getPages() {
        return null;
    }

    @Override
    public int getlastPageDecoded() {
        return this.fileAccess.getLastPageDecoded();
    }

    @Override
    public Iterator<Integer> getPageInfo(int type) {
        return this.resultsFromDecode.getPageInfo(type);
    }

    @Override
    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    @Override
    public boolean isLoadingLinearizedPDF() {
        return this.fileAccess.linearParser.linearizedBackgroundReaderer != null && this.fileAccess.linearParser.linearizedBackgroundReaderer.isAlive();
    }

    public static void showExpiry() {
        if (FileAccessHelper.bb > 0) {
            System.out.println("Trial expires in " + FileAccessHelper.bb + " days");
        }
    }

    @Override
    public int getPageAlignment() {
        return this.options.getPageAlignment();
    }

    public static void init(boolean newEmbedWidthData) {
        DecoderOptions.embedWidthData = newEmbedWidthData;
    }

    public PdfDecoderServer(boolean newRender) {
        this.setup(newRender);
    }

    public PdfDecoderServer() {
        this.setup(true);
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    @Override
    public final void dispose() {
        this.parser.disposeObjects();
    }

    @Override
    public final void closePdfFile() {
        this.fileAccess.closePdfFile();
    }

    public final PdfData getPdfBackgroundData() {
        return this.parser.getPdfBackgroundData();
    }

    @Override
    public final PdfData getPdfData() throws PdfException {
        return this.parser.getPdfData();
    }

    @Override
    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    @Override
    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.getIO());
    }

    @Override
    public final PdfPageData getPdfPageData() {
        return this.fileAccess.getPdfPageData();
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex) throws PdfException {
        return this.getPageAsHiRes(pageIndex, false);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map<Integer, Object> params) throws PdfException {
        if (params != null) {
            this.modifyNonstaticJPedalParameters(params);
        }
        return this.getPageAsHiRes(pageIndex);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map<Integer, Object> params, boolean isTransparent) throws PdfException {
        if (params != null) {
            this.options.set(params);
        }
        return this.getPageAsHiRes(pageIndex, isTransparent);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, boolean isTransparent) throws PdfException {
        boolean rawSetting = this.getFormRenderer().getCompData().formsRasterizedForDisplay();
        this.getFormRenderer().getCompData().setRasterizeForms(true);
        this.parser.setParms(this.displayRotation, this.scaling, 0, -1);
        BufferedImage img = this.parser.getPageAsHiRes(pageIndex, isTransparent);
        this.getFormRenderer().getCompData().setRasterizeForms(rawSetting);
        return img;
    }

    @Override
    public BufferedImage getPageAsImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, false, this.scaling);
    }

    @Override
    public BufferedImage getPageAsImage(int pageIndex, float scaling) throws PdfException {
        return this.getPageAsImage(pageIndex, false, scaling);
    }

    @Override
    public BufferedImage getPageAsTransparentImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, true, this.scaling);
    }

    private BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent, float scaling) throws PdfException {
        boolean flag = this.getFormRenderer().getCompData().formsRasterizedForDisplay();
        this.getFormRenderer().getCompData().setRasterizeForms(true);
        this.parser.setParms(this.displayRotation, scaling, 0, -1);
        BufferedImage img = this.parser.getPageAsImage(pageIndex, imageIsTransparent);
        this.getFormRenderer().getCompData().setRasterizeForms(flag);
        return img;
    }

    @Override
    public float getHiResUpscaleFactor() {
        return this.parser.getHiResUpscaleFactor();
    }

    @Override
    public final void flushObjectValues(boolean reinit) {
        this.parser.flushObjectValues(reinit);
    }

    @Override
    public final PdfImageData getPdfImageData() {
        return this.parser.getPdfImageData();
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.parser.getPdfBackgroundImageData();
    }

    @Override
    public final void setRenderMode(int mode) {
        this.parser.setRenderMode(mode);
    }

    @Override
    public final void setExtractionMode(int mode) {
        this.parser.setExtractionMode(mode);
    }

    @Override
    public void modifyNonstaticJPedalParameters(Map<Integer, Object> values) throws PdfException {
        this.options.set(values);
    }

    public static void modifyJPedalParameters(Map<Integer, Object> values) throws PdfException {
        if (values != null) {
            DecoderOptions.modifyJPedalParameters(values);
        }
    }

    @Override
    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.getIO());
    }

    @Override
    public final void setExtractionMode(int mode, float scaling) {
        this.scaling = scaling;
        this.parser.setExtractionMode(mode, scaling);
    }

    @Override
    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    @Override
    public final void setPageParameters(float scaling, int pageNumber) {
        boolean layersChanged;
        this.fileAccess.setPageNumber(pageNumber);
        this.parser.resetMultiplyer();
        if (scaling > 0.0f) {
            this.scaling = scaling;
        } else {
            scaling = this.scaling;
        }
        PdfLayerList layers = this.res.getPdfLayerList();
        if (layers != null && (layersChanged = layers.setZoom(this.scalingdpi.removeScaling(scaling)))) {
            this.decodePage(-1);
        }
        PdfPageData pageData = this.fileAccess.getPdfPageData();
        pageData.setScalingValue(scaling);
        int mediaW = pageData.getMediaBoxWidth(pageNumber);
        int max_y = pageData.getMediaBoxHeight(pageNumber);
        int cropW = pageData.getCropBoxWidth(pageNumber);
        int cropH = pageData.getCropBoxHeight(pageNumber);
        this.x_size = (int)((float)cropW * scaling);
        this.y_size = (int)((float)cropH * scaling);
        if (!this.isNewRotationSet) {
            this.displayRotation = pageData.getRotation(pageNumber);
        } else {
            this.isNewRotationSet = false;
        }
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.init(mediaW, max_y, this.options.getPageColor());
        RenderUtils.setDisplayOptions(currentDisplay, this.options);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.getCompData().setForceRedraw(true);
        }
    }

    @Override
    public final void setPageParameters(float scaling, int pageNumber, int newRotation) {
        this.isNewRotationSet = true;
        this.displayRotation = newRotation;
        this.setPageParameters(scaling, pageNumber);
    }

    @Override
    public void waitForDecodingToFinish() {
        this.fileAccess.waitForDecodingToFinish();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer() {
        return this.fileAccess.getDynamicRenderer();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        return this.fileAccess.getDynamicRenderer(reset);
    }

    @Override
    public PdfObjectReader getIO() {
        return this.parser.getIO();
    }

    @Override
    public final void decodePage(int rawPage) {
        boolean isPageAvailable = this.isPageAvailable(rawPage);
        PdfObject pdfObject = this.fileAccess.linearParser.getLinearPageObject();
        if (!isPageAvailable) {
            return;
        }
        if (pdfObject != null) {
            this.fileAccess.readAllPageReferences(pdfObject, new HashMap<String, Integer>(1000), new HashMap<String, String>(1000), rawPage, this.getFormRenderer(), this.res, this.options.getInsetW(), this.options.getInsetH());
        }
        this.parser.setParms(this.displayRotation, this.scaling, 0, -1);
        this.parser.decodePage(rawPage);
    }

    @Override
    public synchronized boolean isPageAvailable(int rawPage) {
        return this.parser.isPageAvailable(rawPage);
    }

    @Override
    public void drawAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        if (page == this.getPageNumber()) {
            currentDisplay.drawAdditionalObjectsOverPage(type, colors, obj);
        }
    }

    @Override
    public void flushAdditionalObjectsOnPage(int page) {
        if (page == this.getPageNumber()) {
            DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
            currentDisplay.writeCustom(42, null);
        }
    }

    @Override
    public final synchronized void decodePageInBackground(int i) {
        this.parser.decodePageInBackground(i);
    }

    @Override
    public final int getPageCount() {
        return this.fileAccess.getPageCount();
    }

    @Override
    public final boolean isEncrypted() {
        return this.fileAccess.isEncrypted();
    }

    @Override
    public final boolean isPasswordSupplied() {
        return this.fileAccess.isPasswordSupplied(this.getIO());
    }

    @Override
    public boolean isFileViewable() {
        return this.fileAccess.isFileViewable(this.getIO());
    }

    @Override
    public boolean isExtractionAllowed() {
        if (this.getIO() != null) {
            PdfFileReader objectReader = this.getIO().getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(103);
        }
        return false;
    }

    @Override
    public final void setEncryptionPassword(String password) throws PdfException {
        if (this.getIO() == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.getIO().getObjectReader().setPassword(password);
        if (this.getIO() != null) {
            try {
                this.preOpen();
                this.fileAccess.openPdfFile();
                this.postOpen();
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception " + e + " opening file");
            }
        }
    }

    @Override
    public final void openPdfArray(byte[] data) throws PdfException {
        if (this.alwaysEncryptFile) {
            this.openPdfArray(data, DecryptionFactory.getDynamicPassword());
            return;
        }
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data);
        this.postOpen();
    }

    @Override
    public final void openPdfArray(byte[] data, String password) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data, password);
        this.postOpen();
    }

    @Override
    public void openPdfFile(String filename, Certificate certificate, PrivateKey key) throws PdfException {
        this.fileAccess.setUserEncryption(certificate, key);
        if (this.alwaysEncryptFile) {
            this.openPdfFile(filename, DecryptionFactory.getDynamicPassword());
        } else {
            this.openPdfFile(filename);
        }
    }

    @Override
    public final void openPdfFileFromStream(Object filename, String password) throws PdfException {
        this.preOpen();
        this.fileAccess.openPdfFileFromStream(filename, password);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename) throws PdfException {
        if (this.alwaysEncryptFile) {
            this.openPdfFile(filename, DecryptionFactory.getDynamicPassword());
            return;
        }
        if (this.fileAccess.isOpen && this.fileAccess.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename, String password) throws PdfException {
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename, false, password);
        this.postOpen();
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized) throws PdfException {
        if (this.alwaysEncryptFile) {
            return this.openPdfFileFromURL(pdfUrl, supportLinearized, DecryptionFactory.getDynamicPassword());
        }
        this.preOpen();
        InputStream is = null;
        String rawFileName = null;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            is = url.openStream();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized, String password) throws PdfException {
        InputStream is;
        String rawFileName;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            is = url.openStream();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            throw new PdfException("[PDFException] Unable to open URL " + pdfUrl);
        }
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized) throws PdfException {
        if (this.alwaysEncryptFile) {
            return this.openPdfFileFromInputStream(is, supportLinearized, DecryptionFactory.getDynamicPassword());
        }
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized, String password) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
        this.postOpen();
        return flag;
    }

    private void postOpen() {
        ActionHandler handler;
        if (this.fileAccess.getPageCount() < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
        if (this.options.getCurrentOffsets() == null) {
            this.options.setCurrentOffsets(new PageOffsets(this.fileAccess.getPageCount(), this.getPdfPageData()));
        }
        if ((handler = this.externalHandlers.getFormActionHandler()) != null) {
            handler.init(null, this.externalHandlers.getJavaScript(), this.getFormRenderer());
        }
    }

    private void preOpen() {
        this.fileAccess.setDecoding(true);
        this.options.setDisplayView(2);
        if (this.options.getCurrentOffsets() == null) {
            this.options.setCurrentOffsets(new PageOffsets(this.fileAccess.getPageCount(), this.getPdfPageData()));
        }
        this.fileAccess.setDecoding(false);
        this.parser.resetOnOpen();
        ExpressionEngine userExpressionEngine = (ExpressionEngine)this.externalHandlers.getExternalHandler(6);
        this.externalHandlers.openPdfFile(userExpressionEngine);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        ActionHandler handler = this.externalHandlers.getFormActionHandler();
        if (handler == null) {
            handler = new EmptyActionHandler();
        }
        formRenderer.resetHandler(handler, this.scalingdpi.getDpi(), this.externalHandlers.getJavaScript());
    }

    @Override
    public Object getJPedalObject(int id) {
        return this.parser.getJPedalObject(id);
    }

    @Override
    public void setPageMode(int mode) {
        this.options.setPageMode(mode);
    }

    @Override
    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    @Override
    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    @Override
    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.writeCustom(43, null);
    }

    @Override
    public void setStreamCacheSize(int size) {
        this.fileAccess.setStreamCacheSize(size);
    }

    @Override
    public void setUserOffsets(int x, int y, int mode) {
    }

    @Override
    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    @Override
    public int getPageFromObjectRef(String ref) {
        return this.getIO().convertObjectToPageNumber(ref);
    }

    @Override
    public String getInfo(int type) {
        return this.parser.getInfo(type);
    }

    @Override
    public AcroRenderer getFormRenderer() {
        return this.externalHandlers.getFormRenderer();
    }

    @Override
    public Javascript getJavaScript() {
        return this.externalHandlers.getJavaScript();
    }

    @Override
    public String getPageDecodeReport() {
        return this.parser.getPageDecodeReport();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.fileAccess.getObjectStore();
    }

    @Override
    public void setObjectStore(ObjectStore newStore) {
        this.fileAccess.setObjectStore(newStore);
    }

    @Override
    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    @Override
    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.parser.getGroupingObject();
    }

    @Override
    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.parser.getBackgroundGroupingObject();
    }

    @Override
    public final String getPDFVersion() {
        if (this.getIO() == null) {
            return "";
        }
        return this.getIO().getObjectReader().getType();
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    @Override
    public boolean getPageDecodeStatus(int status) {
        return this.resultsFromDecode.getPageDecodeStatus(status);
    }

    @Override
    public String getPageDecodeStatusReport(int status) {
        return this.resultsFromDecode.getPageDecodeStatusReport(status);
    }

    @Override
    public void addExternalHandler(Object newHandler, int type) {
        this.externalHandlers.addExternalHandler(newHandler, type);
    }

    @Override
    public Object getExternalHandler(int type) {
        if (type == 17) {
            return this.fileAccess.getOffset();
        }
        return this.externalHandlers.getExternalHandler(type);
    }

    @Override
    public String getFileName() {
        return this.fileAccess.getFilename();
    }

    @Override
    public boolean isForm() {
        return this.res.isForm() || this.getFormRenderer() != null && this.getFormRenderer().isXFA();
    }

    @Override
    public TextLines getTextLines() {
        return this.parser.getTextLines();
    }

    @Override
    public final int getPDFWidth() {
        int insetW = this.options.getInsetW();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + insetW + insetW;
        }
        return this.x_size + insetW + insetW;
    }

    @Override
    public final int getPDFHeight() {
        int insetH = this.options.getInsetH();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + insetH + insetH;
        }
        return this.y_size + insetH + insetH;
    }

    @Override
    public int getDisplayView() {
        return this.options.getDisplayView();
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    private void setup(boolean newRender) {
        String alwaysEncrypt = System.getProperty("org.jpedal.alwaysEncryptLocalFileSystemData");
        this.alwaysEncryptFile = "true".equalsIgnoreCase(alwaysEncrypt);
        this.options.setRenderPage(newRender);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
    }

    @Override
    public int getInsetH() {
        return this.options.getInsetH();
    }

    @Override
    public int getInsetW() {
        return this.options.getInsetW();
    }

    @Override
    public BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling) {
        return null;
    }

    @Override
    public int getScrollInterval() {
        return this.options.getScrollInterval();
    }

    @Override
    public void setScrollInterval(int scrollInterval) {
        this.options.setScrollInterval(scrollInterval);
    }

    @Override
    public void resetForNonPDFPage(int pageCount) {
    }

    @Override
    public void setPDFBorder(Border newBorder) {
    }

    @Override
    public void updateCursorBoxOnScreen(int[] rectParams, int outlineColor) {
    }

    @Override
    public void setHardwareAccelerationforScreen(boolean useAcceleration) {
    }

    @Override
    public ExternalHandlers getExternalHandler() {
        return this.externalHandlers;
    }

    @Override
    public int getSpecialMode() {
        return 0;
    }

    @Override
    public boolean useNewGraphicsMode() {
        return false;
    }

    @Override
    public void useNewGraphicsMode(boolean isEnabled) {
    }

    @Override
    public void setScaling(float scaleFactor) {
    }

    @Override
    public void setStatusBarObject(StatusBar statusBar) {
    }

    @Override
    public void setInset(int width, int height) {
    }

    @Override
    public int[] getMaxSizeWH() {
        return null;
    }

    @Override
    public int[] getPaneBounds() {
        return null;
    }

    @Override
    public void repaintPane(int page) {
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setPreviewThumbnail(BufferedImage previewImage, String previewText) {
    }

    @Override
    public int getTextPrint() {
        return -1;
    }

    @Override
    public void repaint() {
    }

    @Override
    public Rectangle getVisibleRect() {
        return null;
    }

    @Override
    public DisplayOffsets getDisplayOffsets() {
        return null;
    }

    @Override
    public PdfObject getViewerPreferences() {
        return this.res.getPdfObject(5);
    }

    static {
        String versionSet;
        InputStream is = ExternalHandlers.class.getClassLoader().getResourceAsStream("version.num");
        Properties props = new Properties();
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ex) {
                LogWriter.writeLog("Exception: " + ex.getMessage());
            }
        }
        version = (versionSet = props.getProperty("release")) != null ? versionSet : "@VERSION@";
        String name = System.getProperty("os.name");
        if ("Mac OS X".equals(name)) {
            DecoderOptions.isRunningOnMac = true;
        } else if (name.startsWith("Windows")) {
            DecoderOptions.isRunningOnWindows = true;
        } else if (name.startsWith("AIX")) {
            DecoderOptions.isRunningOnAIX = true;
        } else if ("Linux".equals(name)) {
            DecoderOptions.isRunningOnLinux = true;
        }
        try {
            DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

