/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.jpedal.color.GenericColorSpace;

final class ShadingUtils {
    private ShadingUtils() {
    }

    public static Point2D findDistancedPoint(double t, Point2D sp, Point2D c1, Point2D c2, Point2D ep) {
        double d = 1.0 - t;
        double dCube = d * d * d;
        double dSqr = d * d;
        double tCube = t * t * t;
        double tSqr = t * t;
        double xCoord = dCube * sp.getX() + 3.0 * t * dSqr * c1.getX() + 3.0 * tSqr * d * c2.getX() + tCube * ep.getX();
        double yCoord = dCube * sp.getY() + 3.0 * t * dSqr * c1.getY() + 3.0 * tSqr * d * c2.getY() + tCube * ep.getY();
        return new Point2D.Double(xCoord, yCoord);
    }

    static void setBackground(int w, int h, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background);
        Color c = new Color(shadingColorSpace.getColor().getRGB());
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int base = (i * w + j) * 4;
                data[base] = c.getRed();
                data[base + 1] = c.getGreen();
                data[base + 2] = c.getBlue();
                data[base + 3] = 255;
            }
        }
    }

    public static void setBackgroundColor(int w, int h, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background);
        int cint = shadingColorSpace.getColor().getRGB();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                data[i * w + j] = cint;
            }
        }
    }
}

