/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class SMaskComposite
implements CompositeContext {
    private final float fixedAlpha;
    private final ColorModel srcModel;
    private final ColorModel dstModel;

    SMaskComposite(ColorModel srcColorModel, ColorModel dstColorModel, float alpha) {
        this.srcModel = srcColorModel;
        this.dstModel = dstColorModel;
        this.fixedAlpha = alpha;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int snComp = this.srcModel.getNumComponents();
        int bnComp = this.dstModel.getNumComponents();
        int bnColors = this.dstModel.getNumColorComponents();
        int width = Math.min(Math.min(src.getWidth(), dstIn.getWidth()), dstOut.getWidth());
        int height = Math.min(Math.min(src.getHeight(), dstIn.getHeight()), dstOut.getHeight());
        float[] sColors = new float[snComp];
        float[] bColors = new float[bnComp];
        boolean hasAlphaB = this.dstModel.hasAlpha();
        Object srcPixel = null;
        Object dstPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dstPixel = dstIn.getDataElements(x, y, dstPixel);
                bColors = this.dstModel.getNormalizedComponents(dstPixel, bColors, 0);
                srcPixel = src.getDataElements(x, y, srcPixel);
                sColors = this.srcModel.getNormalizedComponents(srcPixel, sColors, 0);
                float qM = sColors[0];
                float qS = qM * this.fixedAlpha;
                float aB = hasAlphaB ? bColors[bnColors] : 1.0f;
                float aR = 0.0f;
                if (aB != 0.0f) {
                    aR = aB + qS - aB * qS;
                    for (int i = 0; i < bnColors; ++i) {
                        float cB = bColors[i];
                        bColors[i] = cB + qS - qS * cB;
                    }
                }
                if (hasAlphaB) {
                    bColors[bnColors] = aR;
                }
                dstPixel = this.dstModel.getDataElements(bColors, 0, dstPixel);
                dstOut.setDataElements(x, y, dstPixel);
            }
        }
    }
}

