/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.objects;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.pdf.acroforms.xfa.ExDataStyle;
import com.idrsolutions.pdf.acroforms.xfa.XBox;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import com.idrsolutions.pdf.acroforms.xfa.XFAStyle;
import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAShadingFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.TextState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.Tj;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFADraw {
    private final XBox box;
    private final Tj textDecoder;
    private double[] coordsXYWH = new double[4];
    private double[] fullBound = new double[4];
    private final Node node;
    private XFontInfo capFontInfo = new XFontInfo();
    private Map<String, PdfFont> fontCache = new HashMap<String, PdfFont>();
    private final PdfStreamDecoder decoder;
    private static final double DPIADJUST = 1.53;
    private final DynamicVectorRenderer dvr;
    private String captionData;
    private PdfFontFactory pdfFontFactory;
    private boolean isCaptionHTML;
    private final PdfObjectReader currentPdfFile;
    private double paraMarginLeft;
    private double paraMarginRight;

    public XFADraw(Tj textDecoder, Node node, Node pageAreaNode, DynamicVectorRenderer dvr, PdfObjectReader currentPdfFile, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache) {
        Node dui;
        Node borderNode;
        this.node = node;
        this.dvr = dvr;
        this.textDecoder = textDecoder;
        this.currentPdfFile = currentPdfFile;
        this.decoder = decoder;
        this.fontCache = fontCache;
        decoder.incrementTokenNumber();
        this.box = new XBox(node);
        if (!this.box.isVisibleWidget(node)) {
            return;
        }
        this.coordsXYWH = XFAFormStream.getDynamicCoordsBottom(node, pageAreaNode);
        Element nodeEle = (Element)node;
        String ancType = nodeEle.getAttribute("anchorType");
        if (!ancType.isEmpty()) {
            XFADraw.handleAnchorType(ancType, this.coordsXYWH);
        }
        this.fullBound = new double[]{this.coordsXYWH[0], this.coordsXYWH[1], this.coordsXYWH[2], this.coordsXYWH[3]};
        if (node.getParentNode() != null && (borderNode = XFAFormStream.lookForChild(node.getParentNode(), -1383304148)) != null) {
            XFADraw.drawParentBorder(dvr, node.getParentNode(), this.fullBound);
        }
        if ((dui = XFAFormStream.lookForChild(node, 3732)) != null && dui.hasChildNodes()) {
            block5: for (int i = 0; i < dui.getChildNodes().getLength(); ++i) {
                Node duiChild = dui.getChildNodes().item(i);
                switch (duiChild.getNodeName().hashCode()) {
                    case -1004091177: {
                        this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
                        this.updateDrawTextExit();
                        continue block5;
                    }
                    case -878615035: {
                        this.updateDrawImageEdit();
                        continue block5;
                    }
                    case -1502128971: {
                        this.updateDrawShape();
                    }
                }
            }
        } else {
            Node valueNode = XFAFormStream.lookForChild(node, 111972721);
            if (valueNode != null) {
                this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
                this.updateDrawShape();
            } else {
                XFADraw.drawBorder(dvr, node, this.coordsXYWH);
            }
        }
    }

    private static void handleAnchorType(String ancType, double[] coordsXYWH) {
        switch (ancType.hashCode()) {
            case 1781909088: {
                coordsXYWH[0] = coordsXYWH[0] - coordsXYWH[2] / 2.0;
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3];
                break;
            }
            case -1682792238: {
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3];
                break;
            }
            case -621290831: {
                coordsXYWH[0] = coordsXYWH[0] - coordsXYWH[2];
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3];
                break;
            }
            case -641184182: {
                coordsXYWH[0] = coordsXYWH[0] - coordsXYWH[2] / 2.0;
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3] / 2.0;
                break;
            }
            case -818275524: {
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3] / 2.0;
                break;
            }
            case 408923527: {
                coordsXYWH[0] = coordsXYWH[0] - coordsXYWH[2];
                coordsXYWH[1] = coordsXYWH[1] + coordsXYWH[3] / 2.0;
                break;
            }
            case -696883702: {
                coordsXYWH[0] = coordsXYWH[0] - coordsXYWH[2] / 2.0;
                break;
            }
            case -1140120836: {
                break;
            }
            case -978346553: {
                coordsXYWH[0] = coordsXYWH[0] + coordsXYWH[2];
            }
        }
    }

    private void updateDrawTextExit() {
        int hAlign = 3317767;
        int vAlign = 115029;
        block13: for (int z = 0; z < this.node.getChildNodes().getLength(); ++z) {
            Node child = this.node.getChildNodes().item(z);
            switch (child.getNodeName().hashCode()) {
                case 111972721: {
                    Node exNode = XFAFormStream.lookForChild(child, -1290477827);
                    if (exNode != null) {
                        try {
                            this.captionData = XFADraw.getTextFromExData(exNode);
                            this.isCaptionHTML = true;
                        }
                        catch (TransformerException e) {
                            this.isCaptionHTML = false;
                            this.captionData = exNode.getTextContent().trim();
                            LogWriter.writeLog("XML parsing error " + e);
                        }
                        continue block13;
                    }
                    Node textNode = XFAFormStream.lookForChild(child, 3556653);
                    if (textNode == null) continue block13;
                    this.captionData = textNode.getTextContent();
                    continue block13;
                }
                case 3433440: {
                    block14: for (int i = 0; i < child.getAttributes().getLength(); ++i) {
                        String atrName = child.getAttributes().item(i).getNodeName();
                        String atrValue = child.getAttributes().item(i).getNodeValue();
                        switch (atrName.hashCode()) {
                            case -1254185091: {
                                hAlign = atrValue.hashCode();
                                continue block14;
                            }
                            case -853376977: {
                                vAlign = atrValue.hashCode();
                                continue block14;
                            }
                            case 1970934485: {
                                this.paraMarginLeft = XFAUtils.convertToPoints(atrValue);
                                continue block14;
                            }
                            case 975087886: {
                                this.paraMarginRight = XFAUtils.convertToPoints(atrValue);
                            }
                        }
                    }
                    continue block13;
                }
                case 3148879: {
                    this.capFontInfo = XFontInfo.getFontInfoFromNode(child);
                }
            }
        }
        XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        if (this.captionData != null) {
            if (hAlign == 108511772 && !this.isCaptionHTML) {
                this.captionData = this.captionData.trim();
            }
            if (!this.isCaptionHTML) {
                this.captionData = this.captionData.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            }
            GraphicsState gs = new GraphicsState(0, 0);
            gs.setFillType(1);
            float[][] trm = new float[3][3];
            trm[2][0] = (float)this.coordsXYWH[0];
            trm[2][1] = (float)this.coordsXYWH[1];
            if (this.isCaptionHTML) {
                this.parseHTML(this.coordsXYWH, this.box, this.capFontInfo, this.captionData, hAlign, vAlign);
            } else {
                trm[0][0] = this.capFontInfo.getSize();
                trm[1][1] = this.capFontInfo.getSize();
                this.alignText(this.coordsXYWH, this.capFontInfo, hAlign, vAlign, this.captionData, this.box);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getTextFromExData(Node exNode) throws TransformerException {
        TransformerFactory transFactory = SecureTransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        String text = null;
        try (StringWriter buffer = new StringWriter();){
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            Node bodyNode = XFAFormStream.lookForChild(exNode, 3029410);
            if (bodyNode == null) {
                String string = "";
                return string;
            }
            NodeList list = ((Element)bodyNode).getElementsByTagName("span");
            for (int i = 0; i < list.getLength(); ++i) {
                Node spanNode = list.item(i);
                String style = ((Element)spanNode).getAttribute("style");
                if (!"xfa-spacerun:yes".equals(style)) continue;
                int runLen = spanNode.getTextContent().length();
                StringBuilder runs = new StringBuilder(runLen);
                for (int j = 0; j < runLen; ++j) {
                    runs.append(' ');
                }
                spanNode.setTextContent(runs.toString());
            }
            transformer.transform(new DOMSource(bodyNode), new StreamResult(buffer));
            text = buffer.toString();
            return text;
        }
        catch (IOException e) {
            LogWriter.writeLog(e);
        }
        return text;
    }

    public static void drawParentBorder(DynamicVectorRenderer dvr, Node node, double[] coords) {
        for (int z = 0; z < node.getChildNodes().getLength(); ++z) {
            Node child = node.getChildNodes().item(z);
            if (child.getNodeName().hashCode() != -1383304148) continue;
            for (int a = 0; a < child.getAttributes().getLength(); ++a) {
                int value;
                String atrName = child.getAttributes().item(a).getNodeName();
                String atrValue = child.getAttributes().item(a).getNodeValue();
                if (atrName.hashCode() != -1276666629 || (value = atrValue.hashCode()) != -1217487446 && value != -1901805651) continue;
                return;
            }
            block6: for (int c = 0; c < child.getChildNodes().getLength(); ++c) {
                Node cNode = child.getChildNodes().item(c);
                switch (cNode.getNodeName().hashCode()) {
                    case -1354665387: 
                    case 3108285: {
                        continue block6;
                    }
                    case 3143043: {
                        XFADraw.fill(dvr, coords, cNode);
                    }
                }
            }
        }
    }

    public static void drawBorder(DynamicVectorRenderer dvr, Node node, double[] coords) {
        for (int z = 0; z < node.getChildNodes().getLength(); ++z) {
            Node child = node.getChildNodes().item(z);
            if (child.getNodeName().hashCode() != -1383304148) continue;
            for (int a = 0; a < child.getAttributes().getLength(); ++a) {
                int value;
                String atrName = child.getAttributes().item(a).getNodeName();
                String atrValue = child.getAttributes().item(a).getNodeValue();
                if (atrName.hashCode() != -1276666629 || (value = atrValue.hashCode()) != -1217487446 && value != -1901805651) continue;
                return;
            }
            int edgeCount = 0;
            PdfColor edgeColor = null;
            double thickness = 1.0;
            double[] temp = new double[]{coords[0], coords[1], coords[2], coords[3]};
            boolean isHidden = false;
            block13: for (int c = 0; c < child.getChildNodes().getLength(); ++c) {
                Node cNode = child.getChildNodes().item(c);
                switch (cNode.getNodeName().hashCode()) {
                    case 3108285: {
                        ++edgeCount;
                        Node presAttr = cNode.getAttributes().getNamedItem("presence");
                        isHidden = presAttr != null && presAttr.getNodeValue().hashCode() == -1217487446;
                        for (int a = 0; a < cNode.getAttributes().getLength(); ++a) {
                            Node attr = cNode.getAttributes().item(a);
                            if (attr.getNodeName().hashCode() != -1007552652) continue;
                            thickness = XFAUtils.convertToPoints(attr.getNodeValue());
                        }
                        Node eColor = XFAFormStream.lookForChild(cNode, 94842723);
                        edgeColor = eColor != null && eColor.hasAttributes() ? XFADraw.setEdgeColor(edgeColor, eColor) : new PdfColor(0, 0, 0);
                        if (isHidden) continue block13;
                        switch (edgeCount) {
                            case 1: {
                                XFADraw.drawLine(dvr, temp[0] + temp[2], temp[1] + temp[3], temp[0], temp[1] + temp[3], thickness, edgeColor);
                                break;
                            }
                            case 2: {
                                XFADraw.drawLine(dvr, temp[0] + temp[2], temp[1], temp[0] + temp[2], temp[1] + temp[3], thickness, edgeColor);
                                break;
                            }
                            case 3: {
                                XFADraw.drawLine(dvr, temp[0], temp[1], temp[0] + temp[2], temp[1], thickness, edgeColor);
                                break;
                            }
                            case 4: {
                                XFADraw.drawLine(dvr, temp[0], temp[1] + temp[3], temp[0], temp[1], thickness, edgeColor);
                            }
                        }
                        continue block13;
                    }
                    case -1354665387: {
                        continue block13;
                    }
                    case 3143043: {
                        XFADraw.fill(dvr, coords, cNode);
                    }
                }
            }
            if (edgeCount != true || isHidden) continue;
            XFADraw.drawRoundRect(dvr, temp, 1, edgeColor, thickness, 0.0);
        }
    }

    private static void fill(DynamicVectorRenderer dvr, double[] coords, Node cNode) {
        Node color = XFAFormStream.lookForChild(cNode, 94842723);
        PdfColor fillColorMain = new PdfColor(255, 255, 255);
        PdfColor fillColorSecond = new PdfColor(0, 0, 0);
        int mainShading = -1;
        int secondShading = -1;
        if (color != null && color.hasAttributes()) {
            fillColorMain = XFADraw.getFromColorNode(color);
        }
        for (int i = 0; i < cNode.getChildNodes().getLength(); ++i) {
            Node shadeColorNode;
            Node fillChild = cNode.getChildNodes().item(i);
            switch (fillChild.getNodeName().hashCode()) {
                case -1102672091: {
                    mainShading = -1102672091;
                    secondShading = -1166960543;
                    break;
                }
                case -938579425: {
                    mainShading = -938579425;
                    secondShading = -869319976;
                    break;
                }
                case -791090288: {
                    mainShading = -791090288;
                    secondShading = 1387629604;
                }
            }
            if (fillChild.hasAttributes() && fillChild.getAttributes().getNamedItem("type") != null) {
                Node type = fillChild.getAttributes().getNamedItem("type");
                secondShading = type.getNodeValue().hashCode();
            }
            if ((shadeColorNode = XFAFormStream.lookForChild(fillChild, 94842723)) == null || !shadeColorNode.hasAttributes()) continue;
            fillColorSecond = XFADraw.getFromColorNode(shadeColorNode);
        }
        if (mainShading != -1) {
            switch (mainShading) {
                case -1102672091: 
                case -938579425: {
                    XFADraw.drawShadedRect(dvr, coords, fillColorMain, fillColorSecond, secondShading);
                    break;
                }
                case -791090288: {
                    XFADraw.drawPatternedRect(dvr, coords, fillColorMain, fillColorSecond, secondShading);
                }
            }
        } else {
            XFADraw.drawRoundRect(dvr, coords, 2, fillColorMain, 1.0, 0.0);
        }
    }

    private static PdfColor setEdgeColor(PdfColor edgeColor, Node eColor) {
        for (int col = 0; col < eColor.getAttributes().getLength(); ++col) {
            if (eColor.getAttributes().item(col).getNodeName().hashCode() != 111972721) continue;
            String colStr = eColor.getAttributes().item(col).getNodeValue();
            String[] str = colStr.split(",");
            int[] rgb = new int[3];
            for (int cc = 0; cc < 3; ++cc) {
                rgb[cc] = Integer.parseInt(str[cc]);
            }
            edgeColor = new PdfColor(rgb[0], rgb[1], rgb[2]);
        }
        return edgeColor;
    }

    private static PdfColor getFromColorNode(Node color) {
        for (int col = 0; col < color.getAttributes().getLength(); ++col) {
            if (color.getAttributes().item(col).getNodeName().hashCode() != 111972721) continue;
            String colStr = color.getAttributes().item(col).getNodeValue();
            String[] str = colStr.split(",");
            int[] rgb = new int[3];
            for (int cc = 0; cc < 3; ++cc) {
                rgb[cc] = Integer.parseInt(str[cc]);
            }
            return new PdfColor(rgb[0], rgb[1], rgb[2]);
        }
        return new PdfColor(255, 255, 255);
    }

    private void updateDrawImageEdit() {
        Node imageNode;
        boolean is64 = true;
        byte[] dataBytes = null;
        BufferedImage bi = null;
        Node vn = XFAFormStream.lookForChild(this.node, 111972721);
        Node aspect = null;
        String hrefValue = null;
        String imageString = null;
        if (vn != null && (imageNode = XFAFormStream.lookForChild(vn, 100313435)) != null) {
            Node hrefNode = imageNode.getAttributes().getNamedItem("href");
            aspect = imageNode.getAttributes().getNamedItem("aspect");
            if (hrefNode != null) {
                hrefValue = hrefNode.getNodeValue();
                NameLookup nameLookup = this.currentPdfFile.getNamesLookup();
                if (nameLookup.containsKey(hrefValue)) {
                    dataBytes = (byte[])nameLookup.get(hrefValue);
                    try {
                        bi = JDeli.read(dataBytes);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("XML parsing error " + e);
                    }
                    is64 = false;
                }
            } else {
                imageString = imageNode.getTextContent();
            }
        }
        try {
            if (imageString != null || dataBytes != null) {
                try {
                    if (is64) {
                        dataBytes = XFAFormStream.decode64(imageString);
                    }
                    bi = JDeli.read(dataBytes);
                    GraphicsState gs = new GraphicsState();
                    gs.CTM[0][0] = (float)this.coordsXYWH[2];
                    gs.CTM[1][1] = (float)this.coordsXYWH[3];
                    int x = (int)this.coordsXYWH[0];
                    int y = (int)this.coordsXYWH[1];
                    if (aspect == null) {
                        if (bi != null) {
                            Rectangle rectA = XFAUtils.propotionate(bi.getWidth(), bi.getHeight(), this.coordsXYWH[2], this.coordsXYWH[3]);
                            y = (int)(this.coordsXYWH[1] + this.coordsXYWH[3] - rectA.getHeight());
                            gs.CTM[0][0] = (float)rectA.getWidth();
                            gs.CTM[1][1] = (float)rectA.getHeight();
                        }
                    } else {
                        y = XFADraw.setAspect(bi, aspect, gs, y, this.coordsXYWH);
                    }
                    gs.x = x;
                    gs.y = y;
                    gs.CTM[2][0] = x;
                    gs.CTM[2][1] = y;
                    if (bi != null && bi.getType() == 0) {
                        bi = ColorSpaceConvertor.convertToARGB(bi);
                    }
                    this.dvr.drawImage(1, bi, gs, false, null, -1);
                }
                catch (Exception ex) {
                    LogWriter.writeLog("Negative size error " + ex);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception in image data " + e);
        }
    }

    private static int setAspect(BufferedImage bi, Node aspect, GraphicsState gs, int y, double[] coordsXYWH) {
        switch (aspect.getNodeValue().hashCode()) {
            case -1422939762: {
                break;
            }
            case 101393: {
                Rectangle rectA = XFAUtils.propotionate(bi.getWidth(), bi.getHeight(), coordsXYWH[2], coordsXYWH[3]);
                y = (int)(coordsXYWH[1] + coordsXYWH[3] - rectA.getHeight());
                gs.CTM[0][0] = (float)rectA.getWidth();
                gs.CTM[1][1] = (float)rectA.getHeight();
                break;
            }
            case -1221029593: {
                double scaleH = coordsXYWH[3] / (double)bi.getHeight();
                gs.CTM[0][0] = (float)((double)bi.getWidth() * scaleH);
                gs.CTM[1][1] = (float)coordsXYWH[3];
                break;
            }
            case 3387192: {
                gs.CTM[0][0] = (float)coordsXYWH[2];
                gs.CTM[1][1] = (float)coordsXYWH[3];
                break;
            }
            case 113126854: {
                double scaleW = coordsXYWH[2] / (double)bi.getWidth();
                gs.CTM[0][0] = (float)coordsXYWH[2];
                gs.CTM[1][1] = (float)((double)bi.getHeight() * scaleW);
                y = (int)(coordsXYWH[1] + coordsXYWH[3] - (double)gs.CTM[1][1]);
            }
        }
        return y;
    }

    private void updateDrawShape() {
        Node valueNode = XFAFormStream.lookForChild(this.node, 111972721);
        if (valueNode != null) {
            NodeList childList = valueNode.getChildNodes();
            block7: for (int z = 0; z < childList.getLength(); ++z) {
                String cName = childList.item(z).getNodeName();
                switch (cName.hashCode()) {
                    case -1290477827: 
                    case 3556653: {
                        this.updateDrawTextExit();
                        continue block7;
                    }
                    case 100313435: {
                        this.drawImage(childList, z);
                        continue block7;
                    }
                    case 1121299823: {
                        this.drawShape(childList, z);
                        continue block7;
                    }
                    case 3321844: {
                        this.drawLine();
                        continue block7;
                    }
                    case 96850: {
                        this.drawArc(childList, z);
                    }
                }
            }
        }
    }

    private void drawArc(NodeList childList, int z) {
        BufferedImage arcImage = new BufferedImage((int)this.fullBound[2], (int)this.fullBound[3], 2);
        Graphics2D g2 = arcImage.createGraphics();
        double startAngle = 0.0;
        double sweepAngle = 360.0;
        boolean isCircle = false;
        Color fillColor = null;
        Node arcNode = childList.item(z);
        block5: for (int a = 0; a < arcNode.getAttributes().getLength(); ++a) {
            String aName = arcNode.getAttributes().item(a).getNodeName();
            String aValue = arcNode.getAttributes().item(a).getNodeValue();
            switch (aName.hashCode()) {
                case -1601031791: {
                    startAngle = Double.parseDouble(aValue);
                    continue block5;
                }
                case 1180683591: {
                    sweepAngle = Double.parseDouble(aValue);
                    continue block5;
                }
                case -1498085729: {
                    isCircle = true;
                }
            }
        }
        for (int c = 0; c < arcNode.getChildNodes().getLength(); ++c) {
            Node colorNode;
            Node temp = arcNode.getChildNodes().item(c);
            if (temp.getNodeName().hashCode() != 3143043 || (colorNode = XFAFormStream.lookForChild(temp, 94842723)) == null || !colorNode.hasAttributes()) continue;
            String colStr = colorNode.getAttributes().getNamedItem("value").getNodeValue();
            String[] rgbs = colStr.split(",");
            fillColor = new Color(Integer.parseInt(rgbs[0]), Integer.parseInt(rgbs[1]), Integer.parseInt(rgbs[2]));
        }
        if (isCircle) {
            g2.setColor(Color.BLACK);
            double min = Math.min(this.fullBound[2], this.fullBound[3]);
            Arc2D.Double arc = new Arc2D.Double(0.0, 0.0, min, min, startAngle, sweepAngle, 0);
            g2.draw(arc);
            if (fillColor != null) {
                g2.setColor(fillColor);
                g2.fill(arc);
            }
        } else {
            g2.setColor(Color.BLACK);
            Arc2D.Double arc = new Arc2D.Double(0.0, 0.0, this.fullBound[2], this.fullBound[3], startAngle, sweepAngle, 0);
            g2.draw(arc);
            if (fillColor != null) {
                g2.setColor(fillColor);
                g2.fill(arc);
            }
        }
        GraphicsState arcGS = new GraphicsState();
        arcGS.x = (float)this.fullBound[0];
        arcGS.y = (float)this.fullBound[1];
        arcGS.CTM[2][0] = 0.0f;
        arcGS.CTM[2][1] = 0.0f;
        arcGS.CTM[0][0] = (float)this.fullBound[2];
        arcGS.CTM[1][1] = (float)this.fullBound[3];
        this.dvr.drawImage(1, arcImage, arcGS, false, null, -1);
    }

    private void drawLine() {
        Element colorEle;
        String value;
        Node color;
        Node thickAtr;
        double[] arr = new double[4];
        System.arraycopy(this.coordsXYWH, 0, arr, 0, 4);
        double thickness = 1.0;
        PdfColor lineColor = new PdfColor(0, 0, 0);
        Node edge = ((Element)this.node).getElementsByTagName("edge").item(0);
        if (edge != null && edge.hasAttributes() && (thickAtr = edge.getAttributes().getNamedItem("thickness")) != null) {
            thickness = XFAUtils.convertToPoints(thickAtr.getNodeValue());
        }
        if ((color = ((Element)this.node).getElementsByTagName("color").item(0)) != null && !(value = (colorEle = (Element)color).getAttribute("value")).isEmpty()) {
            String[] str = value.split(",");
            lineColor = new PdfColor(Integer.parseInt(str[0]), Integer.parseInt(str[1]), Integer.parseInt(str[2]));
        }
        arr[1] = arr[1] + this.box.getMarginBottom();
        arr[3] = arr[3] - this.box.getMarginBottom() - this.box.getMarginTop();
        XFADraw.drawLine(this.dvr, arr[0], arr[1], arr[0] + arr[2], arr[1] + arr[3], thickness, lineColor);
    }

    private void drawShape(NodeList childList, int z) {
        Node rect = childList.item(z);
        PdfColor edgeColor = new PdfColor(0, 0, 0);
        PdfColor rectFillColor = null;
        boolean hasEdge = false;
        double cornerAngle = 0.0;
        block4: for (int r = 0; r < rect.getChildNodes().getLength(); ++r) {
            Node rectChild = rect.getChildNodes().item(r);
            switch (rectChild.getNodeName().hashCode()) {
                case 3108285: {
                    hasEdge = true;
                    Node colorNode = XFAFormStream.lookForChild(rectChild, 94842723);
                    if (colorNode == null || !colorNode.hasAttributes()) continue block4;
                    String colStr = colorNode.getAttributes().getNamedItem("value").getNodeValue();
                    String[] rgbs = colStr.split(",");
                    edgeColor = new PdfColor(Integer.parseInt(rgbs[0]), Integer.parseInt(rgbs[1]), Integer.parseInt(rgbs[2]));
                    continue block4;
                }
                case 3143043: {
                    Node color = XFAFormStream.lookForChild(rectChild, 94842723);
                    if (color == null || !color.hasAttributes() || color.getAttributes().getNamedItem("value") == null) continue block4;
                    String colStr = color.getAttributes().getNamedItem("value").getNodeValue();
                    String[] rgbs = colStr.split(",");
                    rectFillColor = new PdfColor(Integer.parseInt(rgbs[0]), Integer.parseInt(rgbs[1]), Integer.parseInt(rgbs[2]));
                    continue block4;
                }
            }
        }
        if (hasEdge) {
            XFADraw.drawRoundRect(this.dvr, this.coordsXYWH, 1, edgeColor, 1.0, 0.0);
        }
        if (rectFillColor != null) {
            XFADraw.drawRoundRect(this.dvr, this.coordsXYWH, 2, rectFillColor, 1.0, 0.0);
        }
        if (!hasEdge && rectFillColor == null) {
            XFADraw.drawRoundRect(this.dvr, this.coordsXYWH, 1, new PdfColor(0, 0, 0), 1.0, 0.0);
        }
    }

    private void drawImage(NodeList childList, int z) {
        Node aspect = childList.item(z).getAttributes().getNamedItem("aspect");
        String imageString = childList.item(z).getTextContent();
        try {
            if (imageString != null && imageString.length() > 1) {
                byte[] dataBytes = XFAFormStream.decode64(imageString);
                BufferedImage bi = JDeli.read(dataBytes);
                GraphicsState gs = new GraphicsState();
                gs.CTM[0][0] = (float)this.coordsXYWH[2];
                gs.CTM[1][1] = (float)this.coordsXYWH[3];
                gs.x = (float)this.coordsXYWH[0];
                int x = (int)this.coordsXYWH[0];
                int y = (int)this.coordsXYWH[1];
                if (aspect == null) {
                    if (bi != null) {
                        Rectangle rectA = XFAUtils.propotionate(bi.getWidth(), bi.getHeight(), this.coordsXYWH[2], this.coordsXYWH[3]);
                        y = (int)(this.coordsXYWH[1] + this.coordsXYWH[3] - rectA.getHeight());
                        gs.CTM[0][0] = (float)rectA.getWidth();
                        gs.CTM[1][1] = (float)rectA.getHeight();
                    }
                } else {
                    y = XFADraw.setAspect(bi, aspect, gs, y, this.coordsXYWH);
                }
                gs.x = x;
                gs.y = y;
                gs.CTM[2][0] = x;
                gs.CTM[2][1] = y;
                if (bi != null && bi.getType() == 0) {
                    bi = ColorSpaceConvertor.convertToARGB(bi);
                }
                this.dvr.drawImage(1, bi, gs, false, null, -1);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("XML parsing error " + e);
        }
    }

    private static void drawLine(DynamicVectorRenderer dvr, double fromX, double fromY, double toX, double toY, double thick, PdfColor pdfColor) {
        GraphicsState gs = new GraphicsState();
        gs.setFillType(1);
        if (pdfColor != null) {
            gs.strokeColorSpace.setColor(pdfColor);
        }
        gs.setLineWidth((float)(thick / 1.53));
        SwingShape lineShape = new SwingShape();
        lineShape.moveTo((float)fromX, (float)fromY);
        lineShape.lineTo((float)toX, (float)toY);
        float[][] lineCtm = new float[3][3];
        lineCtm[0][0] = 1.0f;
        lineCtm[1][1] = 1.0f;
        lineCtm[2][2] = 1.0f;
        Shape lineResult = lineShape.generateShapeFromPath(lineCtm, 3.0f, 0);
        dvr.drawShape(new SwingShape(lineResult), gs, 83);
    }

    private void alignText(double[] formCoords, XFontInfo fontInfo, int hAlign, int vAlign, String captionData, XBox box) {
        GraphicsState gs = new GraphicsState(0, 0);
        gs.setFillType(2);
        gs.nonstrokeColorSpace.setColor(fontInfo.getColor());
        double x = formCoords[0] + box.getMarginLeft() + this.paraMarginLeft;
        double y = formCoords[1] + box.getMarginBottom();
        double w = formCoords[2] - box.getMarginRight() - box.getMarginLeft() - this.paraMarginLeft - this.paraMarginRight;
        double h = formCoords[3] - box.getMarginTop() - box.getMarginBottom();
        float[][] trm = new float[3][3];
        trm[0][0] = fontInfo.getSize();
        trm[1][1] = fontInfo.getSize();
        float descent = (float)fontInfo.getSize() * 0.02f;
        double fontHeight = fontInfo.getSize();
        double totalWidth = XFAFormStream.getTempTotalWidth(fontInfo, captionData, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
        if (box.hasMinW) {
            lineMap.put(1, captionData);
        } else {
            lineMap = XFAFormStream.getTotalLines(w, captionData, fontInfo, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        }
        if (lineMap.size() == 1) {
            this.setSingleLine(fontInfo, hAlign, vAlign, gs, x, y, w, h, trm, descent, fontHeight, totalWidth, lineMap);
        } else {
            this.setMultiLine(fontInfo, hAlign, vAlign, gs, x, y, w, h, trm, (float)fontHeight, lineMap);
        }
    }

    private void setMultiLine(XFontInfo fontInfo, int hAlign, int vAlign, GraphicsState gs, double x, double y, double w, double h, float[][] trm, float fontHeight, HashMap<Integer, String> lineMap) {
        int totalHeight = fontInfo.getSize() * lineMap.size();
        switch (vAlign) {
            case 115029: {
                trm[2][1] = (float)h;
                break;
            }
            case -1074341483: {
                if (h <= (double)totalHeight) {
                    trm[2][1] = (float)h;
                    break;
                }
                trm[2][1] = (float)(h - (h - (double)totalHeight) / 2.0);
                break;
            }
            case -1383228885: {
                trm[2][1] = h < (double)totalHeight ? (float)h : (float)(h - (h - (double)totalHeight));
            }
        }
        float[] fArray = trm[2];
        fArray[1] = fArray[1] + (float)y;
        for (int z = 1; z <= lineMap.size(); ++z) {
            String text = lineMap.get(z);
            switch (hAlign) {
                case -1364013995: {
                    double tc = XFAFormStream.getTempTotalWidth(fontInfo, text, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    trm[2][0] = (float)((w - tc) / 2.0 + x);
                    break;
                }
                case 108511772: {
                    double tr = XFAFormStream.getTempTotalWidth(fontInfo, text, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    trm[2][0] = w > 0.0 ? (float)(w - tr + x) : (float)x;
                    break;
                }
                default: {
                    trm[2][0] = (float)x;
                }
            }
            float[] fArray2 = trm[2];
            fArray2[1] = fArray2[1] - fontHeight;
            this.drawEmbeddedText((int)trm[2][0], (int)trm[2][1], gs, text, fontInfo);
        }
    }

    private void setSingleLine(XFontInfo fontInfo, int hAlign, int vAlign, GraphicsState gs, double x, double y, double w, double h, float[][] trm, float descent, double fontHeight, double totalWidth, HashMap<Integer, String> lineMap) {
        switch (hAlign) {
            case -1364013995: {
                trm[2][0] = (float)((w - totalWidth) / 2.0 + x);
                break;
            }
            case 108511772: {
                trm[2][0] = w > 0.0 ? (float)(w - totalWidth + x) : (float)x;
                break;
            }
            default: {
                trm[2][0] = (float)x;
            }
        }
        switch (vAlign) {
            case 115029: {
                if (h > 0.0) {
                    trm[2][1] = (float)(y + h - fontHeight);
                    break;
                }
                trm[2][1] = (float)(y - fontHeight);
                break;
            }
            case -1074341483: {
                if (h > 0.0) {
                    trm[2][1] = h > fontHeight ? (float)(y + (h - fontHeight) / 2.0) : (float)y + descent;
                    break;
                }
                trm[2][1] = (float)(y + fontHeight);
                break;
            }
            case -1383228885: {
                trm[2][1] = (float)(y + (double)descent);
            }
        }
        this.drawEmbeddedText((int)trm[2][0], (int)trm[2][1], gs, lineMap.get(1), fontInfo);
    }

    private void drawEmbeddedText(int textX, int textY, GraphicsState gs, String data, XFontInfo fontInfo) {
        this.decoder.incrementTokenNumber();
        PdfFont currentFont = XFAFormStream.resolveFont(fontInfo, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        this.textDecoder.setGS(gs);
        TextState currentTextState = new TextState();
        currentTextState.Tm = new float[][]{{fontInfo.getSize(), 0.0f, 0.0f}, {0.0f, fontInfo.getSize(), 0.0f}, {textX, textY, 1.0f}};
        currentTextState.setTMAtLineStart();
        byte[] dummyJJstring = this.createFakeDAforXFA(data);
        if (dummyJJstring != null) {
            this.textDecoder.TJ(currentTextState, currentFont, dummyJJstring, 0, dummyJJstring.length, false);
        }
    }

    private byte[] createFakeDAforXFA(String data) {
        data = data.replace("(", "\\(");
        data = data.replace(")", "\\)");
        String dummyJJstring = '(' + data + ")tj";
        dummyJJstring = "BT 0 0 0 RG " + this.capFontInfo.getTypeFace() + ' ' + this.capFontInfo.getSize() + " Tf 1 TFS " + dummyJJstring;
        if (DecoderOptions.isRunningOnWindows) {
            return dummyJJstring.getBytes();
        }
        try {
            return dummyJJstring.getBytes("Cp1252");
        }
        catch (UnsupportedEncodingException ex) {
            LogWriter.writeLog("XML parsing encoding exception " + ex);
            return null;
        }
    }

    private static void drawRoundRect(DynamicVectorRenderer render, double[] area, int fillType, PdfColor pdfColor, double thickness, double cornerAngle) {
        GraphicsState gs = new GraphicsState();
        gs.setFillType(fillType);
        switch (fillType) {
            case 1: {
                gs.strokeColorSpace.setColor(pdfColor);
                break;
            }
            case 2: {
                gs.nonstrokeColorSpace.setColor(pdfColor);
            }
        }
        if (render != null) {
            if (cornerAngle > 0.0) {
                RoundRectangle2D.Double rect = new RoundRectangle2D.Double((int)area[0], (int)area[1], (int)area[2], (int)area[3], cornerAngle, cornerAngle);
                render.drawShape(new SwingShape(rect), gs, 83);
            } else {
                switch (fillType) {
                    case 1: {
                        XFADraw.drawLine(render, area[0] + area[2], area[1] + area[3], area[0], area[1] + area[3], thickness, pdfColor);
                        XFADraw.drawLine(render, area[0] + area[2], area[1], area[0] + area[2], area[1] + area[3], thickness, pdfColor);
                        XFADraw.drawLine(render, area[0], area[1], area[0] + area[2], area[1], thickness, pdfColor);
                        XFADraw.drawLine(render, area[0], area[1] + area[3], area[0], area[1], thickness, pdfColor);
                        break;
                    }
                    case 2: {
                        float[][] ctm = new float[3][3];
                        ctm[0][0] = 1.0f;
                        ctm[1][1] = 1.0f;
                        ctm[2][2] = 1.0f;
                        SwingShape pdfShape = new SwingShape();
                        pdfShape.appendRectangle((float)area[0], (float)area[1], (float)area[2], (float)area[3]);
                        Shape result = pdfShape.generateShapeFromPath(ctm, 3.0f, 0);
                        render.drawShape(new SwingShape(result), gs, 83);
                    }
                }
            }
        }
    }

    private static void drawShadedRect(DynamicVectorRenderer render, double[] area, PdfColor startColor, PdfColor endColor, int shadeDirection) {
        boolean isLinear = true;
        GraphicsState gs = new GraphicsState();
        gs.CTM[0][0] = (float)area[2];
        gs.CTM[1][1] = (float)area[3];
        int x = (int)area[0];
        int y = (int)area[1];
        int w = (int)area[2];
        int h = (int)area[3];
        gs.x = x;
        gs.y = y;
        gs.CTM[2][0] = x;
        gs.CTM[2][1] = y;
        int xDir = 0;
        int yDir = 0;
        switch (shadeDirection) {
            case -869110494: {
                xDir = -1;
                break;
            }
            case -1166960543: {
                xDir = 1;
                break;
            }
            case 2026802310: {
                yDir = 1;
                break;
            }
            case 110519514: {
                yDir = -1;
                break;
            }
            case 2046017200: {
                isLinear = false;
                xDir = -1;
                break;
            }
            case -869319976: {
                isLinear = false;
                xDir = 1;
            }
        }
        SwingShape r = new SwingShape();
        r.moveTo(x, y);
        r.lineTo(x + w, y);
        r.lineTo(x + w, y + h);
        r.lineTo(x, y + h);
        r.closeShape();
        PdfPaint color = isLinear ? XFAShadingFactory.createLinearXFAShading(new float[]{x, y, x + w, y + h}, xDir, yDir, startColor, endColor, 0) : XFAShadingFactory.createLinearXFAShading(new float[]{x, y, x + w, y + h}, xDir, yDir, startColor, endColor, 1);
        gs.nonstrokeColorSpace.setColor(color);
        gs.setFillType(2);
        render.drawShape(new SwingShape(r.generateShapeFromPath(new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}, 3.0f, 0)), gs, 83);
    }

    private static void drawPatternedRect(DynamicVectorRenderer render, double[] area, PdfColor startColor, PdfColor endColor, int patternType) {
        GraphicsState gs = new GraphicsState();
        gs.CTM[0][0] = (float)area[2];
        gs.CTM[1][1] = (float)area[3];
        int x = (int)area[0];
        int y = (int)area[1];
        int w = (int)area[2];
        int h = (int)area[3];
        int type = -1;
        gs.x = x;
        gs.y = y;
        gs.CTM[2][0] = x;
        gs.CTM[2][1] = y;
        SwingShape r = new SwingShape();
        r.moveTo(x, y);
        r.lineTo(x + w, y);
        r.lineTo(x + w, y + h);
        r.lineTo(x, y + h);
        r.closeShape();
        switch (patternType) {
            case -2041562987: {
                type = 3;
                break;
            }
            case -1145410084: {
                type = 4;
                break;
            }
            case -1142313241: {
                type = 5;
                break;
            }
            case 1387629604: {
                type = 6;
                break;
            }
            case -1984141450: {
                type = 7;
            }
        }
        PdfPaint color = XFAShadingFactory.createLinearXFAShading(new float[]{x, y, x + w, y + h}, 0, 0, startColor, endColor, type);
        gs.nonstrokeColorSpace.setColor(color);
        gs.setFillType(2);
        render.drawShape(new SwingShape(r.generateShapeFromPath(new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}, 3.0f, 0)), gs, 83);
    }

    private void updateHTMLList(String htmlData, final ArrayList<XRect> rects, final ArrayList<String> texts, final ArrayList<ExDataStyle> styles, XFontInfo fontInfo, final double w) throws IOException {
        final Stack<ExDataStyle> stack = new Stack<ExDataStyle>();
        stack.push(new ExDataStyle(fontInfo));
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){
            double curX;
            double curY;
            double curW;

            @Override
            public void handleText(char[] charData, int pos) {
                ExDataStyle curStyle = (ExDataStyle)stack.peek();
                StringBuilder curLine = new StringBuilder();
                StringBuilder curWord = new StringBuilder();
                XFontInfo fInfo = curStyle.getFontInfo();
                double ww = w < 1.0 ? 696.0 : w;
                this.curW = 0.0;
                block4: for (char cc : charData) {
                    String cs = String.valueOf(cc);
                    double cw = XFAFormStream.getTempTotalWidth(fInfo, cs, XFADraw.this.decoder, XFADraw.this.fontCache, XFADraw.this.pdfFontFactory, XFADraw.this.currentPdfFile.getObjectStore());
                    if (this.curX + this.curW + cw > ww + 0.5) {
                        rects.add(new XRect(this.curX, this.curY, this.curW, 0.0));
                        styles.add(curStyle.substitute());
                        texts.add(curLine.toString());
                        this.curW = XFAFormStream.getTempTotalWidth(fInfo, curWord.toString(), XFADraw.this.decoder, XFADraw.this.fontCache, XFADraw.this.pdfFontFactory, XFADraw.this.currentPdfFile.getObjectStore());
                        curLine = new StringBuilder();
                        this.curY += (double)(curStyle.margins[0] + curStyle.size);
                        this.curX = 0.0;
                    }
                    this.curW += cw;
                    switch (cc) {
                        case '\n': {
                            rects.add(new XRect(this.curX, this.curY, this.curW, 0.0));
                            styles.add(curStyle.substitute());
                            texts.add(curLine.toString());
                            curWord = new StringBuilder();
                            curLine = new StringBuilder();
                            this.curY += (double)(curStyle.margins[0] + curStyle.size);
                            this.curX = 0.0;
                            this.curW = 0.0;
                            continue block4;
                        }
                        case '\u0000': 
                        case '\t': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            curLine.append((CharSequence)curWord).append(' ');
                            curWord = new StringBuilder();
                            continue block4;
                        }
                        default: {
                            curWord.append(cs);
                        }
                    }
                }
                String ss = curLine.append((CharSequence)curWord).toString();
                if (!ss.isEmpty()) {
                    rects.add(new XRect(this.curX, this.curY, 0.0, 0.0));
                    styles.add(curStyle.substitute());
                    texts.add(ss);
                    this.curX += this.curW;
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                ExDataStyle curStyle = ((ExDataStyle)stack.peek()).substitute();
                String styleStr = (String)a.getAttribute(HTML.Attribute.STYLE);
                curStyle.update(styleStr);
                if (t == HTML.Tag.P || t == HTML.Tag.SPAN || t == HTML.Tag.A) {
                    if (t == HTML.Tag.P) {
                        this.curX = curStyle.margins[3];
                        this.curY += (double)(curStyle.margins[0] + curStyle.size);
                    } else if (t == HTML.Tag.A) {
                        curStyle.color = new PdfColor(0, 0, 255);
                    }
                    stack.push(curStyle);
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.P || t == HTML.Tag.SPAN || t == HTML.Tag.A) {
                    ExDataStyle style = (ExDataStyle)stack.pop();
                    this.curY += (double)style.margins[2];
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.BR) {
                    ExDataStyle curStyle = (ExDataStyle)stack.peek();
                    this.curX = curStyle.margins[3];
                    this.curY += (double)(curStyle.margins[0] + curStyle.size);
                }
            }
        };
        new ParserDelegator().parse(new StringReader(htmlData), parserCallback, false);
    }

    private void parseHTML(double[] coords, XBox box, XFontInfo fontInfo, String htmlData, int hAlign, int vAlign) {
        double x = coords[0] + box.getMarginLeft();
        double y = coords[1] + box.getMarginBottom();
        double w = coords[2] - box.getMarginRight() - box.getMarginLeft();
        double h = coords[3] - box.getMarginTop() - box.getMarginBottom();
        ArrayList<XRect> rects = new ArrayList<XRect>();
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<ExDataStyle> styles = new ArrayList<ExDataStyle>();
        try {
            this.updateHTMLList(htmlData, rects, texts, styles, fontInfo, w);
            int total = rects.size();
            GraphicsState gs = new GraphicsState(0, 0);
            gs.setFillType(2);
            gs.nonstrokeColorSpace.setColor(fontInfo.getColor());
            LinkedHashMap<Double, ArrayList<ExDataStyle>> lines = new LinkedHashMap<Double, ArrayList<ExDataStyle>>();
            double totalHeight = 0.0;
            double ly = y;
            for (int i = 0; i < total; ++i) {
                double ry = rects.get(i).getY();
                ArrayList<ExDataStyle> v = (ArrayList<ExDataStyle>)lines.get(ry);
                ExDataStyle style = styles.get(i);
                style.rect = rects.get(i);
                style.content = texts.get(i);
                style.rect.setW(XFAFormStream.getTempTotalWidth(style.getFontInfo(), style.content.trim(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore()));
                totalHeight = Math.max(totalHeight, ry);
                if (v == null) {
                    v = new ArrayList<ExDataStyle>();
                    lines.put(ry, v);
                }
                v.add(style);
            }
            if (totalHeight < h) {
                switch (vAlign) {
                    case -1074341483: {
                        ly -= (h - totalHeight) / 2.0;
                        break;
                    }
                    case -1383228885: {
                        ly -= h - totalHeight;
                    }
                }
            }
            for (Double double1 : lines.keySet()) {
                double lineW = 0.0;
                for (ExDataStyle exDataStyle : (ArrayList)lines.get(double1)) {
                    lineW += exDataStyle.rect.getW();
                }
                double lx = x;
                double ww = w < 1.0 ? lineW : w;
                switch (hAlign) {
                    case 3317767: {
                        int lineAlign = ((ExDataStyle)((ArrayList)lines.get((Object)double1)).get((int)0)).textAlign;
                        switch (lineAlign) {
                            case -1364013995: {
                                lx = x + (ww - lineW) / 2.0;
                                break;
                            }
                            case 108511772: {
                                lx = x + (ww - lineW);
                            }
                        }
                        break;
                    }
                    case -1364013995: {
                        lx = x + (ww - lineW) / 2.0;
                        break;
                    }
                    case 108511772: {
                        lx = x + (ww - lineW);
                    }
                }
                for (ExDataStyle exDataStyle : (ArrayList)lines.get(double1)) {
                    int xx = (int)(lx + exDataStyle.rect.getX());
                    int yy = (int)(ly + h - exDataStyle.rect.getY());
                    XFontInfo fInfo = exDataStyle.getFontInfo();
                    gs.nonstrokeColorSpace.setColor(fInfo.getColor());
                    this.drawEmbeddedText(xx, yy, gs, exDataStyle.content, fInfo);
                }
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("XML parsing error " + e);
        }
    }

    public static HashMap<Integer, XFAStyle> parseExDataToMap(final XFontInfo fontInfo, String htmlData, final int hAlign) {
        final HashMap<Integer, XFAStyle> map = new HashMap<Integer, XFAStyle>();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){
            final Stack<String> styleStack = new Stack();
            int tagCount;

            @Override
            public void handleText(char[] data, int pos) {
                String str = new String(data);
                String styleStr = this.styleStack.peek();
                XFAStyle xStyle = new XFAStyle(styleStr, fontInfo, str, hAlign, this.styleStack);
                map.put(map.size(), xStyle);
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                String styleStr = (String)a.getAttribute(HTML.Attribute.STYLE);
                if ("xfa-spacerun:yes".equals(styleStr)) {
                    styleStr = null;
                }
                if (t == HTML.Tag.A) {
                    styleStr = styleStr == null ? "color:blue" : styleStr + ";color:#0000dd";
                }
                this.styleStack.push(styleStr);
                if (t == HTML.Tag.P || t == HTML.Tag.SPAN || t == HTML.Tag.A) {
                    if (t == HTML.Tag.P && this.tagCount != 0) {
                        XFAStyle temp = new XFAStyle(null, fontInfo, "<br/>", hAlign);
                        map.put(map.size(), temp);
                    }
                    ++this.tagCount;
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (!this.styleStack.isEmpty()) {
                    this.styleStack.pop();
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.BR) {
                    XFAStyle temp = new XFAStyle(null, fontInfo, "<br/>", hAlign);
                    map.put(map.size(), temp);
                }
            }
        };
        try {
            new ParserDelegator().parse(new StringReader(htmlData), parserCallback, false);
        }
        catch (IOException e) {
            LogWriter.writeLog("XML parsing error " + e);
        }
        return map;
    }

    public static double getHtmlDataHeight(double[] coords, XBox box, XFontInfo fontInfo, String htmlData, int hAlign, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        HashMap<Integer, ArrayList<XFAStyle>> lineMap = new HashMap<Integer, ArrayList<XFAStyle>>();
        HashMap<Integer, XFAStyle> map = XFADraw.parseExDataToMap(fontInfo, htmlData, hAlign);
        double maxW = coords[2] - box.getMarginRight() - box.getMarginLeft();
        if (box.getW() == 0.0) {
            XFADraw.handleNoWidth(lineMap, map);
        } else {
            double lineLen = 0.0;
            for (int z = 0; z < map.size(); ++z) {
                XFAStyle style = map.get(z);
                String dataStr = style.getStyleData();
                ArrayList<Object> list = new ArrayList<XFAStyle>();
                if ("<br/>".equals(style.getStyleData())) {
                    style.setStyleData("");
                    list.add(style);
                    lineMap.put(lineMap.size(), list);
                    lineLen = 0.0;
                    continue;
                }
                double dataLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), dataStr, decoder, fontCache, pdfFontFactory, objectStore);
                if (dataLen <= maxW - lineLen) {
                    if (lineMap.containsKey(lineMap.size() - 1)) {
                        lineMap.get(lineMap.size() - 1).add(style);
                    } else {
                        list.add(style);
                        lineMap.put(lineMap.size(), list);
                    }
                    lineLen += dataLen;
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder spaceB = new StringBuilder();
                for (int c = 0; c < dataStr.length(); ++c) {
                    String cStr = String.valueOf(dataStr.charAt(c));
                    double spaceLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), spaceB.toString(), decoder, fontCache, pdfFontFactory, objectStore);
                    double charLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), cStr, decoder, fontCache, pdfFontFactory, objectStore);
                    double availW = maxW - lineLen;
                    lineLen += charLen;
                    if (availW < charLen && !" ".equals(cStr)) {
                        XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                        if (lineMap.containsKey(lineMap.size() - 1)) {
                            list = lineMap.get(lineMap.size() - 1);
                            list.add(temp);
                            lineMap.put(lineMap.size(), new ArrayList());
                        } else {
                            list.add(temp);
                            lineMap.put(lineMap.size(), list);
                            lineMap.put(lineMap.size(), new ArrayList());
                        }
                        sb = new StringBuilder();
                        spaceB.append(cStr);
                        lineLen = spaceLen + charLen;
                        continue;
                    }
                    if (" ".equals(cStr)) {
                        sb.append((CharSequence)spaceB).append(cStr);
                        spaceB = new StringBuilder();
                        continue;
                    }
                    spaceB.append(cStr);
                }
                if (sb.length() <= 0 && spaceB.length() <= 0) continue;
                sb.append((CharSequence)spaceB);
                XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                if (lineMap.containsKey(lineMap.size() - 1)) {
                    list = lineMap.get(lineMap.size() - 1);
                    list.add(temp);
                    continue;
                }
                list.add(temp);
                lineMap.put(lineMap.size(), list);
            }
        }
        return XFADraw.getTotalHeight(lineMap);
    }

    private static double getTotalHeight(HashMap<Integer, ArrayList<XFAStyle>> lineMap) {
        double totalHeight = 0.0;
        for (int z = 0; z < lineMap.size(); ++z) {
            int height = 0;
            for (XFAStyle style : lineMap.get(z)) {
                XFontInfo xFontInfo = style.getFontInfo();
                height = Math.max(xFontInfo.getSize(), height);
            }
            totalHeight += (double)height;
        }
        return totalHeight;
    }

    private static void handleNoWidth(HashMap<Integer, ArrayList<XFAStyle>> lineMap, HashMap<Integer, XFAStyle> map) {
        for (int z = 0; z < map.size(); ++z) {
            XFAStyle style = map.get(z);
            ArrayList<XFAStyle> list = new ArrayList<XFAStyle>();
            if ("<br/>".equals(style.getStyleData())) {
                style.setStyleData("");
                list.add(style);
                lineMap.put(lineMap.size(), list);
                continue;
            }
            if (lineMap.containsKey(lineMap.size() - 1)) {
                lineMap.get(lineMap.size() - 1).add(style);
                continue;
            }
            list.add(style);
            lineMap.put(lineMap.size(), list);
        }
    }
}

