/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.runtime.ApplicationException;
import coldfusion.saml.SamlBindings;
import coldfusion.saml.util.Utils;
import coldfusion.util.KeystoreUtils;
import coldfusion.util.RB;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;

public class SpConfiguration
implements Cloneable {
    public static final String SP_ENTITYID_PROPERTY_KEY = "onelogin.saml2.sp.entityid";
    public static final String SP_ASSERTION_CONSUMER_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.sp.assertion_consumer_service.url";
    public static final String SP_ASSERTION_CONSUMER_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.sp.assertion_consumer_service.binding";
    public static final String SP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.sp.single_logout_service.url";
    public static final String SP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.sp.single_logout_service.binding";
    public static final String SP_NAMEIDFORMAT_PROPERTY_KEY = "onelogin.saml2.sp.nameidformat";
    public static final String SP_X509CERT_PROPERTY_KEY = "onelogin.saml2.sp.x509cert";
    public static final String SP_PRIVATEKEY_PROPERTY_KEY = "onelogin.saml2.sp.privatekey";
    public static final String SECURITY_AUTHREQUEST_SIGNED = "onelogin.saml2.security.authnrequest_signed";
    public static final String SECURITY_LOGOUTREQUEST_SIGNED = "onelogin.saml2.security.logoutrequest_signed";
    public static final String SECURITY_LOGOUTRESPONSE_SIGNED = "onelogin.saml2.security.logoutresponse_signed";
    public static final String SECURITY_WANT_ASSERTIONS_SIGNED = "onelogin.saml2.security.want_assertions_signed";
    public static final String SECURITY_SIGN_METADATA = "onelogin.saml2.security.sign_metadata";
    public static final String STORE_REDIS = "redis";
    public static final String STORE_CACHE = "cache";
    private String entityId;
    private String description;
    private String acsUrl;
    private String acsBinding;
    private String sloUrl;
    private String sloBinding;
    private boolean signRequests = false;
    private boolean wantAssertionsSigned = false;
    private boolean logoutResponseSigned = false;
    private boolean allowIdpInitiatedSso = false;
    private String signKeystorePath;
    private String signKeystorePassword;
    private String signKeystoreAlias;
    private String stateStore;
    private boolean signMetadata;
    private boolean isGenerated = false;
    private boolean strict = true;

    public SpConfiguration() {
    }

    public SpConfiguration(String entityId, String description, String acsUrl, String acsBinding, String sloUrl, String sloBinding, boolean signRequests, boolean wantAssertionsSigned, boolean logoutResponseSigned, String signKeystorePath, String signKeystorePassword, String signKeystoreAlias, String stateStore, boolean signMetadata) {
        this.entityId = entityId;
        this.description = description;
        this.acsUrl = acsUrl;
        this.acsBinding = acsBinding;
        this.sloUrl = sloUrl;
        this.sloBinding = sloBinding;
        this.signRequests = signRequests;
        this.wantAssertionsSigned = wantAssertionsSigned;
        this.logoutResponseSigned = logoutResponseSigned;
        this.signKeystorePath = signKeystorePath;
        this.signKeystorePassword = signKeystorePassword;
        this.signKeystoreAlias = signKeystoreAlias;
        this.signMetadata = signMetadata;
        this.stateStore = stateStore;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAcsUrl() {
        return this.acsUrl;
    }

    public void setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    public String getAcsBinding() {
        return this.acsBinding;
    }

    public void setAcsBinding(String acsBinding) {
        this.acsBinding = acsBinding;
    }

    public String getSloUrl() {
        return this.sloUrl;
    }

    public void setSloUrl(String sloUrl) {
        this.sloUrl = sloUrl;
    }

    public String getSloBinding() {
        return this.sloBinding;
    }

    public void setSloBinding(String sloBinding) {
        this.sloBinding = sloBinding;
    }

    public boolean isSignRequests() {
        return this.signRequests;
    }

    public void setSignRequests(boolean signRequests) {
        this.signRequests = signRequests;
    }

    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public void setWantAssertionsSigned(boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    public boolean isLogoutResponseSigned() {
        return this.logoutResponseSigned;
    }

    public void setLogoutResponseSigned(boolean logoutResponseSigned) {
        this.logoutResponseSigned = logoutResponseSigned;
    }

    public String getSignKeystorePath() {
        return this.signKeystorePath;
    }

    public void setSignKeystorePath(String signKeystorePath) {
        this.signKeystorePath = signKeystorePath;
    }

    public String getSignKeystorePassword() {
        return this.signKeystorePassword;
    }

    public void setSignKeystorePassword(String signKeystorePassword) {
        this.signKeystorePassword = signKeystorePassword;
    }

    public String getSignKeystoreAlias() {
        return this.signKeystoreAlias;
    }

    public void setSignKeystoreAlias(String signKeystoreAlias) {
        this.signKeystoreAlias = signKeystoreAlias;
    }

    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public String getStateStore() {
        return this.stateStore;
    }

    public void setStateStore(String stateStore) {
        this.stateStore = stateStore;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isAllowIdpInitiatedSso() {
        return this.allowIdpInitiatedSso;
    }

    public void setAllowIdpInitiatedSso(boolean allowIdpInitiatedSso) {
        this.allowIdpInitiatedSso = allowIdpInitiatedSso;
    }

    public static Saml2Settings spConfigToSamlSettings(SpConfiguration config) {
        LinkedHashMap<String, Object> settingsMap = new LinkedHashMap<String, Object>();
        if (!Utils.isEmpty(config.getEntityId())) {
            settingsMap.put(SP_ENTITYID_PROPERTY_KEY, config.getEntityId());
        }
        if (!Utils.isEmpty(config.getAcsUrl())) {
            settingsMap.put(SP_ASSERTION_CONSUMER_SERVICE_URL_PROPERTY_KEY, config.getAcsUrl());
        }
        if (!Utils.isEmpty(config.getAcsBinding())) {
            settingsMap.put(SP_ASSERTION_CONSUMER_SERVICE_BINDING_PROPERTY_KEY, SamlBindings.valueOf(config.getAcsBinding().toUpperCase()).toString());
        }
        if (!Utils.isEmpty(config.getSloUrl())) {
            settingsMap.put(SP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY, config.getSloUrl());
        }
        if (!Utils.isEmpty(config.getSloBinding())) {
            settingsMap.put(SP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY, SamlBindings.valueOf(config.getSloBinding().toUpperCase()).toString());
        }
        if (config.isSignRequests()) {
            settingsMap.put(SECURITY_AUTHREQUEST_SIGNED, config.isSignRequests());
            settingsMap.put(SECURITY_LOGOUTREQUEST_SIGNED, config.isSignRequests());
        }
        if (config.isWantAssertionsSigned()) {
            settingsMap.put(SECURITY_WANT_ASSERTIONS_SIGNED, config.isWantAssertionsSigned());
        }
        if (config.isLogoutResponseSigned()) {
            settingsMap.put(SECURITY_LOGOUTRESPONSE_SIGNED, config.isLogoutResponseSigned());
        }
        if (config.isSignMetadata()) {
            settingsMap.put(SECURITY_SIGN_METADATA, config.isSignMetadata());
        }
        if (!Utils.isEmpty(config.getSignKeystorePath())) {
            if (config.getSignKeystorePath().trim().length() == 0 || !new File(config.getSignKeystorePath()).exists()) {
                throw new KeystoreException(RB.getString(SpConfiguration.class, (String)"KeystoreNotFound", (Object)config.getSignKeystorePath()));
            }
            KeystoreUtils.addBCProvider();
            KeyStore keystore = KeystoreUtils.getKeyStore((String)config.getSignKeystorePath(), (String)config.getSignKeystorePassword());
            KeystoreUtils.removeBCProvider();
            String alias = null;
            if (config.getSignKeystoreAlias() == null || config.getSignKeystoreAlias().trim().length() == 0) {
                try {
                    alias = KeystoreUtils.getKeyAlias((KeyStore)keystore);
                }
                catch (KeyStoreException e) {
                    throw new KeystoreException(RB.getString(SpConfiguration.class, (String)"AliasNotFound"));
                }
            } else {
                alias = config.getSignKeystoreAlias();
            }
            Certificate[] chain = null;
            try {
                chain = keystore.getCertificateChain(alias);
            }
            catch (KeyStoreException e1) {
                throw new KeystoreException(RB.getString(SpConfiguration.class, (String)"CertificateError"));
            }
            if (chain == null || chain.length == 0) {
                throw new KeystoreException(RB.getString(SpConfiguration.class, (String)"NoCertificate"));
            }
            try {
                PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, config.getSignKeystorePassword().toCharArray());
                settingsMap.put(SP_PRIVATEKEY_PROPERTY_KEY, privateKey);
                settingsMap.put(SP_X509CERT_PROPERTY_KEY, (X509Certificate)chain[0]);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new KeystoreException(RB.getString(SpConfiguration.class, (String)"KeyRetrieveError"));
            }
        }
        return new SettingsBuilder().fromValues(settingsMap).build();
    }

    public SpConfiguration clone() throws CloneNotSupportedException {
        SpConfiguration config = (SpConfiguration)super.clone();
        return config;
    }

    public static class KeystoreException
    extends ApplicationException {
        public String exceptionMessage = "";

        public KeystoreException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }
}

