/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.utils;

import coldfusion.cloud.Executor;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.config.ChannelProviderBuilder;
import coldfusion.cloud.gcp.config.ChannelProviderType;
import coldfusion.cloud.gcp.config.GrpcChannelProvider;
import coldfusion.cloud.gcp.pubsub.auth.PubSubCredentialValidator;
import coldfusion.cloud.gcp.pubsub.config.PubSubClientServiceConfig;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.handlers.AbstractSubscriberMessageHandler;
import coldfusion.cloud.gcp.pubsub.handlers.MessageTransformerHandler;
import coldfusion.cloud.gcp.pubsub.handlers.SubscriberMessageHandler;
import coldfusion.cloud.gcp.pubsub.handlers.SubscriberMessageHandlerWithResponse;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.ExecutorProviderRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherBatchingSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.RetrySettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriberMessageHandlerRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriberSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubResourceNameTransformer;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.server.proxy.ProxyManager;
import coldfusion.util.RB;
import com.google.api.core.ApiFunction;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.MessageReceiverWithAckResponse;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.SchemaServiceSettings;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class PubSubClientManager {
    private final Logger logger = CFLogs.SERVER_LOG;
    private final GoogleCredentials gcpCredentials;
    private final PubSubClientServiceConfig pubsubConfig;
    private final String pubsubClientId;
    private final PubSubResourceNameTransformer nameTransformer;
    private final TransportChannelProvider DEFAULT_TRANSPORT_CHANNEL_PROVIDER;
    private static final Map<String, Publisher> publisherMap = new ConcurrentHashMap<String, Publisher>();
    private static final Map<String, Subscriber> subscriberMap = new ConcurrentHashMap<String, Subscriber>();
    private static final Map<String, List<String>> topicToPublisherMap = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, List<String>> subscriptionToSubscriberMap = new ConcurrentHashMap<String, List<String>>();

    public PubSubClientManager(GCPCredential credential, PubSubClientServiceConfig pubsubConfig, String pubsubClientId) {
        PubSubCredentialValidator credentialValidator = new PubSubCredentialValidator(credential);
        this.nameTransformer = new PubSubResourceNameTransformer(credentialValidator.getProjectId());
        this.gcpCredentials = credentialValidator.getGcpCredentials();
        this.pubsubConfig = pubsubConfig;
        this.pubsubClientId = pubsubClientId;
        this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER = this.getGrpcChannelProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher getPublisher(String topicId, PublisherSettingsRequest publisherSettings) {
        String publisherId = this.pubsubClientId + "-" + topicId;
        if (publisherMap.get(publisherId) == null) {
            Map<String, Publisher> map = publisherMap;
            synchronized (map) {
                if (publisherMap.get(publisherId) == null) {
                    String topicName = this.nameTransformer.getTopicName(topicId);
                    Publisher publisher = this.createPublisher(topicName, publisherSettings);
                    publisherMap.put(publisherId, publisher);
                    PubSubClientManager.updateTopicToPublisherMap(topicName, publisherId);
                    return publisher;
                }
            }
        }
        Publisher publisher = publisherMap.get(publisherId);
        return publisher;
    }

    private static void updateTopicToPublisherMap(String topicName, String publisherId) {
        topicToPublisherMap.computeIfAbsent(topicName, a -> new ArrayList()).add(publisherId);
    }

    private Publisher createPublisher(String topicName, PublisherSettingsRequest publisherSettings) {
        Publisher publisher = null;
        Publisher.Builder publisherBuilder = Publisher.newBuilder((String)topicName).setChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER).setCredentialsProvider(this.getGCPCredentialProvider());
        if (Objects.nonNull(publisherSettings)) {
            if (!PubSubServiceUtils.isNullOrEmpty(publisherSettings.getEndpoint())) {
                publisherBuilder = publisherBuilder.setEndpoint(publisherSettings.getEndpoint());
            }
            if (publisherSettings.getEnableMessageOrdering() != null) {
                publisherBuilder = publisherBuilder.setEnableMessageOrdering(publisherSettings.getEnableMessageOrdering().booleanValue());
            }
            if (publisherSettings.getEnableCompression() != null) {
                publisherBuilder = publisherBuilder.setEnableCompression(publisherSettings.getEnableCompression().booleanValue());
            }
            if (publisherSettings.getCompressionBytesThreshold() != null) {
                publisherBuilder = publisherBuilder.setCompressionBytesThreshold(publisherSettings.getCompressionBytesThreshold().longValue());
            }
            if (publisherSettings.getBatchingSettings() != null) {
                PublisherBatchingSettingsRequest batchingSettingsRequest = publisherSettings.getBatchingSettings();
                BatchingSettings batchingSettings = batchingSettingsRequest.toBuilder().build();
                publisherBuilder = publisherBuilder.setBatchingSettings(batchingSettings);
            }
            if (publisherSettings.getRetrySettings() != null) {
                RetrySettingsRequest retrySettingsRequest = publisherSettings.getRetrySettings();
                RetrySettings retrySettings = retrySettingsRequest.toBuilder().build();
                publisherBuilder = publisherBuilder.setRetrySettings(retrySettings);
            }
            if (publisherSettings.getExecutorProvider() != null) {
                ExecutorProviderRequest executorProviderRequest = publisherSettings.getExecutorProvider();
                InstantiatingExecutorProvider executorProvider = executorProviderRequest.toBuilder().build();
                publisherBuilder = publisherBuilder.setExecutorProvider((ExecutorProvider)executorProvider);
            }
            if (publisherSettings.getMessageTransformer() != null) {
                Closure messageTransformer = publisherSettings.getMessageTransformer();
                MessageTransformerHandler msgTransformerHandler = new MessageTransformerHandler(messageTransformer, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
                publisherBuilder = publisherBuilder.setTransform(msgTransformerHandler.getMessageHandler());
            }
        }
        try {
            publisher = publisherBuilder.build();
            return publisher;
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PubSubException(e.getMessage(), e);
        }
    }

    public void deletePublisher(String topicId) {
        this.deletePublisherFromMap(topicId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePublisherFromMap(String topicId) {
        String topicName = this.nameTransformer.getTopicName(topicId);
        List<String> publisherIds = topicToPublisherMap.get(topicName);
        if (publisherIds != null) {
            for (String publisherId : publisherIds) {
                if (publisherMap.get(publisherId) == null) continue;
                Map<String, Publisher> map = publisherMap;
                synchronized (map) {
                    if (publisherMap.get(publisherId) != null) {
                        Publisher publisher = publisherMap.get(publisherId);
                        try {
                            this.logger.info((Object)RB.getString(PubSubClientImpl.class, (String)"DELETE_PUBLISHER_MSG", (Object)topicId));
                            publisher.shutdown();
                            publisher.awaitTermination(1L, TimeUnit.MINUTES);
                        }
                        catch (InterruptedException e) {
                            this.logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        publisherMap.remove(publisherId);
                    }
                }
            }
            topicToPublisherMap.remove(topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(String subscriptionId, SubscriberMessageHandlerRequest subscriberMessageHandlerRequest) {
        int msgHandlerHC = subscriberMessageHandlerRequest != null ? PubSubServiceUtils.getHashcode(subscriberMessageHandlerRequest.hashCode()) : 0;
        String subscriberId = this.pubsubClientId + "-" + msgHandlerHC + "-" + subscriptionId;
        if (subscriberMap.get(subscriberId) == null) {
            Map<String, Subscriber> map = subscriberMap;
            synchronized (map) {
                if (subscriberMap.get(subscriberId) == null) {
                    String subscriptionName = this.nameTransformer.getSubscriptionName(subscriptionId);
                    Subscriber subscriber = this.createSubscriber(subscriptionName, subscriberMessageHandlerRequest);
                    subscriberMap.put(subscriberId, subscriber);
                    PubSubClientManager.updateSubscriptionToSubscriberMap(subscriptionName, subscriberId);
                    return subscriber;
                }
            }
        }
        Subscriber subscriber = subscriberMap.get(subscriberId);
        return subscriber;
    }

    private static void updateSubscriptionToSubscriberMap(String subscriptionName, String subscriberId) {
        subscriptionToSubscriberMap.computeIfAbsent(subscriptionName, a -> new ArrayList()).add(subscriberId);
    }

    private Subscriber createSubscriber(String subscriptionName, SubscriberMessageHandlerRequest subscriberMessageHandlerRequest) {
        AbstractSubscriberMessageHandler msgHandler;
        SubscriberSettingsRequest subscriberSettings = null;
        Subscriber.Builder subscriberBuilder = null;
        Closure onSuccess = subscriberMessageHandlerRequest.getSuccessHandler();
        Closure onError = subscriberMessageHandlerRequest.getErrorHandler();
        boolean isAckResponseEnabled = subscriberMessageHandlerRequest.getAckResponseEnabled();
        if (isAckResponseEnabled) {
            msgHandler = new SubscriberMessageHandlerWithResponse(onSuccess, onError, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            subscriberBuilder = Subscriber.newBuilder((String)subscriptionName, (MessageReceiverWithAckResponse)((SubscriberMessageHandlerWithResponse)msgHandler).getMessageHandler());
        } else {
            msgHandler = new SubscriberMessageHandler(onSuccess, onError, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            subscriberBuilder = Subscriber.newBuilder((String)subscriptionName, (MessageReceiver)((SubscriberMessageHandler)msgHandler).getMessageHandler());
        }
        subscriberBuilder = subscriberBuilder.setChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER).setCredentialsProvider(this.getGCPCredentialProvider());
        if (Objects.nonNull((Object)this.pubsubConfig)) {
            subscriberSettings = this.pubsubConfig.getSubscriberSettings();
        }
        if (Objects.nonNull(subscriberSettings)) {
            if (!PubSubServiceUtils.isNullOrEmpty(subscriberSettings.getEndpoint())) {
                subscriberBuilder = subscriberBuilder.setEndpoint(subscriberSettings.getEndpoint());
            }
            if (subscriberSettings.getExecutorProvider() != null) {
                subscriberBuilder = subscriberBuilder.setExecutorProvider((ExecutorProvider)subscriberSettings.getExecutorProvider().toBuilder().build());
            }
            if (subscriberSettings.getSystemExecutorProvider() != null) {
                subscriberBuilder = subscriberBuilder.setSystemExecutorProvider((ExecutorProvider)subscriberSettings.getSystemExecutorProvider().toBuilder().build());
            }
            if (subscriberSettings.getParallelPullCount() != null) {
                subscriberBuilder = subscriberBuilder.setParallelPullCount(subscriberSettings.getParallelPullCount().intValue());
            }
            if (subscriberSettings.getFlowControlSettings() != null) {
                subscriberBuilder = subscriberBuilder.setFlowControlSettings(subscriberSettings.getFlowControlSettings().toBuilder().build());
            }
            if (subscriberSettings.getUseLegacyFlowControl() != null) {
                subscriberBuilder = subscriberBuilder.setUseLegacyFlowControl(subscriberSettings.getUseLegacyFlowControl().booleanValue());
            }
            if (subscriberSettings.getMaxAckExtensionPeriod() != null) {
                java.time.Duration maxAckExtensionPeriod = subscriberSettings.getMaxAckExtensionPeriod();
                subscriberBuilder = subscriberBuilder.setMaxAckExtensionPeriod(Duration.ofSeconds((long)maxAckExtensionPeriod.getSeconds(), (long)maxAckExtensionPeriod.getNano()));
            }
            if (subscriberSettings.getMinDurationPerAckExtensionPeriod() != null) {
                java.time.Duration minDurationPerAckExtensionPeriod = subscriberSettings.getMinDurationPerAckExtensionPeriod();
                subscriberBuilder = subscriberBuilder.setMinDurationPerAckExtension(Duration.ofSeconds((long)minDurationPerAckExtensionPeriod.getSeconds(), (long)minDurationPerAckExtensionPeriod.getNano()));
            }
            if (subscriberSettings.getMaxDurationPerAckExtensionPeriod() != null) {
                java.time.Duration maxDurationPerAckExtensionPeriod = subscriberSettings.getMaxDurationPerAckExtensionPeriod();
                subscriberBuilder = subscriberBuilder.setMaxDurationPerAckExtension(Duration.ofSeconds((long)maxDurationPerAckExtensionPeriod.getSeconds(), (long)maxDurationPerAckExtensionPeriod.getNano()));
            }
        }
        return subscriberBuilder.build();
    }

    public void deleteSubscriber(String subscriptionId) {
        this.deleteSubscriberFromMap(subscriptionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubscriberFromMap(String subscriptionId) {
        String subscriptionName = this.nameTransformer.getSubscriptionName(subscriptionId);
        List<String> subscriberIds = subscriptionToSubscriberMap.get(subscriptionName);
        if (subscriberIds != null) {
            for (String subscriberId : subscriberIds) {
                if (subscriberMap.get(subscriberId) == null) continue;
                Map<String, Subscriber> map = subscriberMap;
                synchronized (map) {
                    if (subscriberMap.get(subscriberId) != null) {
                        Subscriber subscriber = subscriberMap.get(subscriberId);
                        this.logger.info((Object)RB.getString(PubSubClientImpl.class, (String)"DELETE_SUBSCRIBER_MSG", (Object)subscriptionId));
                        subscriber.stopAsync();
                        subscriberMap.remove(subscriberId);
                    }
                }
            }
            subscriptionToSubscriberMap.remove(subscriptionName);
        }
    }

    private CredentialsProvider getGCPCredentialProvider() {
        return FixedCredentialsProvider.create((Credentials)this.gcpCredentials);
    }

    private InstantiatingGrpcChannelProvider.Builder getDefaultGrpcChannelProviderBuilder() {
        InstantiatingGrpcChannelProvider.Builder builder = InstantiatingGrpcChannelProvider.newBuilder();
        final ProxyManager.ProxyServerDetails proxyServerDetails = ProxyManager.getInstance().getProxyServerDetails();
        if (proxyServerDetails.getProxyHost() != null) {
            builder.setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

                public ManagedChannelBuilder apply(ManagedChannelBuilder managedChannelBuilder) {
                    return managedChannelBuilder.proxyDetector(new ProxyDetector(){

                        @Nullable
                        public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) throws IOException {
                            HttpConnectProxiedSocketAddress.Builder proxiedSocketAddressBuilder = HttpConnectProxiedSocketAddress.newBuilder();
                            proxiedSocketAddressBuilder = proxiedSocketAddressBuilder.setProxyAddress((SocketAddress)new InetSocketAddress(proxyServerDetails.getProxyHost(), (int)proxyServerDetails.getProxyPort()));
                            if (proxyServerDetails.getProxyUsername() != null) {
                                proxiedSocketAddressBuilder = proxiedSocketAddressBuilder.setUsername(proxyServerDetails.getProxyUsername());
                            }
                            if (proxyServerDetails.getProxyPassword() != null) {
                                proxiedSocketAddressBuilder = proxiedSocketAddressBuilder.setPassword(proxyServerDetails.getProxyPassword());
                            }
                            proxiedSocketAddressBuilder = proxiedSocketAddressBuilder.setTargetAddress((InetSocketAddress)socketAddress);
                            return proxiedSocketAddressBuilder.build();
                        }
                    });
                }
            });
        }
        return builder;
    }

    private TransportChannelProvider getGrpcChannelProvider() {
        Object transportChannelProvider = null;
        if (Objects.nonNull((Object)this.pubsubConfig)) {
            transportChannelProvider = this.pubsubConfig.getChannelProvider() != null ? this.buildChannelProvider(this.pubsubConfig.getChannelProvider()) : this.getDefaultGrpcChannelProviderBuilder().build();
        }
        return transportChannelProvider;
    }

    private TransportChannelProvider buildChannelProvider(ChannelProviderBuilder channelProviderBuilder) {
        switch ((ChannelProviderType)channelProviderBuilder.getType()) {
            case GRPC: {
                return this.buildGrpcProvider((GrpcChannelProvider)channelProviderBuilder);
            }
        }
        return this.buildGrpcProvider((GrpcChannelProvider)channelProviderBuilder);
    }

    private TransportChannelProvider buildGrpcProvider(GrpcChannelProvider channelProviderBuilder) {
        java.time.Duration keepAliveTime;
        InstantiatingGrpcChannelProvider.Builder builder = this.getDefaultGrpcChannelProviderBuilder();
        builder.setMaxInboundMessageSize(channelProviderBuilder.getMaxInboundMessageSize());
        builder.setKeepAliveWithoutCalls(channelProviderBuilder.isKeepAliveWithoutCalls());
        builder.setExecutor((java.util.concurrent.Executor)Executor.getInstance());
        java.time.Duration keepAliveTimeout = channelProviderBuilder.getKeepAliveTimeout();
        if (Objects.nonNull(keepAliveTimeout)) {
            builder.setKeepAliveTimeout(Duration.ofSeconds((long)keepAliveTimeout.getSeconds(), (long)keepAliveTimeout.getNano()));
        }
        if (Objects.nonNull(keepAliveTime = channelProviderBuilder.getKeepAliveTime())) {
            builder.setKeepAliveTime(Duration.ofSeconds((long)keepAliveTime.getSeconds(), (long)keepAliveTime.getNano()));
        }
        return builder.build();
    }

    public TopicAdminSettings getTopicAdminSettings() {
        TopicAdminSettings topicAdminSettings = null;
        if (this.gcpCredentials != null) {
            try {
                topicAdminSettings = ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER)).setCredentialsProvider(this.getGCPCredentialProvider())).build();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
        }
        return topicAdminSettings;
    }

    public SubscriptionAdminSettings getSubscriptionAdminSettings() {
        SubscriptionAdminSettings subscriptionAdminSettings = null;
        if (this.gcpCredentials != null) {
            try {
                subscriptionAdminSettings = ((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER)).setCredentialsProvider(this.getGCPCredentialProvider())).build();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
        }
        return subscriptionAdminSettings;
    }

    public SubscriberStubSettings getSubscriberStubSettings() {
        SubscriberStubSettings subscriberStubSettings = null;
        if (this.gcpCredentials != null) {
            try {
                subscriberStubSettings = ((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setTransportChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER)).setCredentialsProvider(this.getGCPCredentialProvider())).build();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
        }
        return subscriberStubSettings;
    }

    public SchemaServiceSettings getSchemaServiceSettings() {
        SchemaServiceSettings schemaServiceSettings = null;
        if (this.gcpCredentials != null) {
            try {
                schemaServiceSettings = ((SchemaServiceSettings.Builder)((SchemaServiceSettings.Builder)SchemaServiceSettings.newBuilder().setTransportChannelProvider(this.DEFAULT_TRANSPORT_CHANNEL_PROVIDER)).setCredentialsProvider(this.getGCPCredentialProvider())).build();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new PubSubException(e.getMessage(), e);
            }
        }
        return schemaServiceSettings;
    }
}

