/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.model;

import coldfusion.cloud.gcp.pubsub.utils.PubSubMessageSerializer;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;

public class BasicPubSubMessage {
    protected Object data;
    protected String orderingKey;
    protected Map<String, String> attributes;
    private transient PubsubMessage pubsubMessage;

    public BasicPubSubMessage(PubsubMessage pubsubMessage) {
        this.pubsubMessage = pubsubMessage;
        this.data = this.getData();
        this.orderingKey = pubsubMessage.getOrderingKey();
        this.attributes = pubsubMessage.getAttributesMap();
    }

    private Object getData() {
        String encoding = (String)this.pubsubMessage.getAttributesMap().get("googclient_schemaencoding");
        if (encoding == null) {
            return PubSubMessageSerializer.deserialize(this.pubsubMessage.getData());
        }
        switch (encoding) {
            case "BINARY": {
                return this.pubsubMessage.getData().toByteArray();
            }
            case "JSON": {
                return this.pubsubMessage.getData().toStringUtf8();
            }
        }
        return this.pubsubMessage.getData().toStringUtf8();
    }
}

