/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.consumer.IAMPolicyBindingSetRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicyBindingRequest;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicySetRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyBindingValidator;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum IAMPolicySetRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<IAMPolicySetRequest> consumerMap = new ConsumerMap();
    private final List<Validator> validators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(ResourceType.class, "resourceType"));

    private IAMPolicySetRequestConsumer() {
        this.consumerMap.put((Object)"resourceName", new ConsumerValidator((iamPolicyRequest, value) -> iamPolicyRequest.setResourceName(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"resourceType", new ConsumerValidator((iamPolicyRequest, value) -> {
            String resourceType = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
            iamPolicyRequest.setResourceType(ResourceType.valueOf(resourceType));
        }, this.validators));
        this.consumerMap.put((Object)"version", new ConsumerValidator((setIAMPolicyRequest, value) -> setIAMPolicyRequest.setVersion(this.cast.getIntegerProperty(value)), Collections.emptyList()));
        this.consumerMap.put((Object)"etag", new ConsumerValidator((setIAMPolicyRequest, value) -> setIAMPolicyRequest.setEtag(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.consumerMap.put((Object)"bindings", new ConsumerValidator((setIAMPolicyRequest, value) -> {
            ArrayList<IAMPolicyBindingRequest> bindings = new ArrayList<IAMPolicyBindingRequest>();
            if (value instanceof Struct) {
                IAMPolicyBindingRequest binding = new IAMPolicyBindingRequest();
                ValidatorFiller.INSTANCE.fillObject((Object)binding, this.cast.getMapProperty(value, "bindings"), IAMPolicyBindingSetRequestConsumer.INSTANCE.getConsumerMap());
                bindings.add(binding);
            } else if (value instanceof Array) {
                List inputBindings = this.cast.getListProperty(value);
                for (Object inputBinding : inputBindings) {
                    IAMPolicyBindingRequest binding = new IAMPolicyBindingRequest();
                    ValidatorFiller.INSTANCE.fillObject((Object)binding, this.cast.getMapProperty(inputBinding, "bindings"), IAMPolicyBindingSetRequestConsumer.INSTANCE.getConsumerMap());
                    bindings.add(binding);
                }
            }
            setIAMPolicyRequest.setBindings(bindings);
        }, Arrays.asList(NotNullValidator.INSTANCE, EmptyBindingValidator.INSTANCE)));
    }

    public ConsumerMap<IAMPolicySetRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

