/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.auth;

import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.pubsub.PubSubConstants;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PubSubCredentialValidator {
    private String projectId;
    private String credentialJSONFilePath;
    private GoogleCredentials gcpCredentials;
    private static final Logger logger = CFLogs.SERVER_LOG;

    public PubSubCredentialValidator(GCPCredential credential) {
        this.populateCredentials(credential);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCredentialJSONFilePath() {
        return this.credentialJSONFilePath;
    }

    public GoogleCredentials getGcpCredentials() {
        return this.gcpCredentials;
    }

    private void populateCredentials(final GCPCredential credential) {
        if (System.getSecurityManager() == null) {
            this._populateCredentials(credential);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PubSubCredentialValidator.this._populateCredentials(credential);
                    return null;
                }
            });
        }
    }

    private void _populateCredentials(GCPCredential credential) {
        if (credential != null) {
            this.projectId = credential.getProjectId();
            this.credentialJSONFilePath = credential.getCredentialJSONFilePath();
            if (!PubSubServiceUtils.isNullOrEmpty(this.credentialJSONFilePath)) {
                InputStream inputStream = null;
                if (this.credentialJSONFilePath instanceof String) {
                    if (VFSFileFactory.checkIfVFile((String)this.credentialJSONFilePath)) {
                        try {
                            inputStream = VFSFileFactory.getInputStream((String)this.credentialJSONFilePath);
                        }
                        catch (FileNotFoundException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            throw new PubSubException(e.getMessage(), e);
                        }
                    }
                    try {
                        inputStream = new FileInputStream(this.credentialJSONFilePath);
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new PubSubException(e.getMessage(), e);
                    }
                }
                if (inputStream != null) {
                    try {
                        this.gcpCredentials = GoogleCredentials.fromStream(inputStream);
                    }
                    catch (IOException ioe) {
                        logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                        throw new PubSubException(ioe.getMessage(), ioe);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new PubSubException(e.getMessage(), e);
                        }
                    }
                }
            }
            if (this.gcpCredentials == null) {
                try {
                    this.gcpCredentials = GoogleCredentials.getApplicationDefault();
                }
                catch (IOException ioe) {
                    throw new PubSubException(ioe.getMessage(), ioe);
                }
            }
            this.projectId = this.extractProjectIDFromGoogleCredentials(this.gcpCredentials);
            if (this.gcpCredentials != null) {
                if (this.gcpCredentials instanceof ServiceAccountCredentials) {
                    this.gcpCredentials = ((ServiceAccountCredentials)this.gcpCredentials).createScoped(PubSubConstants.GCP_PUBSUB_SCOPES);
                }
                if (this.gcpCredentials instanceof ImpersonatedCredentials) {
                    this.gcpCredentials = ((ImpersonatedCredentials)this.gcpCredentials).createScoped(PubSubConstants.GCP_PUBSUB_SCOPES);
                }
                if (this.gcpCredentials instanceof IdentityPoolCredentials) {
                    this.gcpCredentials = ((IdentityPoolCredentials)this.gcpCredentials).createScoped(PubSubConstants.GCP_PUBSUB_SCOPES);
                }
            }
        }
    }

    private String extractProjectIDFromGoogleCredentials(GoogleCredentials googleCredentials) {
        String projectId = "";
        if (googleCredentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)googleCredentials).getProjectId();
        }
        if (PubSubServiceUtils.isNullOrEmpty(projectId)) {
            projectId = this.projectId;
        }
        if (PubSubServiceUtils.isNullOrEmpty(projectId)) {
            projectId = ServiceOptions.getDefaultProjectId();
        }
        if (PubSubServiceUtils.isNullOrEmpty(projectId)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"PROJECTID_NULL_EMPTY"));
        }
        return projectId;
    }
}

