/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRBaseFont
implements JRFont,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected JRDefaultFontProvider defaultFontProvider = null;
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;

    public JRBaseFont() {
    }

    public JRBaseFont(Map attributes) {
        Boolean isPdfEmbeddedAttr;
        String pdfEncodingAttr;
        String pdfFontNameAttr;
        Object strikeThrough;
        Object underline;
        Float sizeAttr;
        Object italic;
        Object bold;
        String fontNameAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (fontNameAttr != null) {
            this.setFontName(fontNameAttr);
        }
        if ((bold = attributes.get(TextAttribute.WEIGHT)) != null) {
            this.setBold(TextAttribute.WEIGHT_BOLD.equals(bold));
        }
        if ((italic = attributes.get(TextAttribute.POSTURE)) != null) {
            this.setItalic(TextAttribute.POSTURE_OBLIQUE.equals(italic));
        }
        if ((sizeAttr = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            this.setFontSize(sizeAttr.intValue());
        }
        if ((underline = attributes.get(TextAttribute.UNDERLINE)) != null) {
            this.setUnderline(TextAttribute.UNDERLINE_ON.equals(underline));
        }
        if ((strikeThrough = attributes.get(TextAttribute.STRIKETHROUGH)) != null) {
            this.setStrikeThrough(TextAttribute.STRIKETHROUGH_ON.equals(strikeThrough));
        }
        if ((pdfFontNameAttr = (String)attributes.get(JRTextAttribute.PDF_FONT_NAME)) != null) {
            this.setPdfFontName(pdfFontNameAttr);
        }
        if ((pdfEncodingAttr = (String)attributes.get(JRTextAttribute.PDF_ENCODING)) != null) {
            this.setPdfEncoding(pdfEncodingAttr);
        }
        if ((isPdfEmbeddedAttr = (Boolean)attributes.get(JRTextAttribute.IS_PDF_EMBEDDED)) != null) {
            this.setPdfEmbedded(isPdfEmbeddedAttr);
        }
    }

    protected JRBaseFont(JRDefaultFontProvider defaultFontProvider) {
        this.defaultFontProvider = defaultFontProvider;
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRFont font) {
        this.defaultFontProvider = defaultFontProvider;
        this.reportFont = reportFont;
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.fontSize = font.getOwnFontSize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultFontProvider;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return null;
    }

    @Override
    public JRStyle getStyle() {
        return null;
    }

    @Override
    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    @Override
    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public int getSize() {
        return this.getFontSize();
    }

    @Override
    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    @Override
    public void setSize(int size) {
        this.setFontSize(size);
    }

    @Override
    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }
}

