/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache.custom;

import coldfusion.cfc.CFCProxy;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CustomException;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.xml.rpc.CFCServlet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericCustomCache
extends GenericCache {
    private String configFilePath;
    private String applicationName;
    private String cfcListener;
    private String customCacheName;
    public static final String CUSTOM_CACHE_IMPLEMENTING_CFC = "cfide.cache.ICustomCache";
    private CFCProxy proxy;

    public GenericCustomCache(String cacheName) {
        this.customCacheName = cacheName;
        String implementingFile = this.getImplementingFile();
        String customCacheFolder = ServiceFactory.getRuntimeService().getWebRoot() + File.separator + "CFIDE" + File.separator + "cache" + File.separator + cacheName;
        this.cfcListener = customCacheFolder + File.separator + implementingFile;
        if (implementingFile.length() == 0 || !new File(this.cfcListener).exists()) {
            throw new CacheExceptions.CustomCacheNotFoundException(cacheName);
        }
        try {
            final WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(customCacheFolder + File.separator, new String[0]);
            dir.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        WatchKey key = null;
                        try {
                            key = watcher.take();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        List<WatchEvent<?>> events = key.pollEvents();
                        for (WatchEvent<?> event : events) {
                            Path p = (Path)event.context();
                            WatchEvent.Kind<?> kind = event.kind();
                            if (!p.endsWith("cache.cfc") || kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                            GenericCustomCache.this.proxy = null;
                        }
                        key.reset();
                    }
                }
            }.start();
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
    }

    private String getImplementingFile() {
        String customCacheFolder = ServiceFactory.getRuntimeService().getWebRoot() + File.separator + "CFIDE" + File.separator + "cache" + File.separator + this.customCacheName;
        File[] files = new File(customCacheFolder).listFiles();
        FusionContext fusionContext = FusionContext.getCurrent();
        NeoPageContext pageContext = fusionContext.pageContext;
        String implementingFile = "";
        if (files != null) {
            for (File file : files) {
                Object implement;
                if (!file.getName().toLowerCase().endsWith("cfc")) continue;
                AttributeCollection metaData = null;
                try {
                    metaData = (AttributeCollection)MetadataUtils.getComponentMetadata((File)file, (NeoPageContext)pageContext, (String)file.getAbsolutePath(), (boolean)true);
                }
                catch (Throwable t) {
                    CFLogs.APPLICATION_LOG.error(t);
                }
                if (metaData == null || null == (implement = metaData.get((Object)"IMPLEMENTS"))) continue;
                if (implement instanceof String) {
                    if (((String)implement).toLowerCase().indexOf(CUSTOM_CACHE_IMPLEMENTING_CFC.toLowerCase()) < 0) continue;
                    implementingFile = file.getName();
                    break;
                }
                if (!(implement instanceof AttributeCollection)) continue;
                if (!((AttributeCollection)implement).containsKey((Object)CUSTOM_CACHE_IMPLEMENTING_CFC)) break;
                implementingFile = file.getName();
                break;
            }
        }
        return implementingFile;
    }

    public Object getMetadata() {
        return null;
    }

    public void setCacheProperties(Map map, String region) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return;
        }
        try {
            this.proxy.invoke("setCacheProperties", new Object[]{map, region});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
    }

    public Object createCache(String mgrKey, String objType, String diskStore, Map properties) {
        if (mgrKey != null && mgrKey.trim().length() == 0) {
            throw new CacheExceptions.InvalidCacheNameException();
        }
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return null;
        }
        Object result = null;
        try {
            result = this.proxy.invoke("createCache", new Object[]{mgrKey, objType});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"createCache method returned null");
            return new Object();
        }
        return result;
    }

    public boolean cacheExists(String region) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return false;
        }
        Object result = null;
        try {
            result = this.proxy.invoke("cacheExists", new Object[]{region});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"cacheExists method returned null");
            return false;
        }
        return Cast._boolean(result);
    }

    public Object get(CacheTO xObj, boolean throwError, Long within) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return null;
        }
        Object result = null;
        try {
            xObj.id = CacheTagHelper.objectToString((Object)((Serializable)xObj.id));
            result = this.proxy.invoke("get", new Object[]{this.cobjToStruct(xObj), throwError, within});
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        return result;
    }

    public Object get(CacheTO xObj, boolean throwError) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return null;
        }
        Object result = null;
        try {
            long lastModified = 0L;
            if (!xObj.getQuiet && "TEMPLATE".equalsIgnoreCase(xObj.objecttype)) {
                lastModified = TemplateClassLoader.getLastModifiedTime((String)FusionContext.getCurrent().getPagePath());
            }
            result = this.proxy.invoke("get", new Object[]{this.cobjToStruct(xObj), throwError, lastModified});
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            return null;
        }
        return result.toString();
    }

    private Struct cobjToStruct(CacheTO xObj) {
        Struct struct = new Struct();
        struct.put((Object)"id", xObj.id);
        struct.put((Object)"value", xObj.value);
        struct.put((Object)"appname", (Object)xObj.appname);
        struct.put((Object)"eternal", (Object)xObj.eternal);
        struct.put((Object)"exact", (Object)xObj.exact);
        struct.put((Object)"objecttype", (Object)xObj.objecttype);
        struct.put((Object)"region", (Object)xObj.region);
        struct.put((Object)"timetoidle", (Object)xObj.timetoidle);
        struct.put((Object)"timetoLive", (Object)xObj.timetoLive);
        return struct;
    }

    public Map getMetadata(CacheTO xObj) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return new Struct();
        }
        Object result = null;
        try {
            result = this.proxy.invoke("getMetadata", new Object[]{this.cobjToStruct(xObj)});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"getMetadata method returned null");
            return new Struct();
        }
        if (!(result instanceof Map)) {
            CFLogs.APPLICATION_LOG.error((Object)"getMetadata returned non struct value");
            return new HashMap();
        }
        return (Map)result;
    }

    public List getObjectCacheMetadata(String appName) {
        return new ArrayList();
    }

    public List getTemplateCacheMetadata(String appName) {
        return new ArrayList();
    }

    public List<Object> getAllCacheIds(CacheTO xObj, boolean accurate) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return new ArrayList<Object>();
        }
        Object result = null;
        try {
            result = this.proxy.invoke("getAllCacheIds", new Object[]{this.cobjToStruct(xObj), accurate});
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheIds method returned null");
            return new ArrayList<Object>();
        }
        if (!(result instanceof List)) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheIds returned non list value");
            return new ArrayList<Object>();
        }
        return (List)result;
    }

    public void setMaxElementsInMemory(String cacheKey, int count) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return;
        }
        try {
            this.proxy.invoke("setMaxElementsInMemory", new Object[]{cacheKey, count});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
    }

    public boolean remove(CacheTO xObj) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return false;
        }
        Object result = null;
        try {
            result = this.proxy.invoke("remove", new Object[]{this.cobjToStruct(xObj)});
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"remove method returned null");
            return false;
        }
        return Cast._boolean(result);
    }

    private CFCProxy getCFCProxy() {
        if (this.proxy == null) {
            try {
                this.proxy = new CFCProxy(this.cfcListener, false);
                this.proxy.setAutoFlush(false);
            }
            catch (Throwable ex) {
                if (CFCServlet.getCFCServlet() == null) {
                    try {
                        for (int retrycount = 0; CFCServlet.getCFCServlet() == null && retrycount < 5; ++retrycount) {
                            Thread.sleep(1000L);
                        }
                        this.proxy = new CFCProxy(this.cfcListener, true);
                    }
                    catch (Throwable ie) {
                        CFLogs.APPLICATION_LOG.error(ie);
                    }
                }
                CFLogs.APPLICATION_LOG.error(ex);
            }
        }
        return this.proxy;
    }

    public void put(CacheTO xObj, boolean throwOnError) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return;
        }
        xObj.id = xObj.id.toString();
        xObj.value = xObj.value.toString();
        try {
            this.proxy.invoke("put", new Object[]{this.cobjToStruct(xObj), throwOnError});
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
    }

    public List getCacheProperties(String region) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return new ArrayList();
        }
        Object result = null;
        try {
            result = this.proxy.invoke("getCacheProperties", new Object[]{region});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"getCacheProperties method returned null");
            return new ArrayList();
        }
        if (!(result instanceof Array)) {
            CFLogs.APPLICATION_LOG.error((Object)"getCacheProperties returned non array value");
            return new ArrayList();
        }
        Array ary = (Array)result;
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < ary.size(); ++i) {
            l.add(ary.get(i));
        }
        return l;
    }

    public void clearCache(String region) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return;
        }
        try {
            this.proxy.invoke("clearCache", new Object[]{region});
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
    }

    public ArrayList getAllCacheMetadataForMonitoring(boolean server) {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return new ArrayList();
        }
        Object result = null;
        try {
            result = this.proxy.invoke("getAllCacheMetadataForMonitoring", new Object[0]);
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheMetadataForMonitoring method returned null");
            return new ArrayList();
        }
        if (!(result instanceof Array)) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheMetadataForMonitoring returned non arrau value");
            return new ArrayList();
        }
        Array ary = (Array)result;
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < ary.size(); ++i) {
            l.add(ary.get(i));
        }
        return l;
    }

    public void removeCache(String cacheName) {
        if (cacheName != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)cacheName)) {
                throw new CacheExceptions.ImpicitCacheRegionDeletionException(cacheName);
            }
            this.proxy = this.getCFCProxy();
            if (this.proxy == null) {
                return;
            }
            try {
                this.proxy.invoke("cacheRemove", new Object[]{cacheName});
            }
            catch (Throwable e) {
                CFLogs.APPLICATION_LOG.error(e);
            }
        }
    }

    public String[] getAllCacheNames() {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return new String[0];
        }
        Object result = null;
        try {
            result = this.proxy.invoke("getAllCacheNames", new Object[0]);
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
        if (null == result) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheNames method returned null");
            return new String[0];
        }
        if (!(result instanceof Array)) {
            CFLogs.APPLICATION_LOG.error((Object)"getAllCacheNames returned non array value");
            return new String[0];
        }
        return (String[])result;
    }

    public boolean isApplicationSpecificCache() {
        return false;
    }

    public Object getCache(String appname, String objecttype, String key) {
        return this.cfcListener;
    }

    public void reset() {
        this.proxy = this.getCFCProxy();
        if (this.proxy == null) {
            return;
        }
        try {
            this.proxy.invoke("reset", new Object[0]);
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(e);
        }
    }

    public String getEngine() {
        return this.customCacheName;
    }

    public long getUpdateTimeOfElement(CacheTO xObj) {
        return 0L;
    }
}

