/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CompositeID;
import coldfusion.orm.mapping.Field;
import coldfusion.orm.mapping.IDField;
import coldfusion.sql.DBMetaData;
import java.util.List;
import java.util.Map;

public abstract class RelationField
extends Field {
    protected String targetComponent;
    protected String cascade;
    protected String entityName;
    protected String lazy;
    protected String fetch;
    protected String mappedBy;
    protected String[] fkColumns;
    protected String[] inverseJoinColumn;
    protected String linkTable;
    protected String linkTableSchema;
    protected String linkTableCatalog;
    private String sqlType;
    public static final int ONE_TO_ONE = 1;
    public static final int ONE_TO_MANY = 2;
    public static final int MANY_TO_ONE = 3;
    public static final int MANY_TO_MANY = 4;
    private boolean inverse;

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getFetch() {
        return this.fetch;
    }

    public void setFetch(String fetch) {
        this.fetch = fetch;
    }

    public String getLazy() {
        return this.lazy;
    }

    public void setLazy(String lazy) {
        this.lazy = lazy;
    }

    public String getTargetComponent() {
        return this.targetComponent;
    }

    public void setTargetComponent(String targetComponent) {
        this.targetComponent = targetComponent;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public String[] getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(String[] fkColumns) {
        this.fkColumns = fkColumns;
    }

    public String[] getInverseJoinColumn() {
        return this.inverseJoinColumn;
    }

    public void setInverseJoinColumn(String[] inverseJoinColumn) {
        this.inverseJoinColumn = inverseJoinColumn;
    }

    public String getLinkTableCatalog() {
        return this.linkTableCatalog;
    }

    public void setLinkTableCatalog(String linkTableCatalog) {
        this.linkTableCatalog = linkTableCatalog;
    }

    public String getLinkTableSchema() {
        return this.linkTableSchema;
    }

    public void setLinkTableSchema(String linkTableSchema) {
        this.linkTableSchema = linkTableSchema;
    }

    public String getLinkTable() {
        return this.linkTable;
    }

    public void setLinkTable(String linkTable) {
        this.linkTable = linkTable;
    }

    protected String[] generateFKColumnNames(CFCPersistenceMetadata cfcPmd, String relationName) {
        Object idFieldObj = cfcPmd.getIdField();
        String entityName = cfcPmd.getEntityName();
        if (idFieldObj instanceof IDField) {
            IDField idField = (IDField)idFieldObj;
            String column = relationName == null ? entityName + "_" + idField.getColumn() : relationName + "_id";
            return new String[]{column};
        }
        if (idFieldObj instanceof CompositeID) {
            CompositeID compId = (CompositeID)idFieldObj;
            List<IDField> fields = compId.getFields();
            String[] fkCols = new String[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                fkCols[i] = entityName + "_" + fields.get(i).getColumn();
            }
            return fkCols;
        }
        return null;
    }

    public abstract void resolve(CFCPersistenceMetadata var1, Map<String, CFCPersistenceMetadata> var2, DBMetaData var3);

    public abstract boolean isResolved();

    public abstract int getRelationType();

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getSqlType() {
        return this.sqlType;
    }
}

