/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.filter.FusionContext;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.hibernate.CFCPropertyGetter;
import coldfusion.orm.hibernate.CFCPropertySetter;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.util.Key;
import java.io.Serializable;
import java.util.Locale;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.component.AbstractComponentTuplizer;
import org.hibernate.type.Type;

public class ComponentTuplizer
extends AbstractComponentTuplizer {
    private Class componentClass;

    public ComponentTuplizer(Component component) {
        super(component);
    }

    protected Getter buildGetter(Component component, Property prop) {
        Type type = null;
        if (prop.getValue() != null) {
            type = prop.getType();
        }
        return new CFCPropertyGetter(prop.getName(), type, component.getComponentClassName());
    }

    protected void setComponentClass(Component component) {
        this.componentClass = PersistentTemplateProxy.class;
    }

    protected Instantiator buildInstantiator(Component component) {
        return new ComponentInstantiator(component.getComponentClassName());
    }

    protected Setter buildSetter(Component component, Property prop) {
        return new CFCPropertySetter(prop.getName());
    }

    public Class getMappedClass() {
        return PersistentTemplateProxy.class;
    }

    public static class ComponentInstantiationException
    extends NeoException {
        public String cfcName;

        public ComponentInstantiationException(String cfcName, Throwable throwable) {
            super(throwable);
            this.cfcName = cfcName;
        }

        public String getDetail() {
            if (this.detail == null) {
                this.detail = this.rootCause != null ? ComponentInstantiationException.getString((Throwable)((Object)this), (String)"detailException", (Locale)this.locale) : ComponentInstantiationException.getString((Throwable)((Object)this), (String)"detail", (Locale)this.locale);
            }
            return this.detail;
        }
    }

    public static class ComponentInstantiator
    implements Instantiator {
        private String cfcName;

        public ComponentInstantiator(String cfcName) {
            this.cfcName = cfcName;
        }

        public Object instantiate() {
            Invokable obj;
            try {
                obj = ComponentProxyFactory.getProxy((String)this.cfcName, (NeoPageContext)FusionContext.getCurrent().pageContext, null, null);
            }
            catch (NeoException ne) {
                throw ne;
            }
            catch (Throwable throwable) {
                throw new ComponentInstantiationException(this.cfcName, throwable);
            }
            if (obj instanceof PersistentTemplateProxy) {
                return obj;
            }
            throw new ComponentInstantiationException(this.cfcName, null);
        }

        public Object instantiate(Serializable id) {
            return this.instantiate();
        }

        public boolean isInstance(Object object) {
            AttributeCollection metadata = null;
            if (object instanceof TemplateProxy) {
                TemplateProxy cfc = (TemplateProxy)object;
                metadata = (AttributeCollection)cfc.getMetadata();
            }
            while (metadata != null && !metadata.get(Key.NAME).equals("WEB-INF.cftags.component")) {
                if (this.cfcName.equalsIgnoreCase((String)metadata.get(Key.FULLNAME))) {
                    return true;
                }
                metadata = (AttributeCollection)metadata.get(Key.EXTENDS);
            }
            return false;
        }
    }
}

