/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.filter.FusionContext;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.hibernate.CFCObjectProxy;
import coldfusion.orm.hibernate.CFCPropertyGetter;
import coldfusion.orm.hibernate.CFCPropertySetter;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.Key;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class CFCTuplizer
extends AbstractEntityTuplizer {
    private static final Object[] noArgs = new Object[0];

    public CFCTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappingInfo) {
        super(entityMetamodel, mappingInfo);
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        Type type = null;
        if (mappedProperty.getValue() != null) {
            type = mappedProperty.getType();
        }
        return new CFCPropertyGetter(mappedProperty.getName(), type, mappedEntity.getEntityName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return new CFCPropertySetter(mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass mappingInfo) {
        return new CFCinstantiator(mappingInfo);
    }

    public void setIdentifier(Object entity, Serializable id, SharedSessionContractImplementor session) {
        if (this.getEntityMetamodel().getIdentifierProperty().isEmbedded() && entity instanceof PersistentTemplateProxy) {
            PersistentTemplateProxy templateProxy = (PersistentTemplateProxy)((Object)entity);
            Map idObj = (Map)((Object)id);
            Set entries = idObj.entrySet();
            for (Map.Entry entry : entries) {
                templateProxy.setProperty((String)entry.getKey(), entry.getValue());
            }
        } else {
            super.setIdentifier(entity, id, session);
        }
    }

    public Serializable getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (this.getEntityMetamodel().getIdentifierProperty().isEmbedded() && entity instanceof PersistentTemplateProxy) {
            return ((PersistentTemplateProxy)((Object)entity)).getIdentifier();
        }
        return super.getIdentifier(entity, session);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        return new CFCProxyFactory(this.getEntityName());
    }

    public Class getConcreteProxyClass() {
        return PersistentTemplateProxy.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    public Class getMappedClass() {
        return PersistentTemplateProxy.class;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return null;
    }

    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        if (entityInstance instanceof TemplateProxy) {
            TemplateProxy cfc = (TemplateProxy)entityInstance;
            AttributeCollection metadata = (AttributeCollection)cfc.getMetadata();
            String cfcName = (String)metadata.get(Key.FULLNAME);
            HibernateConfiguration config = (HibernateConfiguration)ORMProvider.getDefault().getCurrentConfiguration();
            return config.getEntityName(cfcName);
        }
        return null;
    }

    protected Instantiator buildInstantiator(EntityMetamodel metamodel, PersistentClass mappingInfo) {
        return new CFCinstantiator(mappingInfo);
    }

    public static class CFCInstantiationException
    extends ApplicationException {
        public String cfcName;

        public CFCInstantiationException(String cfcName, Throwable throwable) {
            super(throwable);
            this.cfcName = cfcName;
        }

        public String getDetail() {
            if (this.detail == null) {
                this.detail = this.rootCause != null ? CFCInstantiationException.getString((Throwable)((Object)this), (String)"detailException", (Locale)this.locale) : CFCInstantiationException.getString((Throwable)((Object)this), (String)"detail", (Locale)this.locale);
            }
            return this.detail;
        }
    }

    public static class CFCProxyFactory
    implements ProxyFactory {
        private String entityName;

        public CFCProxyFactory(String entityName) {
            this.entityName = entityName;
        }

        public HibernateProxy getProxy(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
            return new CFCObjectProxy(this.entityName, id, session);
        }

        public void postInstantiate(String arg0, Class arg1, Set arg2, Method arg3, Method arg4, CompositeType arg5) throws HibernateException {
        }
    }

    public static class CFCinstantiator
    implements Instantiator {
        private String entityName;
        private boolean embeddedIdentifer = false;

        public CFCinstantiator(PersistentClass mappingInfo) {
            this.entityName = mappingInfo.getEntityName();
            this.embeddedIdentifer = mappingInfo.hasEmbeddedIdentifier();
        }

        public Object instantiate(Serializable id) {
            if (id instanceof TemplateProxy) {
                return id;
            }
            Object obj = this.instantiate();
            if (this.embeddedIdentifer && id instanceof Map) {
                Map idObj = (Map)((Object)id);
                for (Map.Entry pkField : idObj.entrySet()) {
                    if (!(obj instanceof PersistentTemplateProxy)) continue;
                    ((PersistentTemplateProxy)((Object)obj)).setProperty((String)pkField.getKey(), pkField.getValue());
                }
            }
            return obj;
        }

        public Object instantiate() {
            Invokable obj;
            HibernateConfiguration config = (HibernateConfiguration)ORMProvider.getDefault().getCurrentConfiguration();
            String cfcName = config.getCFCName(this.entityName);
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            try {
                obj = ComponentProxyFactory.getProxy((String)cfcName, (NeoPageContext)pageContext, null, null);
                if (obj instanceof PersistentTemplateProxy) {
                    TemplateProxy cfc = (TemplateProxy)obj;
                    Map metadata = (Map)cfc.getMetadata();
                    String initMethod = (String)metadata.get("initmethod");
                    String string = initMethod = initMethod == null ? "init" : initMethod;
                    if (cfc.get((Object)initMethod) instanceof UDFMethod) {
                        cfc.invoke(initMethod, noArgs, (PageContext)pageContext);
                    }
                }
            }
            catch (NeoException ne) {
                throw ne;
            }
            catch (Throwable throwable) {
                throw new CFCInstantiationException(cfcName, throwable);
            }
            if (obj instanceof PersistentTemplateProxy) {
                return obj;
            }
            throw new CFCInstantiationException(cfcName, null);
        }

        public boolean isInstance(Object object) {
            HibernateConfiguration config = (HibernateConfiguration)ORMProvider.getDefault().getCurrentConfiguration();
            String cfcName = config.getCFCName(this.entityName);
            AttributeCollection metadata = null;
            if (object instanceof TemplateProxy) {
                TemplateProxy cfc = (TemplateProxy)object;
                metadata = (AttributeCollection)cfc.getMetadata();
            }
            while (metadata != null && !metadata.get(Key.NAME).equals("WEB-INF.cftags.component")) {
                if (cfcName.equalsIgnoreCase((String)metadata.get(Key.FULLNAME))) {
                    return true;
                }
                metadata = (AttributeCollection)metadata.get(Key.EXTENDS);
            }
            return false;
        }
    }
}

