/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class UnitSpan
implements Comparable<UnitSpan> {
    private static final UnitMapEntry[] gUnitMap = new UnitMapEntry[]{new UnitMapEntry("pt", "PT", 19, 1000), new UnitMapEntry("mm", "MM", 17, 25000), new UnitMapEntry("in", "IN", 3, 72000), new UnitMapEntry("cm", "CM", 1, 250000), new UnitMapEntry("mp", "MP", 35, 1), new UnitMapEntry("pc", "PC", 51, 12000)};
    private static final String gsCm = "cm, centimeters";
    private static final String gsInch = "in, inches";
    private static final String gsMm = "mm, millimeters";
    private static final String gsMp = "mp, millipoints";
    private static final String gsPt = "pt, points";
    private static final String gsPica = "pc, picas";
    private static final String gsNumeric = "-0123456789.";
    public static final int INCHES_1M = 0;
    public static final int CM_250K = 1;
    public static final int INCHES_72K = 3;
    public static final int MM_25K = 17;
    public static final int POINTS_1K = 19;
    public static final int PICA_PT_1K = 19;
    public static final int MILLIPOINT = 35;
    public static final int PICA_PT_10K = 2;
    public static final int PICAS_12K = 51;
    public static final int UNIT_MASK = 15;
    public static final int UNIT_UNKNOWN = 255;
    public static final int UNITS_CM_250K = 635000;
    public static final int UNITS_INCHES_1M = 1000000;
    public static final int UNITS_INCHES_72K = 72000;
    public static final int UNITS_MILLIPOINT = 72000;
    public static final int UNITS_MM_25K = 635000;
    public static final int UNITS_POINTS_1K = 72000;
    public static final int UNITS_PICAS_12K = 72000;
    public static final UnitSpan ZERO = new UnitSpan();
    private final int meUnit;
    private final int mnValue;

    static int applyFactor(int nValue, int nNumerator, int nDenominator) {
        int nRemainder = nValue % nDenominator;
        if (nValue > 0) {
            return (nValue - nRemainder) / nDenominator * nNumerator + (10 * nRemainder * nNumerator / nDenominator + 5) / 10;
        }
        return (nValue - nRemainder) / nDenominator * nNumerator + (10 * nRemainder * nNumerator / nDenominator - 5) / 10;
    }

    public UnitSpan changeUnits(int eUnits) {
        return new UnitSpan(eUnits, this.valueAsUnit(eUnits));
    }

    static int convertReally(int nTo, int nFrom, int nValue) {
        int nUnitsTo = nTo & 0xF;
        int nUnitsFrom = nFrom & 0xF;
        if (nUnitsTo == nUnitsFrom) {
            return nValue;
        }
        int nNumerator = 1;
        int nDenominator = 1;
        switch (nUnitsTo) {
            case 0: {
                switch (nUnitsFrom) {
                    case 1: {
                        nNumerator = 200;
                        nDenominator = 127;
                        break;
                    }
                    case 2: {
                        nNumerator = 25;
                        nDenominator = 18;
                        break;
                    }
                    case 3: {
                        nNumerator = 125;
                        nDenominator = 9;
                    }
                }
                break;
            }
            case 1: {
                switch (nUnitsFrom) {
                    case 0: {
                        nNumerator = 127;
                        nDenominator = 200;
                        break;
                    }
                    case 2: {
                        nNumerator = 127;
                        nDenominator = 144;
                        break;
                    }
                    case 3: {
                        nNumerator = 635;
                        nDenominator = 72;
                    }
                }
                break;
            }
            case 2: {
                switch (nUnitsFrom) {
                    case 0: {
                        nNumerator = 18;
                        nDenominator = 25;
                        break;
                    }
                    case 1: {
                        nNumerator = 144;
                        nDenominator = 127;
                        break;
                    }
                    case 3: {
                        nNumerator = 10;
                        nDenominator = 1;
                    }
                }
                break;
            }
            case 3: {
                switch (nUnitsFrom) {
                    case 0: {
                        nNumerator = 9;
                        nDenominator = 125;
                        break;
                    }
                    case 1: {
                        nNumerator = 72;
                        nDenominator = 635;
                        break;
                    }
                    case 2: {
                        nNumerator = 1;
                        nDenominator = 10;
                    }
                }
                break;
            }
            default: {
                throw new ExFull(new MsgFormat(ResId.ERR_UNITSPAN_UNITS, Integer.toString(nTo)));
            }
        }
        return UnitSpan.applyFactor(nValue, nNumerator, nDenominator);
    }

    public static int convertUnit(int eNewUnits, int eOldUnits, int nValue) {
        if ((eNewUnits & 0xF) == (eOldUnits & 0xF)) {
            return nValue;
        }
        return UnitSpan.convertReally(eNewUnits, eOldUnits, nValue);
    }

    public static int defaultUnits() {
        return 3;
    }

    public static String measurementValidate(String sText, boolean negValid) {
        int nUnitStart;
        int nNumStart = StringUtils.skipUntil(sText, gsNumeric, 0);
        int nLength = StringUtils.skipOver(sText, gsNumeric, nNumStart);
        int n = nUnitStart = nLength == 0 ? 0 : nNumStart + nLength;
        if (nNumStart > 0) {
            return new UnitSpan(sText).text(8, false, false);
        }
        int MAXUNITCHARS = 6;
        char[] cUnits = new char[MAXUNITCHARS + 1];
        int nUnitPos = 0;
        boolean bUnitsStarted = false;
        int strLen = sText.length();
        for (int n2 = nUnitStart; n2 < strLen; ++n2) {
            char c = sText.charAt(n2);
            if (c == ' ' || c == '.' || c == '\u0000') {
                if (!bUnitsStarted && c != '\u0000') continue;
                break;
            }
            cUnits[nUnitPos++] = c;
            bUnitsStarted = true;
            if (nUnitPos != MAXUNITCHARS) continue;
            cUnits[nUnitPos] = '\u0000';
            break;
        }
        bUnitsStarted = false;
        if (nUnitPos > 1) {
            if (cUnits[0] == 'i' || cUnits[0] == 'I') {
                bUnitsStarted = true;
            } else if (cUnits[0] == 'm' || cUnits[0] == 'M') {
                bUnitsStarted = true;
                if (cUnits[1] == 'p' || cUnits[1] == 'P') {
                    bUnitsStarted = true;
                } else if (nUnitPos > 5 && (cUnits[5] == 'p' || cUnits[5] == 'P')) {
                    bUnitsStarted = true;
                }
            } else if (cUnits[0] == 'c' || cUnits[0] == 'C') {
                bUnitsStarted = true;
            } else if (cUnits[0] == 'p' || cUnits[0] == 'P') {
                bUnitsStarted = true;
            }
        }
        if (!bUnitsStarted) {
            return new UnitSpan(sText).text(8, false, false);
        }
        int nDecimals = 0;
        for (int i = nNumStart; i != nNumStart + nLength; ++i) {
            char c = sText.charAt(i);
            if (c == '-') {
                if (!negValid) {
                    return ZERO.text(0, false, false);
                }
                if (i == nNumStart) continue;
                return new UnitSpan(sText).text(0, false, false);
            }
            if (c != '.') continue;
            if (nDecimals > 1) {
                return new UnitSpan(sText).text(0, false, false);
            }
            ++nDecimals;
        }
        return sText;
    }

    public static int stringToUnit(String sUnit, int eDefaultUnits) {
        if (!StringUtils.isEmpty(sUnit)) {
            String sUnitText = UnitSpan.unitToString(3);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 3;
            }
            sUnitText = UnitSpan.unitToString(1);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 1;
            }
            sUnitText = UnitSpan.unitToString(17);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 17;
            }
            sUnitText = UnitSpan.unitToString(19);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 19;
            }
            sUnitText = UnitSpan.unitToString(35);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 35;
            }
            sUnitText = UnitSpan.unitToString(51);
            if (StringUtils.findNoCase(sUnitText, sUnit, 0) != -1) {
                return 51;
            }
        }
        return eDefaultUnits != 255 ? eDefaultUnits : UnitSpan.defaultUnits();
    }

    public static int unitsPerInch(int eUnit) {
        switch (eUnit) {
            case 0: {
                return 1000000;
            }
            case 1: 
            case 17: {
                return 635000;
            }
            case 3: {
                return 72000;
            }
            case 19: {
                return 72000;
            }
            case 35: {
                return 72000;
            }
            case 51: {
                return 72000;
            }
        }
        throw new ExFull(new MsgFormat(ResId.ERR_UNITSPAN_UNITS, Integer.toString(eUnit)));
    }

    public static String unitToString(int eUnit) {
        switch (eUnit) {
            case 0: 
            case 3: {
                return gsInch;
            }
            case 1: {
                return gsCm;
            }
            case 17: {
                return gsMm;
            }
            case 19: {
                return gsPt;
            }
            case 35: {
                return gsMp;
            }
            case 51: {
                return gsPica;
            }
        }
        throw new ExFull(new MsgFormat(ResId.ERR_UNITSPAN_UNITS, Integer.toString(eUnit)));
    }

    public static int unitToValue(double dValue, int eUnit) {
        switch (eUnit) {
            case 0: {
                return (int)Math.round(dValue * 1000000.0);
            }
            case 1: {
                return (int)Math.round(dValue * 250000.0);
            }
            case 17: {
                return (int)Math.round(dValue * 25000.0);
            }
            case 3: {
                return (int)Math.round(dValue * 72000.0);
            }
            case 19: {
                return (int)Math.round(dValue * 1000.0);
            }
            case 35: {
                return (int)Math.round(dValue);
            }
            case 51: {
                return (int)Math.round(dValue * 12000.0);
            }
        }
        throw new ExFull(new MsgFormat(ResId.ERR_UNITSPAN_UNITS, Integer.toString(eUnit)));
    }

    public static double valueToUnit(int nValue, int eUnit) {
        switch (eUnit) {
            case 0: {
                return (double)nValue / 1000000.0;
            }
            case 1: {
                return (double)nValue / 250000.0;
            }
            case 17: {
                return (double)nValue / 25000.0;
            }
            case 3: {
                return (double)nValue / 72000.0;
            }
            case 19: {
                return (double)nValue / 1000.0;
            }
            case 35: {
                return nValue;
            }
            case 51: {
                return (double)nValue / 12000.0;
            }
        }
        throw new ExFull(new MsgFormat(ResId.ERR_UNITSPAN_UNITS, Integer.toString(eUnit)));
    }

    public static UnitSpan zero() {
        return ZERO;
    }

    public UnitSpan() {
        this.meUnit = UnitSpan.defaultUnits();
        this.mnValue = 0;
    }

    public UnitSpan(double dValue, int eUnits) {
        this.meUnit = eUnits;
        this.mnValue = UnitSpan.unitToValue(dValue, eUnits);
    }

    public UnitSpan(int nValue) {
        this.meUnit = 255;
        this.mnValue = nValue;
    }

    public UnitSpan(int eUnits, int nValue) {
        this.meUnit = eUnits;
        this.mnValue = nValue;
    }

    public UnitSpan(int eNewUnits, int eOldUnits, int nOldValue) {
        this.meUnit = eNewUnits;
        this.mnValue = UnitSpan.convertUnit(eNewUnits, eOldUnits, nOldValue);
    }

    public UnitSpan(String sText) {
        this(sText, 255, false);
    }

    public UnitSpan(String sText, int eDefaultUnits, boolean bDefaultValuePerUnit) {
        ParseData oParseData = UnitSpan.validatingParse(sText, eDefaultUnits, true, bDefaultValuePerUnit, false);
        if (oParseData != null && oParseData.meUnits != 255) {
            this.meUnit = oParseData.meUnits;
            this.mnValue = oParseData.mnValue;
            return;
        }
        int nNumStart = StringUtils.skipUntil(sText, gsNumeric, 0);
        int nLength = StringUtils.skipOver(sText, gsNumeric, nNumStart);
        int nUnitStart = nLength == 0 ? 0 : nNumStart + nLength;
        int nUnitPos = 0;
        boolean bUnitsStarted = false;
        boolean bSlashFound = false;
        int eUnits = eDefaultUnits != 255 ? eDefaultUnits : UnitSpan.defaultUnits();
        boolean bDefaultUnitsUsed = true;
        boolean bValuePerUnit = bDefaultValuePerUnit;
        int c1 = 0;
        int c2 = 0;
        char c5 = '\u0000';
        for (int n = nUnitStart; n < sText.length(); ++n) {
            char c = sText.charAt(n);
            if (c == ' ' || c == '.' || c == '\u0000') {
                if (!bUnitsStarted && c != '\u0000') continue;
                break;
            }
            if (c == '/') {
                bSlashFound = true;
                continue;
            }
            if (nUnitPos == 0) {
                c1 = c;
            } else if (nUnitPos == 1) {
                c2 = c;
            } else if (nUnitPos == 5) {
                c5 = c;
            }
            ++nUnitPos;
            bUnitsStarted = true;
        }
        if (nUnitPos > 1) {
            bDefaultUnitsUsed = false;
            if (c1 == 105 || c1 == 73) {
                eUnits = 3;
                bValuePerUnit = bSlashFound;
                if (bValuePerUnit) {
                    eUnits = 0;
                }
            } else if (c1 == 109 || c1 == 77) {
                eUnits = 17;
                if (c2 == 112 || c2 == 80) {
                    eUnits = 35;
                } else if (nUnitPos > 5 && (c5 == 'p' || c5 == 'P')) {
                    eUnits = 35;
                }
                bValuePerUnit = bSlashFound;
            } else if (c1 == 99 || c1 == 67) {
                eUnits = 1;
                bValuePerUnit = bSlashFound;
            } else if (c1 == 112 || c1 == 80) {
                eUnits = 19;
                bValuePerUnit = bSlashFound;
                if (c2 == 99 || c2 == 67 || c2 == 105 || c2 == 73) {
                    eUnits = 51;
                }
            } else {
                bDefaultUnitsUsed = true;
            }
        }
        this.meUnit = eUnits;
        int nFactor = 0;
        switch (this.units()) {
            case 0: {
                nFactor = 1000000;
                break;
            }
            case 1: {
                nFactor = 250000;
                break;
            }
            case 17: {
                nFactor = 25000;
                break;
            }
            case 3: {
                nFactor = 72000;
                break;
            }
            case 19: {
                nFactor = 1000;
                break;
            }
            case 35: {
                nFactor = 1;
                break;
            }
            case 51: {
                nFactor = 12000;
            }
        }
        int nValue = 0;
        int nFraction = 0;
        int nDecimals = -1;
        boolean bNegative = false;
        for (int i = nNumStart; i != nNumStart + nLength; ++i) {
            char c = sText.charAt(i);
            if (c == '-') {
                bNegative = true;
                continue;
            }
            if (c == '.') {
                nDecimals = 0;
                continue;
            }
            if (nDecimals == -1) {
                nValue *= 10;
                if ((nValue += (c - 48) * nFactor) >= 0) continue;
                nValue = Integer.MAX_VALUE;
                break;
            }
            if (c != '0') {
                int nDecimal = (c - 48) * nFactor;
                for (int k = 0; k < nDecimals; ++k) {
                    nDecimal /= 10;
                }
                nFraction += nDecimal;
            }
            ++nDecimals;
        }
        if ((nValue += (nFraction + 5) / 10) < 0) {
            this.mnValue = Integer.MAX_VALUE;
            return;
        }
        if (bNegative) {
            nValue *= -1;
        } else if (bValuePerUnit) {
            if (bDefaultUnitsUsed && eUnits == 17) {
                nValue /= 10;
            } else if (eUnits == 19) {
                nValue /= 12;
            }
            double dFactor = nFactor;
            nValue = (int)(dFactor * dFactor / (double)nValue);
        }
        this.mnValue = nValue;
    }

    public UnitSpan(UnitSpan source) {
        this.meUnit = source.meUnit;
        this.mnValue = source.mnValue;
    }

    public UnitSpan abs() {
        if (this.value() > 0) {
            return this;
        }
        return new UnitSpan(this.units(), -this.value());
    }

    public UnitSpan add(UnitSpan add) {
        int nAdd = UnitSpan.convertUnit(this.units(), add.units(), add.value());
        return new UnitSpan(this.units(), this.value() + nAdd);
    }

    UnitSpan applyFactor(int nNumerator, int nDenominator) {
        if (nNumerator % nDenominator == 0) {
            return new UnitSpan(this.units(), this.value() * (nNumerator / nDenominator));
        }
        if (this.value() % nDenominator == 0) {
            return new UnitSpan(this.units(), nNumerator * (this.value() / nDenominator));
        }
        int nTop = nNumerator;
        int nBottom = nDenominator;
        while (nTop % 10 == 0 && nBottom % 10 == 0) {
            nTop = (int)((long)nTop / 10L);
            nBottom = (int)((long)nBottom / 10L);
            if (this.value() % nBottom != 0) continue;
            return new UnitSpan(this.units(), nTop * (this.value() / nBottom));
        }
        double dScale = (double)nNumerator / (double)nDenominator;
        return new UnitSpan(this.units(), (int)Math.round((double)this.value() * dScale));
    }

    public UnitSpan divide(int nDivisor) {
        return new UnitSpan(this.units(), this.mnValue / nDivisor);
    }

    public double divide(UnitSpan divisor) {
        UnitSpan oConverted = new UnitSpan(this.units(), divisor.units(), divisor.value());
        return (double)this.value() / (double)oConverted.value();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo((UnitSpan)object) == 0;
    }

    public int hashCode() {
        return 31 * (this.meUnit & 0xF) ^ this.mnValue;
    }

    public UnitSpan grid(UnitSpan grid) {
        int value = UnitSpan.convertUnit(grid.units(), this.units(), this.value());
        int gridValue = grid.value();
        if (gridValue != 0 && value % gridValue != 0) {
            value = (int)(Math.floor((double)value / (double)gridValue) * (double)gridValue);
            return new UnitSpan(this.units(), UnitSpan.convertUnit(this.units(), grid.units(), value));
        }
        return this;
    }

    public boolean gt(UnitSpan compare) {
        return this.compareTo(compare) > 0;
    }

    public boolean gte(UnitSpan compare) {
        return this.compareTo(compare) >= 0;
    }

    public boolean lt(UnitSpan compare) {
        return this.compareTo(compare) < 0;
    }

    public boolean lte(UnitSpan compare) {
        return this.compareTo(compare) <= 0;
    }

    public UnitSpan multiply(double dScale) {
        return new UnitSpan(this.units(), (int)Math.round((double)this.value() * dScale));
    }

    public UnitSpan multiply(int nScale) {
        return new UnitSpan(this.units(), this.mnValue * nScale);
    }

    public UnitSpan round(UnitSpan round) {
        int rounded = UnitSpan.convertUnit(round.units(), this.units(), this.value());
        int nAbsRound = Math.abs(round.value());
        if (round.value() != 0 && rounded % round.value() != 0) {
            int nQuotient = rounded / nAbsRound;
            if (Math.abs((double)rounded / (double)nAbsRound - (double)nQuotient) >= 0.5) {
                nQuotient = nQuotient > 0 ? ++nQuotient : --nQuotient;
            }
            rounded = nQuotient * nAbsRound;
            return new UnitSpan(this.units(), UnitSpan.convertUnit(this.units(), round.units(), rounded));
        }
        return this;
    }

    public UnitSpan subtract(UnitSpan subtract) {
        int lSubtract = UnitSpan.convertUnit(this.units(), subtract.units(), subtract.value());
        return new UnitSpan(this.units(), this.value() - lSubtract);
    }

    public String text(int nPrecision, boolean bTruncate, boolean bValuePerUnits) {
        if (this.units() == 255) {
            return Integer.toString(this.value());
        }
        int nValue = this.value();
        int nFactor = 0;
        int STRSIZE = 32;
        char[] cValue = new char[32];
        cValue[31] = '\u0000';
        switch (this.units()) {
            case 0: {
                nFactor = 6;
                cValue[29] = 105;
                cValue[30] = 110;
                break;
            }
            case 1: {
                nValue = UnitSpan.applyFactor(this.value(), 10, 25);
                nFactor = 5;
                cValue[29] = 99;
                cValue[30] = 109;
                break;
            }
            case 17: {
                nValue = UnitSpan.applyFactor(this.value(), 10, 25);
                nFactor = 4;
                cValue[29] = 109;
                cValue[30] = 109;
                break;
            }
            case 2: {
                nFactor = 4;
                cValue[29] = 112;
                cValue[30] = 116;
                break;
            }
            case 3: {
                nValue = UnitSpan.convertReally(0, 3, this.value());
                nFactor = 6;
                cValue[29] = 105;
                cValue[30] = 110;
                break;
            }
            case 19: {
                nFactor = 3;
                cValue[29] = 112;
                cValue[30] = 116;
                break;
            }
            case 35: {
                nFactor = 0;
                cValue[29] = 109;
                cValue[30] = 112;
                break;
            }
            case 51: {
                nValue = UnitSpan.applyFactor(this.value(), 1, 12);
                nFactor = 3;
                cValue[29] = 112;
                cValue[30] = 99;
            }
        }
        int nPos = 28;
        if (bValuePerUnits) {
            if (this.units() == 17) {
                nFactor = 5;
                cValue[29] = 99;
                cValue[30] = 109;
            }
            if (this.units() == 2 || this.units() == 19 || this.units() == 35) {
                nValue = (int)((long)nValue / 12L);
                cValue[29] = 112;
                cValue[30] = 99;
            }
            cValue[28] = 47;
            nPos = 27;
            double factor = Math.pow(10.0, nFactor);
            nValue = (int)(factor * factor / (double)nValue);
            nValue = (nValue + 50) / 100 * 100;
        }
        boolean bNegative = false;
        if (nValue < 0) {
            nValue *= -1;
            bNegative = true;
        }
        while (nFactor > nPrecision) {
            nValue = nFactor == nPrecision + 1 ? (nValue + 5) / 10 : (nValue /= 10);
            --nFactor;
        }
        boolean bZeroValue = (long)nValue == 0L;
        boolean bAllZeros = true;
        if (bZeroValue) {
            cValue[nPos--] = 48;
        } else {
            while (nValue > 0) {
                int cDigit;
                if (nFactor == 0 && !bAllZeros) {
                    cValue[nPos--] = 46;
                }
                if ((cDigit = nValue % 10 + 48) != 48 || !bAllZeros || nFactor <= 0) {
                    cValue[nPos--] = (char)cDigit;
                    bAllZeros = false;
                }
                nValue /= 10;
                --nFactor;
            }
            while (nFactor > 0) {
                cValue[nPos--] = 48;
                --nFactor;
            }
            if (nFactor == 0 && !bAllZeros) {
                cValue[nPos--] = 46;
                cValue[nPos--] = 48;
            }
            if (bNegative && !bZeroValue) {
                cValue[nPos--] = 45;
            }
        }
        return new String(cValue, nPos + 1, 32 - nPos - 2);
    }

    public String toString() {
        return this.text(8, false, false);
    }

    public int units() {
        return this.meUnit;
    }

    public int unitsPerInch() {
        return UnitSpan.unitsPerInch(this.meUnit);
    }

    /*
     * WARNING - void declaration
     */
    public static ParseData validatingParse(String sText, int eDefaultUnits, boolean bAllowNegative, boolean bForceValuePerUnit, boolean bAllowPercent) {
        int nValue = 0;
        int nFraction = 0;
        int nFractionScale = 1;
        char cUnit0 = '\u0000';
        char cUnit1 = '\u0000';
        char cUnit2 = '\u0000';
        int eUnits = 255;
        boolean bValuePerUnit = bForceValuePerUnit;
        boolean bPercent = false;
        State eState = State.PreSign;
        int MAX_FRACTION_SCALE = 10000000;
        boolean bNegative = false;
        boolean bSlashSeen = false;
        int nUnitIndex = 0;
        block56: for (int i2 = 0; i2 < sText.length(); ++i2) {
            char c = sText.charAt(i2);
            int cType = c;
            if ('0' <= c && c <= '9') {
                cType = 48;
            } else if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                cType = 97;
            }
            switch (eState) {
                case PreSign: {
                    switch (cType) {
                        case 45: {
                            if (!bAllowNegative) {
                                return null;
                            }
                            bNegative = true;
                            eState = State.PreNumber;
                            continue block56;
                        }
                        case 43: {
                            eState = State.PreNumber;
                            continue block56;
                        }
                        case 48: {
                            nValue = c - 48;
                            eState = State.WholePart;
                            continue block56;
                        }
                        case 46: {
                            eState = State.FractionStart;
                            continue block56;
                        }
                        case 32: {
                            continue block56;
                        }
                    }
                    return null;
                }
                case PreNumber: {
                    switch (cType) {
                        case 48: {
                            nValue = c - 48;
                            eState = State.WholePart;
                            continue block56;
                        }
                        case 46: {
                            eState = State.FractionStart;
                            continue block56;
                        }
                        case 32: {
                            continue block56;
                        }
                    }
                    return null;
                }
                case WholePart: {
                    switch (cType) {
                        case 48: {
                            if (nValue >= Integer.MAX_VALUE || (nValue = nValue * 10 + (c - 48)) >= 0) continue block56;
                            nValue = Integer.MAX_VALUE;
                            continue block56;
                        }
                        case 46: {
                            eState = State.FractionPart;
                            continue block56;
                        }
                        case 97: {
                            assert (nUnitIndex == 0);
                            cUnit0 = c;
                            ++nUnitIndex;
                            eState = State.Units;
                            continue block56;
                        }
                        case 37: {
                            if (!bAllowPercent) {
                                return null;
                            }
                            bPercent = true;
                            eState = State.PostValue;
                            continue block56;
                        }
                        case 47: {
                            bValuePerUnit = true;
                            bSlashSeen = true;
                            eState = State.PostNumber;
                            continue block56;
                        }
                        case 32: {
                            eState = State.PostNumber;
                            continue block56;
                        }
                    }
                    return null;
                }
                case FractionStart: {
                    switch (cType) {
                        case 48: {
                            nFraction = c - 48;
                            nFractionScale *= 10;
                            eState = State.FractionPart;
                            continue block56;
                        }
                    }
                    return null;
                }
                case FractionPart: {
                    switch (cType) {
                        case 48: {
                            if (nFractionScale > 10000000) continue block56;
                            nFraction = nFraction * 10 + (c - 48);
                            nFractionScale *= 10;
                            continue block56;
                        }
                        case 97: {
                            assert (nUnitIndex == 0);
                            cUnit0 = c;
                            ++nUnitIndex;
                            eState = State.Units;
                            continue block56;
                        }
                        case 37: {
                            if (!bAllowPercent) {
                                return null;
                            }
                            bPercent = true;
                            eState = State.PostValue;
                            continue block56;
                        }
                        case 47: {
                            bValuePerUnit = true;
                            bSlashSeen = true;
                            eState = State.PostNumber;
                            continue block56;
                        }
                        case 32: {
                            eState = State.PostNumber;
                            continue block56;
                        }
                    }
                    return null;
                }
                case PostNumber: {
                    switch (cType) {
                        case 97: {
                            assert (nUnitIndex == 0);
                            cUnit0 = c;
                            ++nUnitIndex;
                            eState = State.Units;
                            continue block56;
                        }
                        case 37: {
                            if (!bAllowPercent) {
                                return null;
                            }
                            bPercent = true;
                            eState = State.PostValue;
                            continue block56;
                        }
                        case 47: {
                            if (bSlashSeen) {
                                return null;
                            }
                            bValuePerUnit = true;
                            bSlashSeen = true;
                            continue block56;
                        }
                        case 32: {
                            continue block56;
                        }
                    }
                    return null;
                }
                case Units: {
                    switch (cType) {
                        case 97: {
                            if (nUnitIndex == 0) {
                                cUnit0 = c;
                            } else if (nUnitIndex == 1) {
                                cUnit1 = c;
                            } else if (nUnitIndex == 2) {
                                cUnit2 = c;
                            } else assert (cUnit2 != '\u0000');
                            ++nUnitIndex;
                            continue block56;
                        }
                        case 32: {
                            eState = State.PostValue;
                            continue block56;
                        }
                    }
                    return null;
                }
                case PostValue: {
                    switch (cType) {
                        case 32: {
                            continue block56;
                        }
                    }
                    return null;
                }
            }
        }
        switch (eState) {
            case PreSign: 
            case PreNumber: 
            case FractionStart: {
                return null;
            }
        }
        UnitMapEntry unitMapEntry = null;
        if (eState != State.Units && eState != State.PostValue) {
            void var20_23;
            if (eDefaultUnits == 255) {
                eDefaultUnits = UnitSpan.defaultUnits();
            }
            boolean bl = false;
            while (var20_23 < gUnitMap.length) {
                UnitMapEntry oMapEntry = gUnitMap[var20_23];
                if (oMapEntry.meUnits == eDefaultUnits) {
                    unitMapEntry = oMapEntry;
                    break;
                }
                ++var20_23;
            }
        } else if (!bPercent && nUnitIndex == 2) {
            void var20_25;
            boolean bl = false;
            while (var20_25 < gUnitMap.length) {
                UnitMapEntry mapEntry = gUnitMap[var20_25];
                if (!(cUnit0 != mapEntry.msLower.charAt(0) && cUnit0 != mapEntry.msUpper.charAt(0) || cUnit1 != mapEntry.msLower.charAt(1) && cUnit1 != mapEntry.msUpper.charAt(1))) {
                    unitMapEntry = mapEntry;
                    break;
                }
                ++var20_25;
            }
        }
        if (unitMapEntry != null) {
            eUnits = unitMapEntry.meUnits;
            if (nValue < Integer.MAX_VALUE) {
                long l = (long)nValue * (long)unitMapEntry.mnUnitScale;
                if (nFraction != 0) {
                    long lFraction = nFraction;
                    lFraction *= (long)unitMapEntry.mnUnitScale;
                    lFraction += (long)(nFractionScale / 2);
                    l += (lFraction /= (long)nFractionScale);
                }
                nValue = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            }
            if (bValuePerUnit) {
                if (nValue == 0) {
                    return null;
                }
                double d = unitMapEntry.mnUnitScale;
                nValue = (int)Math.round(d * d / (double)nValue);
            }
        }
        if (bNegative) {
            nValue = -nValue;
            nFraction = -nFraction;
        }
        return new ParseData(nValue, nFraction, nFractionScale, eUnits, cUnit0, cUnit1, cUnit2, bValuePerUnit, bPercent);
    }

    public int value() {
        return this.mnValue;
    }

    public int valueAsUnit(int eUnits) {
        return UnitSpan.convertUnit(eUnits, this.units(), this.value());
    }

    public static boolean match(UnitSpan u1, UnitSpan u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u1.equals(u2);
    }

    @Override
    public int compareTo(UnitSpan compare) {
        if (compare == null) {
            throw new NullPointerException();
        }
        int nTest = UnitSpan.convertUnit(this.units(), compare.units(), compare.value());
        if (this.value() < nTest) {
            return -1;
        }
        if (this.value() > nTest) {
            return 1;
        }
        return 0;
    }

    private static enum State {
        PreSign,
        PreNumber,
        WholePart,
        FractionStart,
        FractionPart,
        PostNumber,
        Units,
        PostValue;

    }

    private static class UnitMapEntry {
        final String msLower;
        final String msUpper;
        final int meUnits;
        final int mnUnitScale;

        UnitMapEntry(String lower, String upper, int units, int unitScale) {
            this.msLower = lower;
            this.msUpper = upper;
            this.meUnits = units;
            this.mnUnitScale = unitScale;
        }
    }

    public static class ParseData {
        public final int mnValue;
        public final int mnFraction;
        public final int mnFractionScale;
        public final int meUnits;
        public final char mcUnit0;
        public final char mcUnit1;
        public final char mcUnit2;
        public final boolean mbValuePerUnit;
        public final boolean mbPercent;

        public ParseData(int nValue, int nFraction, int nFractionScale, int eUnits, char cUnit0, char cUnit1, char cUnit2, boolean bValuePerUnit, boolean bPercent) {
            this.mnValue = nValue;
            this.mnFraction = nFraction;
            this.mnFractionScale = nFractionScale;
            this.meUnits = eUnits;
            this.mcUnit0 = cUnit0;
            this.mcUnit1 = cUnit1;
            this.mcUnit2 = cUnit2;
            this.mbValuePerUnit = bValuePerUnit;
            this.mbPercent = bPercent;
        }
    }
}

