/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class ResourceLoader {
    private static final String gXFAResources = "com.adobe.xfa.messages_";
    private static final Properties mMessageStrings;
    private static final Properties mXFAProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(String sFile) {
        InputStream is = ResourceLoader.class.getResourceAsStream("/" + sFile);
        if (is != null) {
            try {
                Properties properties = new Properties();
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String loadResource(int nResId) {
        if (mMessageStrings != null) {
            String sResource = mMessageStrings.getProperty("IDS_XTG_" + Integer.toString(nResId));
            if (sResource == null) {
                sResource = "%s";
            }
            return sResource;
        }
        return "Can't locate resource IDS_XTG_" + Integer.toString(nResId);
    }

    public static String loadProperty(String property) {
        String propertyValue = null;
        if (mXFAProperties != null) {
            propertyValue = mXFAProperties.getProperty(property);
        }
        if (propertyValue == null) {
            propertyValue = System.getProperty(property);
        }
        if (propertyValue == null) {
            propertyValue = "";
        }
        return propertyValue;
    }

    static {
        String lang = Locale.getDefault().toString();
        if (StringUtils.isEmpty(lang)) {
            lang = "en";
        }
        String resFile = gXFAResources + lang + ".properties";
        Properties messageStrings = ResourceLoader.load(resFile);
        String deflt = Locale.getDefault().getLanguage();
        if (messageStrings == null && !deflt.equals(lang)) {
            lang = deflt;
            resFile = gXFAResources + lang + ".properties";
            messageStrings = ResourceLoader.load(resFile);
        }
        if (messageStrings == null && !lang.equals("en")) {
            messageStrings = ResourceLoader.load("com.adobe.xfa.messages_en.properties");
        }
        mMessageStrings = messageStrings;
        String propFile = "com.adobe.xfa.environment.properties";
        mXFAProperties = ResourceLoader.load(propFile);
    }
}

