/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ExErrItem;
import com.adobe.xfa.ut.ExceptionBase;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.List;

public class ExFull
extends ExceptionBase {
    private static final long serialVersionUID = -2764654020640603225L;
    private final List<ExErrItem> moItems = new ArrayList<ExErrItem>();

    public ExFull() {
    }

    public ExFull(Exception e) {
        this.moItems.add(new ExErrItem(ResId.SOFTWARE_FAILURE, e.getMessage()));
    }

    public ExFull(int nResId) {
        this.moItems.add(new ExErrItem(nResId));
    }

    ExFull(int nResId, boolean bWasReported) {
        super(bWasReported);
        this.moItems.add(new ExErrItem(nResId));
    }

    ExFull(int nResId, MsgFormatPos oFormat, boolean bWasReported) {
        super(bWasReported);
        MsgFormatPos oFmt = new MsgFormatPos(oFormat);
        ExErrItem oItem = new ExErrItem();
        String sFmt = oFmt.toString();
        oItem.text(sFmt);
        oItem.resId(nResId);
        oItem.formatObject(oFormat);
        this.moItems.add(oItem);
    }

    public ExFull(int nResId, String p1) {
        MsgFormatPos msg = new MsgFormatPos(nResId, p1);
        ExErrItem oItem = new ExErrItem();
        String sFmt = msg.toString();
        oItem.text(sFmt);
        oItem.resId(nResId);
        oItem.formatObject(msg);
        this.moItems.add(oItem);
    }

    public ExFull(String text, int resId) {
        ExErrItem oItem = new ExErrItem();
        oItem.text(text);
        oItem.resId(resId);
        this.moItems.add(oItem);
    }

    public ExFull(MsgFormat oFormat) {
        ExErrItem oItem = new ExErrItem();
        oItem.text(oFormat.toString());
        oItem.resId(oFormat.resId());
        oItem.formatObject(oFormat);
        this.moItems.add(oItem);
    }

    public ExFull(MsgFormatPos oFormat) {
        ExErrItem oItem = new ExErrItem();
        oItem.text(oFormat.toString());
        oItem.resId(oFormat.resId());
        oItem.formatObject(oFormat);
        this.moItems.add(oItem);
    }

    @Override
    public int count() {
        return this.moItems.size();
    }

    public int firstResId() {
        if (this.moItems.size() > 0) {
            return this.moItems.get(0).resId();
        }
        return 0;
    }

    public int getResId(int n) {
        if (n > this.count() - 1 || this.moItems.size() < 1) {
            return 0;
        }
        return this.moItems.get(n).resId();
    }

    public boolean hasResId(int nResId) {
        for (int i = 0; i < this.moItems.size(); ++i) {
            if (this.moItems.get(i).resId() != nResId) continue;
            return true;
        }
        return false;
    }

    public void insert(ExFull source, boolean bAppend) {
        for (int i = 0; i < source.moItems.size(); ++i) {
            if (bAppend) {
                this.moItems.add(source.moItems.get(i));
                continue;
            }
            this.moItems.add(0, source.moItems.get(i));
        }
    }

    @Override
    public ExErrItem item(int n) {
        return this.moItems.get(n);
    }

    @Override
    public void resolve() {
        for (int i = 0; i < this.moItems.size(); ++i) {
            this.moItems.get(i).resolve();
        }
    }

    @Override
    public String toString() {
        if (this.moItems.size() == 0) {
            return "";
        }
        this.resolve();
        StringBuilder sReturn = new StringBuilder();
        int n = this.moItems.size();
        for (int i = 0; i < n; ++i) {
            sReturn.append(this.moItems.get(i).text());
            sReturn.append('\n');
        }
        return sReturn.toString();
    }
}

