/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.gfx.GFXGlyphOrientation;
import com.adobe.xfa.text.Composition;
import com.adobe.xfa.text.DispEmbed;
import com.adobe.xfa.text.DispLineRaw;
import com.adobe.xfa.text.DispMapSpan;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;

class RawProcessor {
    private final DispLineRaw mpoLine;
    private final FormatInfo moFormatInfo;
    private final DispMapSpan moAnchor;
    private final DispMapSpan moRun;
    private TextAttr mpoPendingAttr;
    private int mnVisualCharCount;
    private boolean mbHasAmbiguousBreaks;
    private int[] moAccentRun;
    int mnAccentRunSize;
    private int meAccentRunBreak;
    private int meGlyphOrientation;

    RawProcessor(FormatInfo oFormatInfo, DispLineRaw poLine, TextPosnBase oInitialPosition, TextAttr poInitialAttr) {
        this.mpoLine = poLine;
        this.moFormatInfo = oFormatInfo;
        this.moAnchor = new DispMapSpan(poLine, new DispPosn(oInitialPosition));
        this.moRun = new DispMapSpan(poLine, new DispRun(poLine.frame(), poInitialAttr));
        this.mnVisualCharCount = 0;
        this.mbHasAmbiguousBreaks = false;
        this.moAccentRun = poLine.display().getContext().getAccentRun(0);
        this.meAccentRunBreak = 0;
        this.meGlyphOrientation = 0;
    }

    void processAttr(TextAttr poAttr) {
        this.flushAccentRun();
        poAttr = this.moFormatInfo.resolveAttr(poAttr);
        this.moFormatInfo.setAttr(poAttr);
        if (poAttr != null && poAttr.substituteFont()) {
            this.mpoLine.display().setFontSubstitution(true);
        }
        DispRun oNewRun = new DispRun(this.moRun.r(), this.moFormatInfo.getAttr());
        this.moRun.reset(oNewRun);
        this.mpoPendingAttr = null;
    }

    void processChar(int c, int eBreak, TextPosnBase poPosition) {
        int eGlyphOrientation;
        if (this.mpoLine.frame().isOrientationVertical() && this.meGlyphOrientation != (eGlyphOrientation = RawProcessor.figureVerticalOrientationsFromChar(c))) {
            this.flushAccentRun();
            DispRun oNewRun = new DispRun(this.moRun.r(), eGlyphOrientation);
            this.moRun.reset(oNewRun, false);
            this.meGlyphOrientation = eGlyphOrientation;
        }
        if (c == 9) {
            DispEmbed poDispEmbed;
            this.syncPosition(poPosition);
            DispTab poTab = new DispTab();
            TextAttr poAttr = this.moRun.r().getAttr();
            if (poAttr != null) {
                poTab.setHeight(poAttr.size());
            }
            if ((poDispEmbed = this.addEmbed(poTab, 9, TextCharProp.defaultSpace)) == null) {
                return;
            }
            DispTab poMappedTab = (DispTab)poDispEmbed.getEmbed();
            this.moFormatInfo.addTab(poMappedTab);
        } else if (c >= 8234 && c <= 8239) {
            this.syncPosition(poPosition);
            this.addChar(c, eBreak);
        } else {
            int newSize;
            if (TextCharProp.getBreakClass(eBreak) != 8) {
                this.syncPosition(poPosition);
                this.meAccentRunBreak = eBreak;
            }
            if ((newSize = this.mnAccentRunSize + 1) >= this.moAccentRun.length) {
                this.moAccentRun = this.mpoLine.display().getContext().getAccentRun(newSize);
            }
            this.moAccentRun[this.mnAccentRunSize] = c;
            this.mnAccentRunSize = newSize;
        }
    }

    void processObject(TextEmbed poEmbed, TextPosnBase poPosition) {
        this.syncPosition(poPosition);
        this.addEmbed(poEmbed);
    }

    void processPara(TextPosnBase poPosition) {
        this.syncPosition(poPosition);
        this.addChar(32, TextCharProp.defaultSpace);
        this.mpoPendingAttr = null;
        this.moFormatInfo.setNewPara(true);
    }

    void processStreamStart(TextPosnBase oPosition) {
        this.processStreamChange(oPosition);
    }

    void processStreamEnd(TextPosnBase oPosition) {
        this.processStreamChange(oPosition);
    }

    void finish(boolean bIsLastParaLine, boolean bIsLastLineInStream) {
        this.flushAccentRun();
        this.moAnchor.flush();
        this.moRun.flush();
        if (bIsLastParaLine) {
            this.mpoLine.setLastParaLine(3);
        } else {
            this.mpoLine.setLastParaLine(2);
        }
        this.mpoLine.setLastLineInStream(bIsLastLineInStream);
        this.mpoLine.setVisualCharCount(this.mnVisualCharCount);
        if (this.mbHasAmbiguousBreaks) {
            int eDefault = this.mpoLine.display().isIdeographic() ? 15 : 1;
            int ePrev = 0;
            int eNext = 0;
            int nNextKnown = 0;
            for (int i = 0; i < this.mpoLine.getCharCount(); ++i) {
                int nData = this.mpoLine.getBreakData(i);
                int eBreak = TextCharProp.getBreakClass(nData);
                int eWidth = TextCharProp.getWidthClass(nData);
                if (eBreak == 0) {
                    eBreak = TextCharProp.resolveBreakWidth(eWidth, eWidth);
                }
                if (eBreak == 0) {
                    if (nNextKnown <= i) {
                        eNext = 0;
                        for (nNextKnown = i + 1; eNext == 0 && nNextKnown < this.mpoLine.getCharCount(); ++nNextKnown) {
                            int eNextWidth = this.mpoLine.getWidthClass(nNextKnown);
                            if (TextCharProp.isAmbiguousWidth(eNextWidth)) continue;
                            eNext = eWidth;
                            break;
                        }
                    }
                    eBreak = TextCharProp.resolveBreakWidth(ePrev, eNext, eDefault);
                    this.mpoLine.setBreak(i, TextCharProp.setBreakClass(nData, eBreak));
                    if (eBreak == 15) {
                        ePrev = 320;
                        continue;
                    }
                    ePrev = 192;
                    continue;
                }
                if (TextCharProp.isAmbiguousWidth(eWidth)) continue;
                ePrev = eWidth;
            }
        }
    }

    private void processStreamChange(TextPosnBase oPosition) {
        this.flushAccentRun();
        this.moAnchor.reset(new DispPosn(oPosition), true);
        TextAttr poAttr = this.moAnchor.pp().attributePtr();
        if (poAttr == null || poAttr.fontInstance() == null) {
            TextAttr poRunAttr = this.moRun.r().getAttr();
            if (poRunAttr == null) {
                poRunAttr = poAttr;
            }
            assert (poRunAttr != null);
            TextAttr poNewAttr = new TextAttr(true);
            poNewAttr.fontService(poRunAttr.fontService());
            poNewAttr.override(poRunAttr);
            poAttr = poNewAttr;
        }
        this.moFormatInfo.setAttr(poAttr);
        this.moRun.reset(new DispRun(this.moRun.r(), this.moFormatInfo.getAttr()));
        this.mpoPendingAttr = null;
    }

    private void syncPosition(TextPosnBase poPosition) {
        this.flushAccentRun();
        if (poPosition != null && (this.moAnchor.pp().stream() != poPosition.stream() || this.moAnchor.pp().index() + this.moAnchor.length() != poPosition.index())) {
            this.moAnchor.reset(new DispPosn(poPosition));
        }
    }

    private DispEmbed addEmbed(TextEmbed poEmbed, int cInsert, int eBreak) {
        this.moRun.flush();
        int nCharsBefore = this.mpoLine.getCharCount();
        if (cInsert == 9) {
            assert (this.mnAccentRunSize == 0);
            if (this.moAccentRun == null || this.moAccentRun.length < 1) {
                this.moAccentRun = this.mpoLine.display().getContext().getAccentRun(1);
            }
            this.moAccentRun[0] = cInsert;
            this.mnAccentRunSize = 1;
            this.resolveAccentRunFont();
            this.mnAccentRunSize = 0;
        }
        this.addChar(cInsert, eBreak);
        DispEmbed oDispEmbed = new DispEmbed(poEmbed);
        this.mpoLine.add(oDispEmbed, nCharsBefore);
        this.moRun.flush();
        return oDispEmbed;
    }

    private DispEmbed addEmbed(TextEmbed poEmbed) {
        return this.addEmbed(poEmbed, 65532, TextCharProp.defaultObject);
    }

    private void flushAccentRun() {
        if (this.mnAccentRunSize == 0) {
            return;
        }
        int nComposed = this.resolveAccentRunFont();
        int c = this.moAccentRun[0];
        boolean bIsArabic = false;
        boolean bIsThai = false;
        if (c >= 1536 && c <= 1871 || c >= 1920 && c <= 1983 || c >= 64336 && c <= 65023 || c >= 65136 && c <= 65279) {
            bIsArabic = true;
        } else if (c >= 3584 && c <= 3711) {
            bIsThai = true;
        }
        if (this.mpoLine.getCombCells() > 0) {
            if (bIsArabic) {
                DispRun oNewRun = new DispRun(this.moRun.r());
                oNewRun.setComb(true);
                this.moRun.reset(oNewRun);
            }
        } else {
            boolean bAllowLigatures = bIsArabic;
            boolean bAllowKerning = bIsThai;
            TextAttr poAttr = this.moRun.r().getAttr();
            if (poAttr != null) {
                if (poAttr.ligatureEnable() && poAttr.ligature() == 1) {
                    bAllowLigatures = true;
                }
                if (poAttr.kerningEnable() && poAttr.kerning()) {
                    bAllowKerning = true;
                }
            }
            if (bAllowLigatures != this.moRun.r().allowLigatures() || bAllowKerning != this.moRun.r().allowKerning()) {
                DispRun oNewRun = new DispRun(this.moRun.r());
                oNewRun.setAllowLigatures(bAllowLigatures);
                oNewRun.setAllowKerning(bAllowKerning);
                this.moRun.reset(oNewRun);
            }
        }
        if (nComposed > 1) {
            DispPosn p = this.moAnchor.p();
            TextPosn pp = p.pp();
            int nAnchorStreamCount = p.getStreamCount() == 0 ? this.moAnchor.length() : p.getStreamCount();
            DispPosn oNewPosn = new DispPosn(pp.stream(), pp.index() + nAnchorStreamCount, pp.position());
            oNewPosn.setStreamCount(nComposed);
            this.moAnchor.reset(oNewPosn);
        }
        this.addChar(c, this.meAccentRunBreak);
        int eClass = TextCharProp.getBreakClass(this.meAccentRunBreak);
        if (eClass != 31) {
            if (eClass == 0) {
                this.mbHasAmbiguousBreaks = true;
            }
            this.mnVisualCharCount = this.mpoLine.getCharCount();
        }
        for (int nAccentIndex = 1; nAccentIndex < this.mnAccentRunSize; ++nAccentIndex) {
            int cAccent = this.moAccentRun[nAccentIndex];
            if (cAccent != 0) {
                this.addChar(cAccent, TextCharProp.getCharProperty(cAccent));
            }
            this.mnVisualCharCount = this.mpoLine.getCharCount();
        }
        this.mnAccentRunSize = 0;
        this.moFormatInfo.setNewPara(false);
    }

    private int resolveAccentRunFont() {
        int nComposed = 1;
        int c = this.substituteInvisibleCharacter(this.moAccentRun[0]);
        if (c != this.moAccentRun[0]) {
            this.moAccentRun[0] = c;
            this.meAccentRunBreak = TextCharProp.getCharProperty(c);
        }
        if (c == 8203 || c == 8204 || c == 8205 || c == 65279 || c == 65532) {
            return 1;
        }
        if (c == 9) {
            c = 32;
        }
        ValidationData validation = new ValidationData();
        int nSplit = 1;
        TextAttr poAttr = this.moRun.r().getAttr();
        boolean bInvisible = false;
        if (poAttr != null && poAttr.invisibleEnable() && poAttr.invisible()) {
            bInvisible = true;
        }
        if (this.mnAccentRunSize == 1 || bInvisible) {
            this.validateBaseChar(c, validation);
            if (validation.fontInstance == null) {
                return 1;
            }
        } else {
            Composition oComposition = new Composition(this.moAccentRun);
            oComposition.reconcile();
            while (true) {
                c = oComposition.getPrecomposedChar();
                this.validateBaseChar(c, validation);
                if (validation.fontInstance == null) break;
                if (oComposition.getSplit() == 1) {
                    return 1;
                }
                oComposition.popCombiningMark();
            }
            nSplit = oComposition.getSplit();
            if (oComposition.doComposition()) {
                assert (nSplit > 1);
                nComposed = nSplit;
                for (int i = 1; i < nSplit; ++i) {
                    this.moAccentRun[i] = this.moAccentRun[nSplit + i - 1];
                }
                this.mnAccentRunSize -= nSplit - 1;
                this.moAccentRun[0] = c;
                this.meAccentRunBreak = TextCharProp.getCharProperty(c);
                nSplit = 1;
            }
        }
        for (int nAccentIndex = nSplit; nAccentIndex < this.mnAccentRunSize; ++nAccentIndex) {
            FontInstance oTestInstance;
            int cAccent;
            this.moAccentRun[nAccentIndex] = cAccent = this.substituteInvisibleCharacter(this.moAccentRun[nAccentIndex]);
            if (cAccent == 0 || this.validateChar(validation.fontInstance, cAccent) || (oTestInstance = this.reconcileFont(validation.fontInstance, cAccent)) == null || oTestInstance == validation.fontInstance) continue;
            int i = 0;
            if (this.validateChar(oTestInstance, c)) {
                for (i = nSplit; i < nAccentIndex && this.validateChar(oTestInstance, this.moAccentRun[i]); ++i) {
                }
            }
            if (i < nAccentIndex) continue;
            validation.fontInstance = oTestInstance;
            validation.replaceFont = true;
        }
        if (validation.replaceFont) {
            FontItem poOriginalItem;
            TextAttr poOverrideAttr = new TextAttr(validation.originalAttr);
            boolean bSubstitute = false;
            FontItem poFontItem = validation.fontInstance.getFontItem();
            if (!poFontItem.equals(poOriginalItem = validation.originalFontInstance.getFontItem())) {
                bSubstitute = true;
            }
            poOverrideAttr.fontInstance(validation.fontInstance, poOriginalItem.getTypeface());
            if (bSubstitute) {
                this.mpoLine.display().setFontSubstitution(true);
            }
            this.mpoPendingAttr = validation.originalAttr;
            DispRun oNewRun = new DispRun(this.moRun.r(), poOverrideAttr);
            this.moRun.reset(oNewRun);
        }
        return nComposed;
    }

    private void validateBaseChar(int c, ValidationData validation) {
        TextAttr poAttr;
        boolean bValidated = false;
        if (this.mpoPendingAttr == null) {
            validation.originalAttr = this.moRun.r().getAttr();
        } else {
            validation.originalAttr = this.mpoPendingAttr;
            if (this.validateChar(this.mpoPendingAttr.fontInstance(), c)) {
                DispRun oNewRun = new DispRun(this.moRun.r(), this.mpoPendingAttr);
                this.moRun.reset(oNewRun);
                this.mpoPendingAttr = null;
                bValidated = true;
            }
        }
        if (!bValidated) {
            poAttr = this.moRun.r().getAttr();
            if (poAttr == null) {
                poAttr = validation.originalAttr;
            }
            if (poAttr != null) {
                bValidated = this.validateChar(poAttr.fontInstance(), c);
            }
        }
        if (bValidated) {
            poAttr = this.moRun.r().getAttr();
            if (poAttr != null) {
                validation.fontInstance = validation.originalFontInstance = poAttr.fontInstance();
            }
        } else {
            assert (validation.originalAttr != null);
            validation.originalFontInstance = validation.originalAttr.fontInstance();
            validation.fontInstance = this.reconcileFont(validation.originalFontInstance, c);
            validation.replaceFont = true;
        }
    }

    private boolean validateChar(FontInstance oFontInstance, int c) {
        FontItem poFontItem;
        return oFontInstance != null && (poFontItem = oFontInstance.getFontItem()) != null && poFontItem.validateChar(c, GFXGlyphOrientation.usesHorizontalGlyphs(this.meGlyphOrientation));
    }

    private FontInstance reconcileFont(FontInstance oFontInstance, int c) {
        TextAttr poAttr = this.moRun.r().getAttr();
        if (poAttr == null) {
            return null;
        }
        return poAttr.gfxSource().reconcileFont(oFontInstance, c);
    }

    private int substituteInvisibleCharacter(int c) {
        TextAttr poAttr = this.moRun.r().getAttr();
        if (poAttr != null && poAttr.invisibleEnable() && poAttr.invisible() && poAttr.invisCharEnable() && poAttr.invisChar() != '\u0000') {
            c = poAttr.invisChar();
        }
        return c;
    }

    private void addChar(int c, int eBreak) {
        this.mpoLine.addChar(c, eBreak);
    }

    private static boolean charIsRomanRotateable(int character) {
        return character >= 65 && character < 90 || character >= 97 && character < 122 || character >= 64256 && character < 64263 || character >= 65377 && character <= 65439;
    }

    private static int figureVerticalOrientationsFromChar(int c) {
        return RawProcessor.charIsRomanRotateable(c) ? 2 : 1;
    }

    private static class ValidationData {
        TextAttr originalAttr;
        FontInstance originalFontInstance;
        FontInstance fontInstance;
        boolean replaceFont;

        private ValidationData() {
        }
    }
}

