/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.FrameLineInfo;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextSparseStream;

abstract class FrameHelper
extends FrameLineInfo {
    static final int PROCESS_LOADED_FRAMES = 0;
    static final int PROCESS_NULL_FRAMES = 1;
    static final int PROCESS_FORCE_LOAD = 2;
    private final int meProcess;
    private TextFrame mpoFrame;
    private boolean mbFrameLocked;

    FrameHelper(TextSparseStream poStream, int eProcess) {
        super(poStream);
        this.meProcess = eProcess;
    }

    FrameHelper(TextSparseStream poStream) {
        this(poStream, 0);
    }

    boolean processFrames() {
        int nFrameLimit;
        int nFrame;
        if (this.mbFrameLocked) {
            nFrame = this.getFrameIndex();
            nFrameLimit = nFrame + 1;
        } else {
            nFrame = 0;
            nFrameLimit = this.getStream().getFrameCount();
        }
        while (nFrame < nFrameLimit) {
            this.setFrameIndex(nFrame);
            int nAbsLineIndex = this.getAbsLineIndex();
            this.mpoFrame = this.getStream().getFrame(nFrame);
            boolean bSkipFrame = false;
            if (this.mpoFrame == null) {
                switch (this.meProcess) {
                    case 0: {
                        bSkipFrame = true;
                        break;
                    }
                    case 2: {
                        if (this.getStream().isAutoLoadSuppressed()) {
                            bSkipFrame = true;
                            break;
                        }
                        this.mpoFrame = this.getStream().forceFrame(nFrame);
                    }
                }
            }
            if (!bSkipFrame && !this.processOneFrame(this.mpoFrame)) {
                return false;
            }
            if (this.mpoFrame != null) {
                this.setAbsLineIndex(nAbsLineIndex + this.mpoFrame.getLineCount());
                this.setOffset(this.getOffset().add(this.mpoFrame.getBMax()));
            }
            ++nFrame;
        }
        this.mpoFrame = null;
        return this.finish();
    }

    TextFrame getFrame() {
        return this.getStream().getFrame(this.getFrameIndex());
    }

    DispLineWrapped getLine() {
        TextFrame poFrame = this.getFrame();
        if (poFrame == null) {
            return null;
        }
        if (this.getLineIndex() >= poFrame.getLineCount()) {
            return null;
        }
        return poFrame.getLine(this.getLineIndex());
    }

    boolean isFrameLocked() {
        return this.mbFrameLocked;
    }

    void lockFrame(TextFrame poFrame) {
        boolean bFound;
        FrameFinder oFinder = new FrameFinder(this.getStream(), poFrame);
        boolean bl = bFound = !oFinder.processFrames();
        assert (bFound);
        super.copyFrom(oFinder);
    }

    protected void setFrame(TextFrame poFrame) {
        this.mpoFrame = poFrame;
    }

    protected abstract boolean processOneFrame(TextFrame var1);

    protected boolean finish() {
        return true;
    }

    private static class FrameFinder
    extends FrameHelper {
        private final TextFrame mpoSearchFrame;

        FrameFinder(TextSparseStream poStream, TextFrame poSearchFrame) {
            super(poStream);
            this.mpoSearchFrame = poSearchFrame;
        }

        @Override
        protected boolean processOneFrame(TextFrame poFrame) {
            return poFrame != this.mpoSearchFrame;
        }
    }
}

