/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextStream;

class DispChange {
    static final int CHANGE_NONE = 0;
    static final int CHANGE_INSERT = 1;
    static final int CHANGE_DELETE = 2;
    static final int CHANGE_FRAME = 3;
    static final int CHANGE_OTHER = 4;
    static final int CHANGE_TO_END = 5;
    static final int CHANGE_FULL = 6;
    static final int CHANGE_FULL_FORCE_FRAMES = 7;
    private TextStream mpoStream;
    private int mnIndex;
    private int mnCount;
    private int meType;
    private boolean mbJustify;

    DispChange() {
        this.reset();
    }

    final int type() {
        return this.meType;
    }

    final TextStream stream() {
        return this.mpoStream;
    }

    final int index() {
        return this.mnIndex;
    }

    final int count() {
        return this.mnCount;
    }

    final boolean justify() {
        return this.mbJustify;
    }

    final void insert(TextStream poStream, int nIndex, int nCount) {
        this.simpleChange(1, poStream, nIndex, nCount);
    }

    final void delete(TextStream poStream, int nIndex, int nCount) {
        this.simpleChange(2, poStream, nIndex, nCount);
    }

    final void frame(TextStream poStream, int nIndex, int nCount) {
        this.simpleChange(3, poStream, nIndex, nCount);
    }

    final void other(TextStream poStream, int nIndex, int nCount) {
        if (this.meType == 0) {
            this.meType = 4;
            this.mpoStream = poStream;
            this.mnIndex = nIndex;
            this.mnCount = nCount;
        } else if (this.meType != 6 && this.meType != 5 && poStream == this.mpoStream) {
            this.meType = 4;
            int nOldEnd = this.mnIndex + this.mnCount;
            int nNewEnd = nIndex + nCount;
            if (nIndex < this.mnIndex) {
                this.mnIndex = nIndex;
            }
            if (nNewEnd < nOldEnd) {
                nNewEnd = nOldEnd;
            }
            this.mnCount = nNewEnd - this.mnIndex;
        } else {
            this.Full(this.meType == 5);
        }
    }

    final void other(TextStream poStream, int nIndex) {
        this.other(poStream, nIndex, 0);
    }

    final void toEnd(TextStream poStream, int nIndex) {
        if (this.meType != 0) {
            this.other(poStream, nIndex);
        } else if (this.meType == 5) {
            if (poStream == this.mpoStream) {
                if (nIndex < this.mnIndex) {
                    this.mnIndex = nIndex;
                }
            } else {
                this.Full(true);
            }
        } else {
            this.meType = 5;
            this.mpoStream = poStream;
            this.mnIndex = nIndex;
            this.mnCount = 0;
        }
    }

    final void setJustify() {
        this.mbJustify = true;
    }

    final void Full(boolean bForceAllFrames) {
        this.meType = bForceAllFrames ? 7 : 6;
    }

    final void full() {
        this.Full(false);
    }

    final void reset() {
        this.meType = 0;
        this.mpoStream = null;
        this.mnIndex = 0;
        this.mnCount = 0;
        this.mbJustify = false;
    }

    private final void simpleChange(int eType, TextStream poStream, int nIndex, int nCount) {
        if (this.meType != 0) {
            this.other(poStream, nIndex);
        } else {
            this.meType = eType;
            this.mpoStream = poStream;
            this.mnIndex = nIndex;
            this.mnCount = nCount;
        }
    }
}

