/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.formatting.Fill;

public final class Color
extends ProtoableNode {
    private int mnRGB = -1;
    private final StringAttr mWhite = new StringAttr(null, null, "value", "255,255,255", false);

    public static String toString(int nRed, int nGreen, int nBlue, char cDelimiter) {
        if (nRed > 255) {
            nRed = 255;
        }
        if (nRed < 0) {
            nRed = 0;
        }
        if (nGreen > 255) {
            nGreen = 255;
        }
        if (nGreen < 0) {
            nGreen = 0;
        }
        if (nBlue > 255) {
            nBlue = 255;
        }
        if (nBlue < 0) {
            nBlue = 0;
        }
        return Integer.toString(nRed) + cDelimiter + Integer.toString(nGreen) + cDelimiter + Integer.toString(nBlue);
    }

    public Color(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "color", "color", null, XFA.COLORTAG, "color");
    }

    @Override
    public Attribute defaultAttribute(int eTag) {
        if (eTag == XFA.VALUETAG && this.getXFAParent() instanceof Fill && (this.getXFAParent().getXFAParent() == null || this.getXFAParent().getXFAParent().getClassTag() != XFA.FONTTAG)) {
            return this.mWhite;
        }
        return super.defaultAttribute(eTag);
    }

    @Override
    public boolean isContextSensitiveAttribute(int eTag) {
        return eTag == XFA.VALUETAG || super.isContextSensitiveAttribute(eTag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Color oColor = (Color)object;
        return this.getRed() == oColor.getRed() && this.getGreen() == oColor.getGreen() && this.getBlue() == oColor.getBlue();
    }

    public int hashCode() {
        return this.mnRGB;
    }

    public int getBlue() {
        if (this.mnRGB < 0) {
            String sColor = this.getAttribute(XFA.VALUETAG).getAttrValue();
            this.setFromString(sColor);
        }
        return this.mnRGB & 0xFF;
    }

    public double getGrayRate() {
        int nGrayScaleValue = this.getGrayScale();
        return (double)(255 - nGrayScaleValue) / 2.55;
    }

    public int getGrayScale() {
        if (this.mnRGB < 0) {
            String sColor = this.getAttribute(XFA.VALUETAG).getAttrValue();
            this.setFromString(sColor);
        }
        int nRed = this.getRed();
        int nGreen = this.getGreen();
        int nBlue = this.getBlue();
        return (nRed * 30 + nGreen * 59 + nBlue * 11) / 100;
    }

    public int getGreen() {
        if (this.mnRGB < 0) {
            String sColor = this.getAttribute(XFA.VALUETAG).getAttrValue();
            this.setFromString(sColor);
        }
        return (this.mnRGB & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.mnRGB < 0) {
            String sColor = this.getAttribute(XFA.VALUETAG).getAttrValue();
            this.setFromString(sColor);
        }
        return (this.mnRGB & 0xFF0000) >> 16;
    }

    @Override
    public Attribute newAttribute(int eTag, String value) {
        if (eTag == XFA.VALUETAG && value.length() == 0) {
            return this.defaultAttribute(eTag);
        }
        return super.newAttribute(eTag, value);
    }

    @Override
    public void setAttribute(Attribute sValue, int eTag) {
        if (eTag == XFA.VALUETAG) {
            this.mnRGB = -1;
        }
        super.setAttribute(sValue, eTag);
    }

    public void setBlue(int nBlue) {
        this.setBlueInternal(nBlue);
        String sColor = this.toString(',');
        super.setAttribute(new StringAttr("value", sColor), XFA.VALUETAG);
    }

    public void setBlueInternal(int nBlue) {
        this.mnRGB = this.mnRGB < 0 ? 0 : (this.mnRGB &= 0xFFFF00);
        this.mnRGB |= nBlue;
    }

    public void setColor(int nRed, int nGreen, int nBlue) {
        if (nRed == 0 && nGreen == 0 && nBlue == 0) {
            this.mnRGB = 0;
        } else {
            this.setRedInternal(nRed);
            this.setGreenInternal(nGreen);
            this.setBlueInternal(nBlue);
        }
        String sColor = this.toString(',');
        super.setAttribute(new StringAttr("value", sColor), XFA.VALUETAG);
    }

    public void setColor(String sColor) {
        this.setFromString(sColor);
        String sCol = this.toString(',');
        super.setAttribute(new StringAttr("value", sCol), XFA.VALUETAG);
    }

    private void setFromString(String sColor) {
        if (sColor.equals("255,255,255")) {
            this.mnRGB = 0xFFFFFF;
        } else if (!sColor.equals("0,0,0")) {
            int offset = this.collectColor(3, sColor, sColor.length() - 1);
            offset = this.collectColor(2, sColor, offset);
            this.collectColor(1, sColor, offset);
        }
    }

    private int collectColor(int rgb, String sColor, int offset) {
        char c;
        boolean c1 = false;
        boolean c2 = false;
        boolean c3 = false;
        int value256 = 0;
        while (offset >= 0 && (c = sColor.charAt(offset)) != ',') {
            if (c >= '0' && c <= '9') {
                int val = c - 48;
                if (!c3) {
                    c3 = true;
                    value256 = val;
                } else if (!c2) {
                    c2 = true;
                    value256 += val * 10;
                } else if (!c1) {
                    c1 = true;
                    value256 += val * 100;
                }
            }
            --offset;
        }
        if (rgb == 1) {
            this.setRedInternal(value256);
        } else if (rgb == 2) {
            this.setGreenInternal(value256);
        } else if (rgb == 3) {
            this.setBlueInternal(value256);
        }
        return --offset;
    }

    public void setGreen(int nGreen) {
        this.setGreenInternal(nGreen);
        String sColor = this.toString(',');
        super.setAttribute(new StringAttr("value", sColor), XFA.VALUETAG);
    }

    public void setGreenInternal(int nGreen) {
        this.mnRGB = this.mnRGB < 0 ? 0 : (this.mnRGB &= 0xFF00FF);
        this.mnRGB |= nGreen << 8;
    }

    public void setRed(int nRed) {
        this.setRedInternal(nRed);
        String sColor = this.toString(',');
        super.setAttribute(new StringAttr("value", sColor), XFA.VALUETAG);
    }

    public void setRedInternal(int nRed) {
        this.mnRGB = this.mnRGB < 0 ? 0 : (this.mnRGB &= 0xFFFF);
        this.mnRGB |= nRed << 16;
    }

    public String toString(char cDelimiter) {
        return Color.toString(this.getRed(), this.getGreen(), this.getBlue(), cDelimiter);
    }
}

