/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.scripthandler.rhino;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.scripthandler.rhino.LiveComponent;
import com.adobe.xfa.scripthandler.rhino.LiveObject;
import com.adobe.xfa.scripthandler.rhino.RhinoEngine;
import com.adobe.xfa.scripthandler.rhino.ScriptHandlerIF;
import com.adobe.xfa.scripthandler.rhino.ScriptObject;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import java.util.IdentityHashMap;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class RhinoScriptHandler
extends ScriptHandler
implements ScriptHandlerIF {
    public static final String INPTERPRET_SCRIPT = "interpretScript";
    private boolean interpretScript = false;
    private final RhinoScriptHandler mScriptHost;
    private final AppModel mAppModel;
    private final LiveObject mAppModelLiveObject;
    private Exception mError;
    private int mJavaScriptTimeout;
    private final IdentityHashMap<Obj, LiveObject> mObjectMap;

    protected RhinoScriptHandler() {
        this.mScriptHost = this;
        this.mAppModel = null;
        this.mAppModelLiveObject = null;
        this.mObjectMap = new IdentityHashMap();
    }

    public RhinoScriptHandler(AppModel appModel) {
        this(appModel, null);
    }

    public RhinoScriptHandler(AppModel appModel, ScriptDebugger scriptDebugger) {
        this(appModel, null, 0);
    }

    public RhinoScriptHandler(AppModel appModel, ScriptDebugger scriptDebugger, int javaScriptTimeout) {
        super(scriptDebugger);
        this.mAppModel = appModel;
        this.mScriptHost = this;
        this.mJavaScriptTimeout = javaScriptTimeout;
        if (this.mJavaScriptTimeout < 0) {
            this.mJavaScriptTimeout = 0;
        }
        LiveComponent oLiveComponent = this.mScriptHost.newLiveComponent(this, this.mAppModel);
        RhinoEngine.setTopLevelScope(oLiveComponent);
        this.mAppModelLiveObject = this.mScriptHost.newLiveObject(this, this.mAppModel);
        this.mObjectMap = new IdentityHashMap();
    }

    protected RhinoScriptHandler(AppModel appModel, RhinoScriptHandler scriptHost, LiveObject liveObject, ScriptDebugger scriptDebugger, IdentityHashMap<Obj, LiveObject> objectMap) {
        this(appModel, scriptHost, liveObject, scriptDebugger, 0, objectMap);
    }

    protected RhinoScriptHandler(AppModel appModel, RhinoScriptHandler scriptHost, LiveObject liveObject, ScriptDebugger scriptDebugger, int javaScriptTimeout, IdentityHashMap<Obj, LiveObject> objectMap) {
        super(scriptDebugger);
        this.mAppModel = appModel;
        this.mScriptHost = scriptHost;
        this.mJavaScriptTimeout = javaScriptTimeout;
        if (this.mJavaScriptTimeout < 0) {
            this.mJavaScriptTimeout = 0;
        }
        this.mAppModelLiveObject = liveObject;
        this.mObjectMap = objectMap;
    }

    @Override
    public RhinoScriptHandler clone() {
        RhinoScriptHandler oNewScriptHandler = new RhinoScriptHandler(this.mAppModel, this.mScriptHost, this.mAppModelLiveObject, this.getDebugger(), this.mObjectMap);
        oNewScriptHandler.mError = this.mError;
        oNewScriptHandler.interpretScript = this.interpretScript;
        return oNewScriptHandler;
    }

    @Override
    public LiveObject newLiveObject(RhinoScriptHandler handler, Obj xfaObject) {
        return new LiveObject(handler, xfaObject);
    }

    @Override
    public LiveComponent newLiveComponent(RhinoScriptHandler handler, Obj xfaObject) {
        return new LiveComponent(handler, xfaObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void executeOrSyntaxCheck(String sScript, Arg oReturnCode, int eReason, boolean bSyntaxCheckOnly, String locale) {
        this.clearError();
        nScriptID = -1;
        oDebugger = this.getDebugger();
        if (oDebugger != null) if (!RhinoScriptHandler.$assertionsDisabled) {
            throw new AssertionError();
        }
        oScriptID = "";
        if (oDebugger != null) {
            oScriptID = "#" + nScriptID;
        }
        bSuccess = false;
        if (this.interpretScript && !bSyntaxCheckOnly) {
            ctx = RhinoEngine.getThreadLocalRuntimeContext();
            nLevel = ctx.getOptimizationLevel();
            try {
                ctx.setOptimizationLevel(-1);
                topScope = RhinoEngine.getTopLevelScope();
                oResult = ctx.evaluateString(topScope, sScript, oScriptID, 0, null);
                if (oResult instanceof Undefined) ** GOTO lbl56
                oReturnCode.assign(this.variantToArg(oResult));
                bSuccess = true;
            }
            catch (RhinoException f) {
                this.setError(f);
            }
            catch (ExFull g) {
                this.setError(g);
            }
            finally {
                ctx.setOptimizationLevel(nLevel);
            }
        } else {
            oScript = null;
            try {
                oScript = RhinoEngine.getThreadLocalRuntimeContext().compileString(sScript, oScriptID, 1, null);
            }
            catch (RhinoException oError) {
                this.setError(oError);
            }
            v0 = bSuccess = oScript != null;
            if (oScript != null && !bSyntaxCheckOnly) {
                if (oDebugger != null) {
                    if (!RhinoScriptHandler.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    bSuccess = false;
                    try {
                        ctx = RhinoEngine.getThreadLocalRuntimeContext();
                        topScope = RhinoEngine.getTopLevelScope();
                        oResult = oScript.exec(ctx, topScope);
                        if (!(oResult instanceof Undefined)) {
                            oReturnCode.assign(this.variantToArg(oResult));
                            bSuccess = true;
                        }
                    }
                    catch (RhinoException f) {
                        this.setError(f);
                    }
                    catch (ExFull g) {
                        this.setError(g);
                    }
                }
            }
        }
lbl56:
        // 10 sources

        if (!bSuccess) {
            error = this.getError();
            sErrorText = null;
            if (error instanceof JavaScriptException) {
                sError = new StringBuilder(((JavaScriptException)error).getMessage());
                sErrorText = sError.toString();
            } else if (error instanceof WrappedException) {
                sError = new StringBuilder(((WrappedException)error).getMessage());
                sRhinoPrefix = "Wrapped ";
                nErrorPrefix = sError.indexOf("Wrapped ");
                if (nErrorPrefix >= 0) {
                    sError.replace(0, nErrorPrefix + "Wrapped ".length(), "");
                }
                sRhinoSuffix = "\n (#";
                nLineNumberSuffix = sError.indexOf("\n (#");
                if (nLineNumberSuffix >= 0) {
                    sError.delete(nLineNumberSuffix + 1, sError.length());
                }
                if (sError.charAt(sError.length() - 1) == '\n') {
                    sError.setLength(sError.length() - 1);
                }
                sErrorText = sError.toString();
            } else if (error instanceof RhinoException) {
                sError = new StringBuilder(((RhinoException)error).getMessage());
                sRhinoPrefix = "Error: ";
                nErrorPrefix = sError.indexOf("Error: ");
                if (nErrorPrefix >= 0) {
                    sError.delete(0, nErrorPrefix + "Error: ".length());
                }
                nErrorLine = ((RhinoException)error).lineNumber();
                if (this.interpretScript && !bSyntaxCheckOnly && (lineNumberIndex = sError.indexOf(searchString = "#" + String.valueOf(nErrorLine))) >= 0) {
                    sError.replace(lineNumberIndex, lineNumberIndex + searchString.length(), "#" + String.valueOf(nErrorLine + 1));
                }
                sErrorText = sError.toString();
                if (bSyntaxCheckOnly) {
                    oFmt = new MsgFormat(ResId.ScriptHandlerError, sErrorText);
                    oScriptEx = new ScriptHandler.ScriptException(oFmt, nErrorLine, RhinoScriptHandler.RhinoErrorIdToErrorCode(0));
                    throw oScriptEx;
                }
            } else if (error instanceof ExFull) {
                sErrorText = error.toString();
            }
            if (sErrorText != null) {
                arg = this.variantToArg(sErrorText);
                oReturnCode.assign(arg);
                throw new ExFull(new MsgFormat(ResId.ScriptHandlerError, sErrorText));
            }
        }
        if (bSyntaxCheckOnly) {
            return;
        }
        if (oDebugger != null) if (!RhinoScriptHandler.$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public AppModel getAppModel() {
        return this.mAppModel;
    }

    protected RhinoScriptHandler getScriptHost() {
        return this.mScriptHost;
    }

    protected IdentityHashMap<Obj, LiveObject> getObjectMap() {
        return this.mObjectMap;
    }

    protected LiveObject getAppModelLiveObject() {
        return this.mAppModelLiveObject;
    }

    @Override
    public String languageName() {
        return "javascript";
    }

    public void throwError(ExFull oError) {
        StringBuilder sErrorBuf = new StringBuilder(oError.toString());
        int nLen = sErrorBuf.length();
        while (sErrorBuf.charAt(nLen - 1) == '\n') {
            --nLen;
        }
        sErrorBuf.setLength(nLen);
        RhinoEngine.throwException(sErrorBuf.toString());
    }

    @Override
    public boolean wasFatalError() {
        return false;
    }

    @Override
    protected void clearExecutionContexts() {
        this.mObjectMap.clear();
        RhinoEngine.destroy();
    }

    void clearError() {
        this.setError(null);
    }

    Exception getError() {
        return this.mError;
    }

    void setError(Exception error) {
        this.mError = error;
    }

    LiveObject ObjectToLiveObject(Obj object) {
        LiveObject liveObject = this.lookupObject(object);
        if (liveObject == null) {
            liveObject = this.mScriptHost.newLiveObject(this, object);
            this.addObject(object, liveObject);
        }
        return liveObject;
    }

    LiveObject lookupObject(Obj object) {
        if (object == this.mAppModel) {
            return this.mAppModelLiveObject;
        }
        return this.mObjectMap.get(object);
    }

    void addObject(Obj object, LiveObject liveObject) {
        TextNode oText;
        Element oNode;
        Element oParent;
        assert (object != this.mAppModel);
        this.mObjectMap.put(object, liveObject);
        if (object.isSameClass(XFA.SCRIPTTAG) && (oParent = (oNode = (Element)object).getXFAParent()) != null && oParent.isSameClass(XFA.VARIABLESTAG) && (oText = (TextNode)oNode.getProperty(XFA.TEXTNODETAG, 0)) != null) {
            String sScript = oText.getValue();
            this.compileObject(object, sScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compileObject(Obj object, String sScript) {
        this.clearError();
        Script oScript = null;
        Context ctx = RhinoEngine.getThreadLocalRuntimeContext();
        int nLevel = ctx.getOptimizationLevel();
        try {
            ctx.setOptimizationLevel(-1);
            oScript = ctx.compileString(sScript, null, 1, null);
        }
        catch (RhinoException oError) {
            this.setError(oError);
        }
        finally {
            ctx.setOptimizationLevel(nLevel);
        }
        boolean bSuccess = oScript != null;
        boolean bRet = false;
        if (!bSuccess) {
            String sError = "";
            Exception error = this.getError();
            if (error instanceof RhinoException) {
                sError = ((RhinoException)error).getMessage();
            }
            throw new ExFull(new MsgFormat(ResId.ScriptHandlerError, sError));
        }
        LiveObject liveObject = this.lookupObject(object);
        ScriptObject oScriptObj = new ScriptObject(oScript);
        liveObject.setScriptObject(oScriptObj);
        bRet = true;
        return bRet;
    }

    public Object argToVariant(Arg arg) {
        Object variant = null;
        switch (arg.getArgType()) {
            case 1: {
                variant = Undefined.instance;
                break;
            }
            case 2: {
                variant = null;
                break;
            }
            case 3: {
                variant = (boolean)arg.getBool();
                break;
            }
            case 4: {
                variant = (int)arg.getInteger();
                break;
            }
            case 5: {
                variant = new Double(arg.getDouble(false));
                break;
            }
            case 6: {
                variant = arg.getString();
                break;
            }
            case 7: {
                Obj oObj = arg.getObject();
                if (oObj == null) {
                    variant = null;
                    break;
                }
                LiveObject oXFALiveObject = this.ObjectToLiveObject(oObj);
                variant = oXFALiveObject;
                break;
            }
            case 8: {
                throw new EvaluatorException(arg.getException().toString());
            }
            default: {
                assert (false);
                break;
            }
        }
        return variant;
    }

    public Arg variantToArg(Object variant) {
        Arg arg = new Arg();
        if (variant == null) {
            arg.setNull();
        } else if (variant instanceof Undefined) {
            arg.empty();
        } else if (variant instanceof Boolean) {
            arg.setBool((boolean)((Boolean)variant));
        } else if (variant instanceof Integer) {
            arg.setInteger((int)((Integer)variant));
        } else if (variant instanceof Double) {
            arg.setDouble(new Double((Double)variant));
        } else if (variant instanceof String) {
            arg.setString((String)variant);
        } else if (variant instanceof ConsString) {
            arg.setString(variant.toString());
        } else if (variant instanceof LiveObject) {
            arg.setObject(((LiveObject)variant).getXFAObject());
        } else {
            arg.setVoid(variant);
        }
        return arg;
    }

    static int RhinoErrorIdToErrorCode(int nErrorCode) {
        return 8;
    }

    @Override
    public void setOption(String sOptionName, String sOptionValue) {
        if (INPTERPRET_SCRIPT.equals(sOptionName)) {
            this.interpretScript = Boolean.valueOf(sOptionValue);
        } else {
            super.setOption(sOptionName, sOptionValue);
        }
    }

    @Override
    public String getOption(String sOptionName) {
        if (INPTERPRET_SCRIPT.equals(sOptionName)) {
            return String.valueOf(this.interpretScript);
        }
        return super.getOption(sOptionName);
    }
}

