/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.scripthandler.rhino;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.scripthandler.rhino.RhinoScriptHandler;
import com.adobe.xfa.ut.ExFull;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class LiveComponent
extends ScriptableObject {
    static final long serialVersionUID = 1853010678358666589L;
    private static final String CLASSNAME = "LiveComponent";
    private static final Map<String, Object> mStandardObjects;
    private static final Method mInvokeMethod;
    private transient AppModel moAppModel;
    private transient RhinoScriptHandler moHandler;

    public LiveComponent(RhinoScriptHandler handler, Obj xfaObject) {
        this.jsConstructor(handler, xfaObject);
    }

    public void jsConstructor(Object handler, Obj object) {
        assert (handler instanceof RhinoScriptHandler);
        this.moHandler = (RhinoScriptHandler)handler;
        assert (object instanceof AppModel);
        this.setXFAObjectValue((AppModel)object);
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (name.equals("XFAObject")) {
            return Undefined.instance;
        }
        if (!mStandardObjects.containsKey(name)) {
            if (name.equals("xfa")) {
                return this.moHandler.getAppModelLiveObject();
            }
            if (this.moAppModel != null) {
                try {
                    ScriptFuncObj scriptFuncObj = this.moAppModel.getContext().getScriptMethodInfo(name);
                    if (scriptFuncObj != null && !this.moAppModel.getContext().validateUsageFailedIsFatal(scriptFuncObj.getXFAVersion(), scriptFuncObj.getAvailability())) {
                        return new FunctionObject(name, mInvokeMethod, this);
                    }
                    SOMParser oParser = new SOMParser(null);
                    ArrayList<SOMParser.SomResultInfo> oResult = new ArrayList<SOMParser.SomResultInfo>();
                    oParser.resolve(this.moAppModel.getContext(), name, oResult);
                    if (oResult.size() == 1) {
                        return this.moHandler.argToVariant(((SOMParser.SomResultInfo)oResult.get((int)0)).value);
                    }
                }
                catch (ExFull oEx) {
                    this.moHandler.throwError(oEx);
                }
            }
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        block4: {
            if (name.equals("XFAObject")) {
                return;
            }
            if (!(value instanceof IdFunctionObject) && !mStandardObjects.containsKey(name) && this.moAppModel != null) {
                try {
                    this.moAppModel.getContext().setScriptProperty(name, this.moHandler.variantToArg(value), false);
                    return;
                }
                catch (ExFull oEx) {
                    if (oEx.firstResId() != 0) break block4;
                    this.moHandler.throwError(oEx);
                }
            }
        }
        super.put(name, start, value);
    }

    public static Object invoke(Context cx, Scriptable obj, Object[] args, Function func) {
        LiveComponent oThis = (LiveComponent)obj;
        try {
            DependencyTracker oDependencyTracker = oThis.moHandler.getAppModel().dependencyTracker();
            Arg oRetVal = new Arg();
            String sFunctionName = ((FunctionObject)func).getFunctionName();
            Arg[] oArgs = new Arg[args.length];
            for (int i = 0; i < args.length; ++i) {
                oArgs[i] = oThis.moHandler.variantToArg(args[i]);
            }
            oThis.moAppModel.getContext().invokeFunction(oRetVal, sFunctionName, oArgs, oDependencyTracker, false);
            ScriptDebugger oDebugger = oThis.moHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.resolvedValue(sFunctionName, oRetVal);
            }
            return oThis.moHandler.argToVariant(oRetVal);
        }
        catch (ExFull oEx) {
            oThis.moHandler.throwError(oEx);
            return Undefined.instance;
        }
    }

    void setXFAObjectValue(AppModel oAppModel) {
        this.moAppModel = oAppModel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().getSimpleName());
    }

    static {
        Method m;
        block2: {
            mStandardObjects = new HashMap<String, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("Infinity", null);
                    this.put("NaN", null);
                    this.put("Math", null);
                    this.put("Output", null);
                    this.put("StopIteration", null);
                    this.put("undefined", null);
                }
            };
            m = null;
            try {
                m = LiveComponent.class.getMethod("invoke", Context.class, Scriptable.class, Object[].class, Function.class);
            }
            catch (NoSuchMethodException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        mInvokeMethod = m;
    }
}

