/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

public class GFXMapping {
    private final IndexSet moChars;
    private final IndexSet moGlyphs;

    public GFXMapping() {
        this.moChars = new IndexSet();
        this.moGlyphs = new IndexSet();
    }

    public GFXMapping(GFXMapping oSource) {
        this.moChars = new IndexSet(oSource.moChars);
        this.moGlyphs = new IndexSet(oSource.moGlyphs);
    }

    public GFXMapping(int nCharIndex, int nGlyphIndex, int nCharLength, int nGlyphLength) {
        this.moChars = new IndexSet(nCharIndex, nCharLength);
        this.moGlyphs = new IndexSet(nGlyphIndex, nGlyphLength);
    }

    public GFXMapping(int nCharIndex, int nGlyphIndex, int nCharLength) {
        this(nCharIndex, nGlyphIndex, nCharLength, 1);
    }

    public GFXMapping(int nCharIndex, int nGlyphIndex) {
        this(nCharIndex, nGlyphIndex, 1, 1);
    }

    public void addCharIndex(int nCharIndex) {
        this.moChars.add(nCharIndex);
    }

    public int getCharCount() {
        return this.moChars.getCount();
    }

    public int getCharIndex(int nIndex) {
        return this.moChars.get(nIndex);
    }

    public int getLowestCharIndex() {
        return this.moChars.getLowest();
    }

    public int getHighestCharIndex() {
        return this.moChars.getHighest();
    }

    public void addGlyphIndex(int nGlyphIndex) {
        this.moGlyphs.add(nGlyphIndex);
    }

    public int getGlyphCount() {
        return this.moGlyphs.getCount();
    }

    public int getGlyphIndex(int nIndex) {
        return this.moGlyphs.get(nIndex);
    }

    public int getLowestGlyphIndex() {
        return this.moGlyphs.getLowest();
    }

    public int getHighestGlyphIndex() {
        return this.moGlyphs.getHighest();
    }

    public void copyFrom(GFXMapping oSource) {
        if (this != oSource) {
            this.moChars.copyFrom(oSource.moChars);
            this.moGlyphs.copyFrom(oSource.moGlyphs);
        }
    }

    int getCount(boolean bGlyph) {
        return bGlyph ? this.getGlyphCount() : this.getCharCount();
    }

    int getIndex(boolean bGlyph, int nIndex) {
        return bGlyph ? this.getGlyphIndex(nIndex) : this.getCharIndex(nIndex);
    }

    int getLowestIndex(boolean bGlyph) {
        return bGlyph ? this.getLowestGlyphIndex() : this.getLowestCharIndex();
    }

    int getHighestIndex(boolean bGlyph) {
        return bGlyph ? this.getHighestGlyphIndex() : this.getHighestCharIndex();
    }

    private static class IndexSet {
        private int mnStart;
        private int mnLength;
        private int[] mpoIndexes;

        IndexSet() {
        }

        IndexSet(IndexSet oSource) {
            this.copyFrom(oSource);
        }

        IndexSet(int nIndex, int nLength) {
            this.mnStart = nIndex;
            this.mnLength = nLength;
        }

        void add(int nIndex) {
            if (this.mpoIndexes == null) {
                int nStart;
                int nLimit;
                if ((nLimit = (nStart = this.mnStart--) + this.mnLength) == nStart) {
                    this.mnStart = nIndex;
                    this.mnLength = 1;
                } else if (nIndex + 1 != nStart) {
                    if (nIndex == nLimit) {
                        ++this.mnLength;
                    } else if (nIndex < nStart || nIndex >= nLimit) {
                        this.forceArray();
                    }
                }
            }
            if (this.mpoIndexes != null) {
                int currentLength = this.mpoIndexes.length;
                if (this.mnLength >= currentLength) {
                    int[] newIndexes = new int[currentLength * 2];
                    for (int i = 0; i < this.mnLength; ++i) {
                        newIndexes[i] = this.mpoIndexes[i];
                    }
                    this.mpoIndexes = newIndexes;
                }
                this.mpoIndexes[this.mnLength] = nIndex;
                ++this.mnLength;
            }
        }

        int getCount() {
            return this.mnLength;
        }

        int get(int nIndex) {
            return this.mpoIndexes == null ? this.mnStart + nIndex : this.mpoIndexes[nIndex];
        }

        int getLowest() {
            return this.mpoIndexes == null ? this.mnStart : this.searchLowest();
        }

        int getHighest() {
            return this.mpoIndexes == null ? this.mnStart + this.mnLength - 1 : this.searchHighest();
        }

        void copyFrom(IndexSet oSource) {
            if (this != oSource) {
                this.mnLength = oSource.mnLength;
                if (oSource.mpoIndexes == null) {
                    this.mpoIndexes = null;
                    this.mnStart = oSource.mnStart;
                } else {
                    if (this.mpoIndexes == null || this.mpoIndexes.length < oSource.mnLength) {
                        this.mpoIndexes = new int[oSource.mpoIndexes.length];
                    }
                    for (int i = 0; i < oSource.mnLength; ++i) {
                        this.mpoIndexes[i] = oSource.mpoIndexes[i];
                    }
                }
            }
        }

        private int searchLowest() {
            assert (this.mpoIndexes != null);
            int nReturn = Integer.MAX_VALUE;
            for (int i = 0; i < this.mnLength; ++i) {
                int nIndex = this.mpoIndexes[i];
                if (nIndex >= nReturn) continue;
                nReturn = nIndex;
            }
            return nReturn;
        }

        private int searchHighest() {
            assert (this.mpoIndexes != null);
            int nReturn = 0;
            for (int i = 0; i < this.mnLength; ++i) {
                int nIndex = this.mpoIndexes[i];
                if (nIndex <= nReturn) continue;
                nReturn = nIndex;
            }
            return nReturn;
        }

        private void forceArray() {
            int size;
            assert (this.mpoIndexes == null);
            for (size = 4; size < this.mnLength; size *= 2) {
            }
            this.mpoIndexes = new int[size];
            for (int i = 0; i < this.mnLength; ++i) {
                this.mpoIndexes[i] = this.mnStart + i;
            }
        }
    }
}

