/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.ut.StringUtils;
import java.text.Collator;

final class BuiltinLogical {
    private BuiltinLogical() {
    }

    static void Choose(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block9: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 1, oArgSym);
                int nVal = (int)oParser.getNumeric(oArgSym[0]);
                int i = 1;
                while (i < nArgs) {
                    if (oArgSym[i].getType() == 9) {
                        int j;
                        CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                        int nSyms = oSym.length;
                        for (j = 0; j < nSyms; ++j) {
                            if (i + j != nVal) continue;
                            oRetSym = new CalcSymbol(oSym[j]);
                            break;
                        }
                        for (j = nSyms - 1; j >= 0; --j) {
                            CalcSymbol.delete(oSym[j], oParser);
                        }
                        i += nSyms;
                    } else {
                        if (i == nVal) {
                            oRetSym = new CalcSymbol(oArgSym[i]);
                        }
                        ++i;
                    }
                    if (oRetSym == null) continue;
                }
                if (oRetSym == null) {
                    oRetSym = new CalcSymbol("");
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block9;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void If(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block6: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 1, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                CalcSymbol oSym1 = new CalcSymbol(oArgSym[1]);
                oParser.getNumeric(oSym1);
                CalcSymbol oSym2 = null;
                if (nArgs > 2) {
                    oSym2 = new CalcSymbol(oArgSym[2]);
                    oParser.getNumeric(oSym2);
                } else {
                    oSym2 = new CalcSymbol("");
                }
                if (nVal != 0.0) {
                    oRetSym = oSym1;
                    CalcSymbol.delete(oSym2, oParser);
                } else {
                    oRetSym = oSym2;
                    CalcSymbol.delete(oSym1, oParser);
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block6;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Oneof(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                oRetSym = BuiltinLogical.computeOneof(oParser, oArgSym);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Throw(CalcParser oParser, CalcSymbol[] oArgSym) {
        int nArgs = oArgSym.length;
        CalcSymbol oRetSym = null;
        try {
            Builtins.maxArgs(nArgs, 1);
            Builtins.limitExceptionArgs(oArgSym);
            String sVal = nArgs > 0 ? oParser.getString(oArgSym[0]) : "";
            oRetSym = new CalcSymbol(sVal);
            oRetSym.setType(10);
        }
        catch (CalcException e) {
            oRetSym = e.getSymbol();
        }
        oParser.mbInThrow = true;
        oParser.mStack.push(oRetSym);
    }

    static void Within(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 3);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 1, oArgSym);
                oRetSym = BuiltinLogical.computeWithin(oParser, oArgSym);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static CalcSymbol computeOneof(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block34: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                boolean bOneof = false;
                int fType = oArgSym[0].getType();
                if (fType == 9) {
                    CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[0].getName(), oArgSym[0].getObjValues());
                    CalcSymbol oTmpSym = oArgSym[0];
                    oArgSym[0] = oSym[0];
                    CalcSymbol oOneof = BuiltinLogical.computeOneof(oParser, oArgSym);
                    if (oParser.getNumeric(oOneof) == 1.0) {
                        bOneof = true;
                    }
                    CalcSymbol.delete(oOneof, oParser);
                    oArgSym[0] = oTmpSym;
                    for (int j = oSym.length - 1; j >= 0; --j) {
                        CalcSymbol.delete(oSym[j], oParser);
                    }
                } else if (fType == 3) {
                    double nVal = oParser.getNumeric(oArgSym[0]);
                    for (int i = 1; i < nArgs; ++i) {
                        if (oArgSym[i].getType() == 9) {
                            int j;
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            int nSyms = oSym.length;
                            for (j = 0; j < nSyms; ++j) {
                                if (nVal != oParser.getNumeric(oSym[j])) continue;
                                bOneof = true;
                                break;
                            }
                            for (j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                        } else if (nVal == oParser.getNumeric(oArgSym[i])) {
                            bOneof = true;
                        }
                        if (!bOneof) {
                            continue;
                        }
                        break;
                    }
                } else if (fType == 2 || fType == 5) {
                    String sVal = oParser.getString(oArgSym[0]);
                    for (int i = 1; i < nArgs; ++i) {
                        if (oArgSym[i].getType() == 9) {
                            int j;
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            int nSyms = oSym.length;
                            for (j = 0; j < nSyms; ++j) {
                                if (!sVal.equals(oParser.getString(oSym[j]))) continue;
                                bOneof = true;
                                break;
                            }
                            for (j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                        } else if (sVal.equals(oParser.getString(oArgSym[i]))) {
                            bOneof = true;
                        }
                        if (!bOneof) {
                            continue;
                        }
                        break;
                    }
                } else if (fType == 1) {
                    for (int i = 1; i < nArgs; ++i) {
                        if (oArgSym[i].getType() == 9) {
                            int j;
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            int nSyms = oSym.length;
                            for (j = 0; j < nSyms; ++j) {
                                if (fType != oSym[j].getType()) continue;
                                bOneof = true;
                                break;
                            }
                            for (j = nSyms - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                        } else if (fType == oArgSym[i].getType()) {
                            bOneof = true;
                        }
                        if (!bOneof) {
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new CalcException(oArgSym[0]);
                }
                oRetSym = new CalcSymbol(bOneof ? 1.0 : 0.0);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block34;
                oParser.mbInThrow = true;
            }
        }
        return oRetSym;
    }

    static CalcSymbol computeWithin(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block11: {
            oRetSym = null;
            try {
                boolean bWithin = false;
                int fType = oArgSym[0].getType();
                if (fType == 9) {
                    CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[0].getName(), oArgSym[0].getObjValues());
                    CalcSymbol oTmpSym = oArgSym[0];
                    oArgSym[0] = oSym[0];
                    CalcSymbol oWithin = BuiltinLogical.computeWithin(oParser, oArgSym);
                    if (oParser.getNumeric(oWithin) == 1.0) {
                        bWithin = true;
                    }
                    CalcSymbol.delete(oWithin, oParser);
                    oArgSym[0] = oTmpSym;
                    for (int j = oSym.length - 1; j >= 0; --j) {
                        CalcSymbol.delete(oSym[j], oParser);
                    }
                } else if (oArgSym[0].isNumeric()) {
                    double nVal = oParser.getNumeric(oArgSym[0]);
                    double nValLo = oParser.getNumeric(oArgSym[1]);
                    double nValHi = oParser.getNumeric(oArgSym[2]);
                    if (nValLo <= nVal && nVal <= nValHi) {
                        bWithin = true;
                    }
                } else if (fType == 2 || fType == 5) {
                    String sVal = oParser.getString(oArgSym[0]);
                    String sValLo = oParser.getString(oArgSym[1]);
                    String sValHi = oParser.getString(oArgSym[2]);
                    Collator oCol = Collator.getInstance();
                    if (oCol.compare(sVal, sValLo) >= 0 && oCol.compare(sVal, sValHi) <= 0) {
                        bWithin = true;
                    }
                }
                oRetSym = new CalcSymbol(bWithin ? 1.0 : 0.0);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block11;
                oParser.mbInThrow = true;
            }
        }
        return oRetSym;
    }

    static void Exists(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block8: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                CalcSymbol oSymIn = new CalcSymbol(oArgSym[0]);
                int nRetVal = 1;
                switch (oSymIn.getType()) {
                    case 9: {
                        if (oSymIn.getName().indexOf(42) >= 0) {
                            CalcSymbol.delete(oSymIn, oParser);
                            throw new CalcException();
                        }
                        if (BuiltinLogical.isObject(oParser, oSymIn)) break;
                        nRetVal = 0;
                        break;
                    }
                    case 6: {
                        if (oSymIn.getObjValue() != null) break;
                        nRetVal = 0;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        nRetVal = 0;
                        break;
                    }
                    default: {
                        CalcException e = new CalcException(oSymIn);
                        CalcSymbol.delete(oSymIn, oParser);
                        throw e;
                    }
                }
                CalcSymbol.delete(oSymIn, oParser);
                oRetSym = new CalcSymbol(nRetVal);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block8;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void HasValue(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                String s = oParser.getString(oArgSym[0]).trim();
                oRetSym = new CalcSymbol(StringUtils.isEmpty(s) ? 0.0 : 1.0);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static boolean isObject(CalcParser oParser, CalcSymbol oArgSym) {
        try {
            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym.getName(), oArgSym.getObjValues());
            for (int j = oSym.length - 1; j >= 0; --j) {
                CalcSymbol.delete(oSym[j], oParser);
            }
            return true;
        }
        catch (CalcException e) {
            try {
                oParser.moScriptHost.getItem(oArgSym.getName(), oArgSym.getObjValues());
                return true;
            }
            catch (CalcException calcException) {
                return false;
            }
        }
    }
}

