/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.xfa.font.FontInfo;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.ut.UnitSpan;
import java.io.File;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;

public class FontService {
    public static final int ISO_8859_1 = 1;
    public static final int ISO_8859_2 = 2;
    public static final int ISO_8859_5 = 3;
    public static final int ISO_8859_6 = 4;
    public static final int ISO_8859_7 = 5;
    public static final int ISO_8859_8 = 6;
    public static final int ISO_8859_9 = 7;
    public static final int IBM_874 = 8;
    public static final int IBM_1258 = 9;
    public static final int SHIFT_JIS = 10;
    public static final int SHIFT_JIS_83 = 11;
    public static final int KSC_5601 = 12;
    public static final int BIG_5 = 13;
    public static final int HKSCS_BIG5 = 14;
    public static final int GBK = 15;
    public static final int FONT_SPECIFIC = 16;
    public static final int UTF_8 = 17;
    public static final int UTF_16 = 18;
    public static final int UCS_2 = 19;
    public static final int IDENTITY = 20;
    public static final int MAC_ROMAN = 21;
    public static final int ENCODING_NONE = 22;
    private final SortedMap<FontInfo, FontItem> mFontList;

    public FontService(String fontPath) {
        File fontDir = new File(fontPath);
        FontLoader fontLoader = new FontLoader();
        Font[] fonts = fontLoader.load(fontDir, true, null);
        this.mFontList = new TreeMap<FontInfo, FontItem>();
        for (int fontIndex = 0; fontIndex < fonts.length; ++fontIndex) {
            Font font;
            CSS20FontDescription[] descs;
            block10: {
                descs = null;
                font = fonts[fontIndex];
                try {
                    descs = font.getCSS20FontDescription();
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
            if (descs == null) continue;
            for (int descIndex = 0; descIndex < descs.length; ++descIndex) {
                FontItem fontItem;
                CSS20FontDescription desc = descs[descIndex];
                if (desc.getVariant() != CSS20Attribute.CSSVariantValue.NORMAL) continue;
                FontInfo key = FontInfo.createFromAFEDescription(desc);
                boolean put = false;
                FontItem existingFont = (FontItem)this.mFontList.get(key);
                if (existingFont == null) {
                    put = true;
                } else if (key.getStretchDiff() < existingFont.getStretchDiff()) {
                    put = true;
                } else if (key.getStretchDiff() == existingFont.getStretchDiff() && key.getLegacySizeDiff() < existingFont.getLegacySizeDiff()) {
                    put = true;
                }
                if (!put) continue;
                if (existingFont != null) {
                    this.mFontList.remove(key);
                }
                if (!(fontItem = new FontItem(key, font)).loadMetrics()) continue;
                this.mFontList.put(fontItem, fontItem);
            }
        }
    }

    public synchronized FontInstance reconcile(FontInfo info, UnitSpan size, double horizontalScale, double verticalScale) {
        FontItem fontItem = this.reconcile(info);
        if (fontItem == null) {
            return null;
        }
        return fontItem.reconcile(size, horizontalScale, verticalScale);
    }

    public synchronized FontItem reconcile(FontInfo key) {
        FontItem fontItem = (FontItem)this.mFontList.get(key);
        if (fontItem != null) {
            return fontItem;
        }
        ArrayList<FontItem> fontItems = new ArrayList<FontItem>();
        for (FontItem item : this.mFontList.values()) {
            if (!item.getTypeface().equals(key.getTypeface())) continue;
            fontItems.add(item);
        }
        if (fontItems.size() == 0) {
            return null;
        }
        int foundIndex = -1;
        int bestWeightDelta = Integer.MAX_VALUE;
        for (int i = 0; i < fontItems.size(); ++i) {
            FontItem testFont = (FontItem)fontItems.get(i);
            if (testFont.getItalic() != key.getItalic()) continue;
            int weightDelta = Math.abs(testFont.getWeight() - key.getWeight());
            if (foundIndex >= 0 && weightDelta >= bestWeightDelta) continue;
            foundIndex = i;
            bestWeightDelta = weightDelta;
        }
        return (FontItem)fontItems.get(foundIndex);
    }

    public static int getEncoding(String sEncoding) {
        return 22;
    }

    public FontInstance getDefaultFontInstance() {
        assert (false);
        return null;
    }

    public synchronized String toString() {
        StringBuilder result = new StringBuilder("Font Service:\n");
        for (FontItem fontItem : this.mFontList.values()) {
            result.append("  (" + fontItem.toString() + ")\n");
        }
        return result.toString();
    }
}

