/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.scripthandler.formcalc.FormCalcScriptHandler;
import com.adobe.xfa.scripthandler.rhino.RhinoScriptHandler;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import java.util.List;

public abstract class ScriptHandler {
    public static final int UNSPECIFIED = 0;
    public static final int CALCULATE = 1;
    public static final int VALIDATE = 2;
    public static final int ACTIVITY_INITIALIZE = 3;
    public static final int ACTIVITY_PRESAVE = 4;
    public static final int ACTIVITY_POSTSAVE = 5;
    public static final int ACTIVITY_PREPRINT = 6;
    public static final int ACTIVITY_POSTPRINT = 7;
    public static final int ACTIVITY_READY = 8;
    public static final int ACTIVITY_DOCREADY = 9;
    public static final int ACTIVITY_DOCCLOSE = 10;
    public static final int ACTIVITY_PRESUBMIT = 11;
    public static final int ACTIVITY_PREEXECUTE = 12;
    public static final int ACTIVITY_POSTEXECUTE = 13;
    public static final int ACTIVITY_PREOPEN = 14;
    public static final int ACTIVITY_INDEXCHANGE = 15;
    public static final int PREDICATE = 16;
    public static final int ACTIVITY_PRESIGN = 17;
    public static final int ACTIVITY_POSTSIGN = 18;
    public static final int ACTIVITY_POSTSUBMIT = 19;
    public static final int ACTIVITY_POSTOPEN = 20;
    public static final int ACTIVITY_VALIDATIONSTATE = 21;
    public static final int ObjectInteraction_Start = 22;
    public static final int ACTIVITY_ENTER = 23;
    public static final int ACTIVITY_EXIT = 24;
    public static final int ACTIVITY_MOUSEENTER = 25;
    public static final int ACTIVITY_MOUSEEXIT = 26;
    public static final int ACTIVITY_CHANGE = 27;
    public static final int ACTIVITY_CLICK = 28;
    public static final int ACTIVITY_FULL = 29;
    public static final int ACTIVITY_MOUSEUP = 30;
    public static final int ACTIVITY_MOUSEDOWN = 31;
    public static final int ObjectInteraction_End = 32;
    public static final int executeReason_LAST = 33;
    public static final int ERR_OK = 0;
    public static final int ERR_Syntax = 8;
    public static final int ERR_BadBreakContinue = 10;
    public static final int ERR_FuncBuiltIn = 100;
    public static final int ERR_FuncUnknown = 101;
    public static final int STEP_OVER = 0;
    public static final int STEP_INTO = 1;
    public static final int STEP_OUT = 2;
    public static final int BREAK = 3;
    public static final int HALT = 4;
    public static final int BP_SET = 0;
    public static final int BP_CLEAR = 1;
    public static final int FEATURE_NONE = 0;
    public static final int FEATURE_IS_REMOTE = 1;
    public static final int FEATURE_CAN_SET_BREAKPOINT = 2;
    public static final int FEATURE_CAN_STEP_OVER = 4;
    public static final int FEATURE_CAN_STEP_INTO = 8;
    public static final int FEATURE_CAN_STEP_OUT = 16;
    public static final int FEATURE_CAN_BREAK = 32;
    public static final int FEATURE_CAN_HALT = 64;
    ScriptDebugger moDebugger;

    public ScriptHandler() {
        this(null);
    }

    public ScriptHandler(ScriptDebugger oDebugger) {
        this.moDebugger = oDebugger;
        if (this.moDebugger != null) {
            this.moDebugger.private_attach(this);
        }
    }

    public static ScriptHandler createScriptHandler(String contentType, AppModel appModel, ScriptDebugger debugger) {
        if (contentType.length() == 0) {
            contentType = "formcalc";
        } else if (contentType.startsWith("application/x-")) {
            contentType = contentType.substring("application/x-".length());
        }
        if (contentType.equals("formcalc")) {
            return new FormCalcScriptHandler(appModel, debugger);
        }
        if (contentType.equals("javascript")) {
            return new RhinoScriptHandler(appModel, debugger);
        }
        MsgFormatPos msg = new MsgFormatPos(ResId.UnknownScriptLanguageException);
        msg.format(contentType);
        msg.format("");
        throw new ExFull(msg);
    }

    public void setDebugger(ScriptDebugger oDebugger) {
        if (this.moDebugger != null) {
            this.moDebugger.private_detach(this);
            assert (this.moDebugger == null);
        }
        this.moDebugger = oDebugger;
        if (this.moDebugger != null) {
            this.moDebugger.private_attach(this);
        }
    }

    public abstract void executeOrSyntaxCheck(String var1, Arg var2, int var3, boolean var4, String var5);

    public void execute(String script, String locale, Arg returnValue, int eReason) {
        this.executeOrSyntaxCheck(script, returnValue, eReason, false, locale);
    }

    public void syntaxCheck(String script) {
        this.executeOrSyntaxCheck(script, new Arg(), 0, true, null);
    }

    protected void clearExecutionContexts() {
    }

    public abstract String languageName();

    public void setOption(String sOptionName, String sOptionValue) {
    }

    public String getOption(String sOptionName) {
        return "";
    }

    public boolean wasFatalError() {
        return true;
    }

    public abstract ScriptHandler clone();

    public static int stringToExecuteReason(String sReason) {
        if (sReason.equals("calculate")) {
            return 1;
        }
        if (sReason.equals("validate")) {
            return 2;
        }
        if (sReason.equals("predicate")) {
            return 16;
        }
        EnumAttr oEnum = EnumAttr.getEnum(EnumType.ACTIVITY_TYPE, sReason.intern());
        switch (oEnum.getInt()) {
            case 0x4B0000: {
                return 3;
            }
            case 4915201: {
                return 23;
            }
            case 4915202: {
                return 24;
            }
            case 4915203: {
                return 25;
            }
            case 0x4B0004: {
                return 26;
            }
            case 4915205: {
                return 27;
            }
            case 4915206: {
                return 28;
            }
            case 4915207: {
                return 4;
            }
            case 4915208: {
                return 5;
            }
            case 4915209: {
                return 6;
            }
            case 4915210: {
                return 7;
            }
            case 0x4B000B: {
                return 8;
            }
            case 4915216: {
                return 29;
            }
            case 4915214: {
                return 30;
            }
            case 4915215: {
                return 31;
            }
            case 4915212: {
                return 9;
            }
            case 4915213: {
                return 10;
            }
            case 4915217: {
                return 11;
            }
            case 4915218: {
                return 12;
            }
            case 4915219: {
                return 13;
            }
            case 4915220: {
                return 14;
            }
            case 4915221: {
                return 15;
            }
            case 4915222: {
                return 17;
            }
            case 4915223: {
                return 18;
            }
            case 4915224: {
                return 19;
            }
            case 4915225: {
                return 20;
            }
            case 4915226: {
                return 21;
            }
        }
        return 0;
    }

    public static String executeReasonToString(int eReason) {
        if (eReason == 1) {
            return "calculate";
        }
        if (eReason == 2) {
            return "validate";
        }
        if (eReason == 16) {
            return "predicate";
        }
        int oEnum = ScriptHandler.executeReasonToXFAEnum(eReason);
        if (oEnum == 0) {
            return "other";
        }
        return EnumAttr.getString(oEnum);
    }

    public static int executeReasonToXFAEnum(int eReason) {
        switch (eReason) {
            case 3: {
                return 0x4B0000;
            }
            case 23: {
                return 4915201;
            }
            case 24: {
                return 4915202;
            }
            case 25: {
                return 4915203;
            }
            case 26: {
                return 0x4B0004;
            }
            case 27: {
                return 4915205;
            }
            case 28: {
                return 4915206;
            }
            case 4: {
                return 4915207;
            }
            case 5: {
                return 4915208;
            }
            case 6: {
                return 4915209;
            }
            case 7: {
                return 4915210;
            }
            case 8: {
                return 0x4B000B;
            }
            case 30: {
                return 4915214;
            }
            case 31: {
                return 4915215;
            }
            case 9: {
                return 4915212;
            }
            case 10: {
                return 4915213;
            }
            case 29: {
                return 4915216;
            }
            case 11: {
                return 4915217;
            }
            case 12: {
                return 4915218;
            }
            case 13: {
                return 4915219;
            }
            case 14: {
                return 4915220;
            }
            case 15: {
                return 4915221;
            }
            case 17: {
                return 4915222;
            }
            case 18: {
                return 4915223;
            }
            case 19: {
                return 4915224;
            }
            case 20: {
                return 4915225;
            }
            case 21: {
                return 4915226;
            }
        }
        return 0;
    }

    public ScriptDebugger getDebugger() {
        return this.moDebugger;
    }

    public boolean debugCommand(int eCmd) {
        return false;
    }

    public boolean debugBreakPoint(int nScriptID, int nLine, int eSetType) {
        return false;
    }

    public boolean debugGetStack(List<String> oStack) {
        return false;
    }

    public boolean debugGetVariables(List<String> oVarNames, List<Arg> oVarValues) {
        return false;
    }

    protected int debugFeatures() {
        return 0;
    }

    public void removeReference(Node oNode) {
    }

    public static class ScriptException
    extends ExFull {
        static final long serialVersionUID = 132047461644242605L;
        private final int mnLineNumber;
        private final int mnErrorCode;

        public ScriptException(MsgFormat oFormat, int nLineNumber, int nErrorCode) {
            super(oFormat);
            this.mnLineNumber = nLineNumber;
            this.mnErrorCode = nErrorCode;
        }

        public int getLineNumber() {
            return this.mnLineNumber;
        }

        public int getErrorCode() {
            return this.mnErrorCode;
        }
    }
}

