/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import org.xml.sax.Attributes;

public abstract class ModelFactory {
    protected final int meClassTag;
    protected final String maRootName;
    protected final String maShortCutName;

    public ModelFactory(int eClassTag, String aRootName, String aShortCutName) {
        this.meClassTag = eClassTag;
        this.maRootName = aRootName;
        this.maShortCutName = aShortCutName;
    }

    public final String rootName() {
        return this.maRootName;
    }

    public void setOption(String optionName, String optionValue, boolean bCritical) {
        throw new ExFull(ResId.InvalidOptionException, optionName);
    }

    protected boolean isRootNode(AppModel parent, String uri, String localName) {
        return localName == this.rootName();
    }

    protected abstract Model newModel(AppModel var1, Node var2, String var3, String var4, String var5, Attributes var6);

    protected Model findModel(Node parent) {
        for (Node oChild = parent.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            if (!this.isRootName(oChild.getName()) || !(oChild instanceof Model)) continue;
            return (Model)oChild;
        }
        return null;
    }

    public boolean getAllowAdd() {
        return false;
    }

    public abstract Model createDOM(Element var1);

    public boolean isRootName(String name) {
        return this.rootName() == name;
    }
}

