/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeScript;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.template.containers.Variables;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ElementScript
extends NodeScript {
    protected static final ScriptTable moScriptTable = new ScriptTable(NodeScript.moScriptTable, "element", new ScriptPropObj[]{new ScriptPropObj(ElementScript.class, "isNull", "getIsNull", null, 3, 10, 9, 0), new ScriptPropObj(ElementScript.class, "oneOfChild", "getOneOfChild", "setOneOfChild", 7, 10, 9, 0), new ScriptPropObj(ElementScript.class, "id", "getId", "setId", 6, 10, 9, 0), new ScriptPropObj(ElementScript.class, "ns", "getNs", null, 6, 10, 9, 0)}, new ScriptFuncObj[]{new ScriptFuncObj(ElementScript.class, "clone", "clone", 7, new int[]{3}, 1, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "isPropertySpecified", "isPropertySpecified", 3, new int[]{6, 3, 4}, 1, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "getElement", "getElement", 7, new int[]{6, 4}, 1, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "setElement", "setElement", 1, new int[]{7, 6}, 1, 10, 9, "setElementPermsCheck", 0), new ScriptFuncObj(ElementScript.class, "getAttribute", "getAttribute", 6, new int[]{6}, 1, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "setAttribute", "setAttribute", 1, new int[]{6, 6}, 2, 10, 9, "setAttributePermsCheck", 0), new ScriptFuncObj(ElementScript.class, "loadXML", "loadXML", 1, new int[]{6, 3, 3}, 1, 10, 9, "loadXMLPermsCheck", 0), new ScriptFuncObj(ElementScript.class, "saveXML", "saveXML", 6, new int[]{6}, 0, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "saveFilteredXML", "saveFilteredXML", 6, new int[]{7, 6}, 1, 24, 9, 0), new ScriptFuncObj(ElementScript.class, "applyXSL", "applyXSL", 6, new int[]{6}, 1, 10, 9, 0), new ScriptFuncObj(ElementScript.class, "assignNode", "assignNode", 7, new int[]{6, 6, 4}, 1, 10, 9, "assignNodePermsCheck", 0), new ScriptFuncObj(ElementScript.class, "resolveNode", "resolveNode", 7, new int[]{6}, 1, 10, 63, 0), new ScriptFuncObj(ElementScript.class, "resolveNodes", "resolveNodes", 7, new int[]{6}, 1, 10, 63, 0)});

    public static ScriptTable getScriptTable() {
        return moScriptTable;
    }

    public static void getIsNull(Obj obj, Arg retVal) {
        if (obj instanceof Element) {
            retVal.setBool(((Element)obj).getIsNull());
        } else if (obj instanceof TextNode) {
            retVal.setBool(Boolean.FALSE);
        }
    }

    public static void getOneOfChild(Obj obj, Arg retVal) {
        if (obj instanceof Element) {
            retVal.setObject(((Element)obj).getOneOfChild());
        } else {
            retVal.setObject(null);
        }
    }

    public static void setOneOfChild(Obj obj, Arg oArg) {
        Obj child = oArg.getObject();
        if (!(child instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetOneOfException);
            message.format(child.getClassAtom());
            throw new ExFull(message);
        }
        ((Element)obj).setOneOfChild((Node)child);
    }

    public static void getId(Obj obj, Arg retVal) {
        if (obj instanceof Element) {
            retVal.setString(((Element)obj).getID());
        } else {
            retVal.setString("");
        }
    }

    public static void setId(Obj obj, Arg oArg) {
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(obj.getClassAtom());
            message.format("id");
            throw new ExFull(message);
        }
        ((Element)obj).setID(oArg.getString());
    }

    public static void getNs(Obj obj, Arg retVal) {
        if (obj instanceof Element) {
            retVal.setString(((Element)obj).getNSInternal());
        } else if (obj instanceof TextNode) {
            retVal.setString("");
        }
    }

    public static void clone(Obj obj, Arg retVal, Arg[] args) {
        boolean bRecursive = args[0].getBool();
        if (obj instanceof Element) {
            retVal.setObject(((Element)obj).clone(null, bRecursive));
        } else {
            retVal.setObject(((Node)obj).clone(null));
        }
    }

    public static void isPropertySpecified(Obj obj, Arg retVal, Arg[] args) {
        if (obj instanceof Element) {
            Element e = (Element)obj;
            String propertyName = args[0].getString();
            boolean bCheckProtos = args.length < 2 ? true : args[1].getBool();
            int occurrence = args.length < 3 ? 0 : args[2].getInteger();
            retVal.setBool(e.isPropertySpecified(propertyName, bCheckProtos, occurrence));
        } else {
            retVal.setBool(Boolean.FALSE);
        }
    }

    public static void getElement(Obj obj, Arg retVal, Arg[] args) {
        int occurrence;
        if (!(obj instanceof Element)) {
            return;
        }
        Element e = (Element)obj;
        String propName = args[0].getString().intern();
        Object property = e.getProperty(propName, occurrence = args.length == 1 ? 0 : args[1].getInteger());
        if (property == null) {
            return;
        }
        if (!(property instanceof Element)) {
            throw new ExFull(new MsgFormat(ResId.InvalidAttributeException, " element[" + propName + ")"));
        }
        retVal.setObject((Element)property);
    }

    public static void setElement(Obj obj, Arg retVal, Arg[] args) {
        String propertyName;
        Obj property = args[0].getObject();
        if (!(property instanceof Element)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        String string = propertyName = args.length < 2 ? "" : args[1].getString();
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(obj.getClassAtom());
            message.format(propertyName);
            throw new ExFull(message);
        }
        ((Element)obj).setProperty((Object)property, propertyName);
    }

    public static void getAttribute(Obj obj, Arg retVal, Arg[] args) {
        if (!(obj instanceof Element)) {
            return;
        }
        String propName = args[0].getString();
        Object property = ((Element)obj).getProperty(propName, 0);
        if (property == null) {
            return;
        }
        if (!(property instanceof Attribute)) {
            throw new ExFull(ResId.InvalidAttributeException, " attribute[" + propName + ")");
        }
        retVal.setString(property.toString());
    }

    public static void setAttribute(Obj obj, Arg retVal, Arg[] args) {
        String aAttrName = args[1].getString();
        if (aAttrName != null) {
            aAttrName = aAttrName.intern();
        }
        int eTag = -1;
        if (aAttrName != null) {
            eTag = XFA.getTag(aAttrName);
        }
        if (!(obj instanceof Element) || eTag == -1) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidSetPropertyException);
            oMessage.format(((Node)obj).getClassAtom());
            oMessage.format(aAttrName);
            throw new ExFull(oMessage);
        }
        ((Element)obj).setAttribute(((Element)obj).newAttribute(eTag, args[0].getString()), eTag);
    }

    public static void loadXML(Obj obj, Arg retVal, Arg[] args) {
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.ParentChildViolationException);
            throw new ExFull(message);
        }
        try {
            ByteArrayInputStream streamFile = new ByteArrayInputStream(args[0].getString().getBytes("UTF-8"));
            boolean bIgnoreAggregatingTag = true;
            boolean bReplaceContent = false;
            if (args.length == 1 && obj instanceof ExDataValue) {
                bIgnoreAggregatingTag = false;
            }
            if (args.length >= 2) {
                bIgnoreAggregatingTag = args[1].getBool();
            }
            if (args.length == 3) {
                bReplaceContent = args[2].getBool();
            }
            Element.ReplaceContent eReplace = Element.ReplaceContent.None;
            if (bReplaceContent) {
                eReplace = obj instanceof Packet && ((Packet)obj).getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING) ? Element.ReplaceContent.AllContent : Element.ReplaceContent.XFAContent;
            }
            ((Element)obj).loadXML((InputStream)streamFile, bIgnoreAggregatingTag, eReplace);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void saveXML(Obj obj, Arg retVal, Arg[] args, DependencyTracker dependencyTracker) {
        ElementScript.addDependency((Element)obj, dependencyTracker);
        DOMSaveOptions options = new DOMSaveOptions();
        options.setSaveTransient(((Element)obj).getSaveXMLSaveTransient());
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        if (args.length == 1) {
            if (args[0].getString().equals("pretty")) {
                options.setDisplayFormat(2);
            } else {
                MsgFormatPos message = new MsgFormatPos(ResId.ArgumentMismatchException);
                throw new ExFull(message);
            }
        }
        if (obj instanceof Element) {
            ((Element)obj).saveXML(memStream, options, true);
        } else if (obj instanceof Node) {
            Node node = (Node)obj;
            node.getOwnerDocument().saveAs(memStream, node, options);
        }
        String result = "";
        try {
            result = memStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        retVal.setString(result);
    }

    public static void saveFilteredXML(Obj obj, Arg retVal, Arg[] args, DependencyTracker dependencyTracker) {
        Obj object = args[0].getObject();
        if (!(object instanceof NodeList)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        ByteArrayOutputStream memStreamFile = new ByteArrayOutputStream();
        ElementScript.addDependency((Element)obj, dependencyTracker);
        DOMSaveOptions options = new DOMSaveOptions();
        options.setSaveTransient(false);
        if (args.length == 2) {
            if (args[1].getString().equals("pretty")) {
                options.setSaveTransient(true);
                options.setDisplayFormat(2);
            } else {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.ArgumentMismatchException);
                throw new ExFull(oMessage);
            }
        }
        if (obj instanceof Element) {
            ((Element)obj).saveFilteredXML((NodeList)object, memStreamFile, options);
        } else if (obj instanceof Node) {
            Node node = (Node)obj;
            node.getOwnerDocument().saveAs(memStreamFile, node, options);
        }
        try {
            retVal.setString(memStreamFile.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void applyXSL(Obj obj, Arg retVal, Arg[] args) {
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidMethodException);
            message.format(obj.getClassAtom());
            message.format("applyXSL");
            throw new ExFull(message);
        }
        try {
            ByteArrayInputStream xslTransformStream = new ByteArrayInputStream(args[0].getString().getBytes("UTF-8"));
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            ((Element)obj).applyXSL(xslTransformStream, resultStream);
            retVal.setString(resultStream.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void assignNode(Obj obj, Arg retVal, Arg[] args) {
        if (!(obj instanceof Element)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidMethodException);
            message.format(obj.getClassAtom());
            message.format("assignNode");
            throw new ExFull(message);
        }
        retVal.setObject(((Element)obj).assignNode(args[0].getString(), args[1].getString(), args[2].getInteger()));
    }

    public static void resolveNode(Obj obj, Arg retVal, Arg[] args, DependencyTracker dependencyTracker) {
        AppModel oAppModel = ((Element)obj).getAppModel();
        DependencyTracker oDependencyTracker = null;
        if (oAppModel != null && !oAppModel.getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
            oDependencyTracker = dependencyTracker;
        }
        retVal.setObject(((Element)obj).resolveNode(args[0].getString(), false, false, false, oDependencyTracker, null));
    }

    public static void resolveNodes(Obj obj, Arg retVal, Arg[] args, int nParamCount, DependencyTracker dependencyTracker) {
        AppModel oAppModel = ((Element)obj).getAppModel();
        DependencyTracker oDependencyTracker = null;
        if (oAppModel != null && !oAppModel.getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
            oDependencyTracker = dependencyTracker;
        }
        retVal.setObject(((Element)obj).resolveNodes(args[0].getString(), false, false, false, oDependencyTracker, null));
    }

    public static boolean locateOneOf(Obj obj, Arg retVal, String sProp) {
        Node pOneOf;
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        int nTag = XFA.getTag(sProp);
        if (nTag == -1) {
            return false;
        }
        int eTag = nTag;
        int eType = ((Element)obj).getSchemaType(eTag);
        if (eType == 3 && (pOneOf = ((Element)obj).getOneOfChild(true, false)) != null && pOneOf.getClassTag() == eTag) {
            pOneOf = ((Element)obj).getOneOfChild(false, false);
            retVal.setObject(pOneOf);
            return true;
        }
        return false;
    }

    public static boolean locateProp(Obj obj, Arg retVal, String sProp) {
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        int nTag = XFA.getTag(sProp);
        if (nTag == -1) {
            return false;
        }
        int eTag = nTag;
        int eType = ((Element)obj).getSchemaType(eTag);
        if (eType != 1 && eType != 2) {
            return false;
        }
        Element oNode = (Element)obj;
        if (eType == 1) {
            Attribute oProp = oNode.getAttribute(eTag, false, false);
            if (oProp != null) {
                retVal.setString(oProp.toString());
                return true;
            }
        } else {
            Element oProp = oNode.getElement(eTag, 0);
            if (oProp != null) {
                retVal.setObject(oProp);
                return true;
            }
        }
        return false;
    }

    public static boolean locatePropPeek(Obj obj, Arg retVal, String sProp) {
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        int nTag = XFA.getTag(sProp);
        if (nTag == -1) {
            return false;
        }
        int eTag = nTag;
        int eType = ((Element)obj).getSchemaType(eTag);
        if (eType != 1 && eType != 2) {
            return false;
        }
        if (eType == 1) {
            Attribute prop = ((Element)obj).getAttribute(eTag, true, false);
            if (prop != null) {
                retVal.setString(prop.toString());
                return true;
            }
        } else {
            Element prop = ((Element)obj).getElement(eTag, true, 0, false, false);
            if (prop != null) {
                retVal.setObject(prop);
                return true;
            }
        }
        return false;
    }

    public static boolean setProp(Obj obj, Arg arg, String sProp) {
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        int eTag = XFA.getTag(sProp);
        if (eTag == -1) {
            return false;
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element elementThis = (Element)obj;
        int eType = elementThis.getSchemaType(eTag);
        if (eType != 1) {
            return false;
        }
        StringAttr prop = new StringAttr(sProp, arg.getString());
        elementThis.setAttribute(prop, eTag);
        return true;
    }

    private static void addDependency(Node node, DependencyTracker dependencyTracker) {
        if (dependencyTracker != null && node != null && !(node instanceof Variables)) {
            dependencyTracker.addDependency(node);
            for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                ElementScript.addDependency(child, dependencyTracker);
            }
        }
    }

    public static boolean setElementPermsCheck(Obj obj, Arg[] args) {
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (!element.checkAncestorPerms()) {
                return false;
            }
            Obj object = args[0].getObject();
            if (!(object instanceof Node)) {
                throw new ExFull(ResId.ArgumentMismatchException);
            }
            Node node = (Node)object;
            Element oldChild = element.getElement(node.getClassTag(), 0);
            if (oldChild != null && !oldChild.checkDescendentPerms()) {
                return false;
            }
        }
        return true;
    }

    public static boolean setAttributePermsCheck(Obj obj, Arg[] args) {
        Element element;
        return !(obj instanceof Element) || (element = (Element)obj).checkAncestorPerms();
    }

    public static boolean loadXMLPermsCheck(Obj obj, Arg[] args) {
        if (obj instanceof Element) {
            boolean bReplace;
            Element element = (Element)obj;
            if (!element.checkAncestorPerms()) {
                return false;
            }
            if (args.length == 3 && (bReplace = args[2].getBool().booleanValue()) && !element.checkDescendentPerms()) {
                return false;
            }
        }
        return true;
    }

    public static boolean assignNodePermsCheck(Obj obj, Arg[] args) {
        if (obj instanceof Element && args.length >= 1) {
            String sCopy;
            Element element = (Element)obj;
            Node resolvedNode = element.resolveNode(args[0].getString(), true, false, false);
            if (resolvedNode != null) {
                if (args.length < 3 || args[2].getInteger() == 0) {
                    if (!resolvedNode.checkAncestorPerms()) {
                        return false;
                    }
                    if (!resolvedNode.checkDescendentPerms()) {
                        return false;
                    }
                }
            } else if (args[2].getInteger() != 0 && (sCopy = args[0].getString()).length() != 0) {
                Node parentNode;
                Node parent = element.resolveNode(sCopy, true, false, false);
                while (parent == null && sCopy.length() != 0) {
                    int nFoundAt;
                    boolean bTrimmed = false;
                    int nOffset = 0;
                    while ((nFoundAt = sCopy.indexOf(46, nOffset)) != -1) {
                        bTrimmed = true;
                        nOffset = nFoundAt + 1;
                    }
                    if (!bTrimmed) break;
                    sCopy = sCopy.substring(0, nOffset - 1);
                    parent = element.resolveNode(sCopy, true, false, false);
                }
                if (parent instanceof Node && !(parentNode = parent).checkAncestorPerms()) {
                    return false;
                }
            }
        }
        return true;
    }
}

