/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Model;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PeerImpl;

public abstract class Dispatcher
implements Peer {
    private boolean mbIsOccurring;
    private boolean mbIsRecurring;
    private boolean mbListenToDescendents;
    private final int mnEventID;
    private PeerImpl mPeers;
    private final Element mpoActionContextNode;
    private Obj mpoEventContextObject;
    private EventManager mpoEventManager;
    private final String msEventContext;

    public Dispatcher(Element poActionContextNode, String sEventContext, int nEventID, EventManager poEventManager) {
        this.mpoActionContextNode = poActionContextNode;
        this.mpoEventManager = poEventManager;
        this.mnEventID = nEventID;
        this.mbIsRecurring = true;
        this.mpoActionContextNode.addPeer(this);
        Model poModelImpl = this.mpoActionContextNode.getModel();
        if (this.mpoActionContextNode != poModelImpl) {
            poModelImpl.addPeer(this);
        }
        if (sEventContext.equals("$")) {
            this.mpoEventContextObject = this.mpoActionContextNode;
            sEventContext = "";
        }
        this.msEventContext = sEventContext;
    }

    @Override
    public void addPeer(Peer peerNode) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.addPeer(peerNode);
    }

    @Override
    public void addPeeredNode(Peer peer) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.addPeeredNode(peer);
    }

    @Override
    public void clearPeers() {
        if (this.mPeers != null) {
            this.mPeers.clearPeers();
        }
    }

    @Override
    public void deafen() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.deafen();
    }

    protected abstract void dispatch();

    public Element getActionContextNode() {
        return this.mpoActionContextNode;
    }

    public abstract String getDispatcherType();

    public String getEventContext() {
        return this.msEventContext;
    }

    public Obj getEventContextObj() {
        return this.mpoEventContextObject;
    }

    public int getEventID() {
        return this.mnEventID;
    }

    public EventManager getEventManager() {
        return this.mpoEventManager;
    }

    public boolean getListenToDescendents() {
        return this.mbListenToDescendents;
    }

    public boolean getOccurring() {
        return this.mbIsOccurring;
    }

    public String getParameter(int nParam) {
        return "";
    }

    @Override
    public Peer getPeer(int nPeer) {
        if (this.mPeers == null) {
            return null;
        }
        return this.mPeers.getPeer(nPeer);
    }

    public boolean getRecurring() {
        return this.mbIsRecurring;
    }

    @Override
    public boolean isDeaf() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isDeaf();
    }

    @Override
    public boolean isMute() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isMute();
    }

    @Override
    public void mute() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.mute();
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.mPeers != null) {
            this.mPeers.notifyPeers(eventType, arg1, arg2);
        }
    }

    @Override
    public void peerRemoved(Peer peer) {
        block4: {
            EventManager.EventID events;
            block3: {
                if (this.mpoEventManager == null) {
                    return;
                }
                int nEventId = this.getEventID();
                assert (nEventId < this.mpoEventManager.getNumEventIDs());
                events = this.mpoEventManager.getEventIDByIndex(nEventId);
                Obj object = this.getEventContextObj();
                if (object == null || object == peer) break block3;
                EventManager.EventTable eventTable = object.getEventTable(false);
                if (eventTable == null) break block4;
                eventTable.remove(this);
                break block4;
            }
            for (int i = 0; i < events.mUnInitializedEvents.size(); ++i) {
                Dispatcher dispatcher = events.mUnInitializedEvents.get(i);
                if (this != dispatcher) continue;
                events.mUnInitializedEvents.remove(i);
                break;
            }
        }
    }

    @Override
    public void removePeer(Peer oPeerNode) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeer(oPeerNode);
    }

    @Override
    public void removePeeredNode(Peer poPeer) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeeredNode(poPeer);
    }

    public void setEventContextObj(Obj poObject) {
        this.mpoEventContextObject = poObject;
    }

    public void setEventManager(EventManager poEventManager) {
        this.mpoEventManager = poEventManager;
    }

    public void setListenToDescendents(boolean bListenToDescendents) {
        this.mbListenToDescendents = bListenToDescendents;
    }

    public void setOccurring(boolean bOccurring) {
        this.mbIsOccurring = bOccurring;
    }

    public void setRecurring(boolean bRecurring) {
        this.mbIsRecurring = bRecurring;
    }

    @Override
    public void unDeafen() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unDeafen();
    }

    @Override
    public void unMute() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unMute();
    }

    @Override
    public void updateFromPeer(Object oPeerNode, int eventType, String arg1, Object arg2) {
    }
}

