/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class DSigData
extends Element {
    public DSigData(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "dSigData", "dSigData", null, XFA.DSIGDATATAG, "dSigData");
    }

    public String getValue(boolean bAsFragment) {
        return DSigData.getValuesFromDom(bAsFragment, this);
    }

    public String toString() {
        return this.getValue(false);
    }

    void setValue(String sText) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(sText.getBytes("UTF-8"));
            this.loadXML((InputStream)is, false, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    static String getValuesFromDom(boolean bAsFragment, Node oDomNode) {
        StringBuilder htmlTextValue = new StringBuilder();
        if (bAsFragment) {
            ByteArrayOutputStream oFragmentStream = new ByteArrayOutputStream();
            DOMSaveOptions oOptions = new DOMSaveOptions();
            oOptions.setSaveTransient(true);
            oOptions.setDisplayFormat(0);
            oDomNode.getOwnerDocument().saveAs(oFragmentStream, oDomNode, oOptions);
            htmlTextValue.append(oFragmentStream.toString());
        } else {
            htmlTextValue.append(oDomNode.getData());
            for (Node oChild = oDomNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
                htmlTextValue.append(DSigData.getValuesFromDom(bAsFragment, oChild));
            }
        }
        return htmlTextValue.toString();
    }
}

