/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action.collection;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNameIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSplit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFNavigatorContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFCollectionNavigator
extends XPDFCosObject {
    private PDFCollectionNavigator pdfCollectionNavigator;

    public XPDFCollectionNavigator(PDFCollectionNavigator pdfCollectionNavigator) {
        this.pdfCollectionNavigator = pdfCollectionNavigator;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        PDFCollectionSchema schema;
        String icon;
        String category;
        String description;
        AttributesImpl atts = new AttributesImpl();
        String name = this.pdfCollectionNavigator.getName();
        if (name != null) {
            ch.startElement("name");
            ch.characters(name);
            ch.endElement("name");
        }
        if ((description = this.pdfCollectionNavigator.getDesc()) != null) {
            ch.startElement("description");
            ch.characters(description);
            ch.endElement("description");
        }
        if ((category = this.pdfCollectionNavigator.getCategory()) != null) {
            ch.startElement("category");
            ch.characters(category);
            ch.endElement("category");
        }
        if (ch instanceof XPDFNavigatorContentHandler && ((XPDFNavigatorContentHandler)ch).getIconFileAdded() && (icon = this.pdfCollectionNavigator.getIcon()) != null) {
            atts.addAttribute("", "src", "src", "CDATA", icon);
            ch.startElement("icon", atts);
            ch.endElement("icon");
            atts.clear();
        }
        if (ch instanceof XPDFNavigatorContentHandler && ((XPDFNavigatorContentHandler)ch).getLocalesFileAdded()) {
            atts.addAttribute("", "src", "src", "CDATA", ((XPDFNavigatorContentHandler)ch).getLocalesFileLocation());
            ch.startElement("locales", atts);
            ch.endElement("locales");
            atts.clear();
        }
        if ((schema = this.pdfCollectionNavigator.getInitialFields()) != null && !schema.isEmpty()) {
            ch.startElement("initialFields");
            PDFCollectionNameIterator iter = schema.getKeyIterator();
            while (iter.hasNext()) {
                ASName fieldName = iter.nextKey();
                PDFCollectionField field = schema.get(fieldName);
                atts.addAttribute("", "name", "name", "CDATA", fieldName.asString());
                PDFCollectionFieldType type = field.getFieldType();
                if (type != null) {
                    String typeStr = null;
                    if (type.equals((Object)PDFCollectionFieldType.text)) {
                        typeStr = "text";
                    } else if (type.equals((Object)PDFCollectionFieldType.date)) {
                        typeStr = "date";
                    } else if (type.equals((Object)PDFCollectionFieldType.number)) {
                        typeStr = "number";
                    } else if (type.equals((Object)PDFCollectionFieldType.file)) {
                        typeStr = "filename";
                    } else if (type.equals((Object)PDFCollectionFieldType.Desc)) {
                        typeStr = "desc";
                    } else if (type.equals((Object)PDFCollectionFieldType.ModDate)) {
                        typeStr = "modDate";
                    } else if (type.equals((Object)PDFCollectionFieldType.CreationDate)) {
                        typeStr = "creationDate";
                    } else if (type.equals((Object)PDFCollectionFieldType.size)) {
                        typeStr = "size";
                    }
                    if (typeStr != null) {
                        atts.addAttribute("", "type", "type", "CDATA", typeStr);
                    }
                }
                if (field.hasVisibility()) {
                    atts.addAttribute("", "visible", "visible", "CDATA", Boolean.toString(field.getVisibility()));
                }
                if (field.hasAllowEdit()) {
                    atts.addAttribute("", "editable", "editable", "CDATA", Boolean.toString(field.getAllowEdit()));
                }
                ch.startElement("field", atts);
                String displayName = field.getName();
                if (displayName != null) {
                    ch.startElement("displayName");
                    ch.characters(displayName);
                    ch.endElement("displayName");
                }
                ch.endElement("field");
                atts.clear();
            }
            ch.endElement("initialFields");
        }
        PDFPortableCollection portfolio = null;
        if (!(ch instanceof XPDFNavigatorContentHandler)) {
            throw new PDFInvalidDocumentException("Unexpected XPDFContentHandler Type " + ch.getClass());
        }
        portfolio = ((XPDFNavigatorContentHandler)ch).getPortfolio();
        PDFCollectionSplit split = portfolio.getSplit();
        if (split != null) {
            ASName dir = split.getDirection();
            if (dir != null) {
                String splitDir = null;
                if (ASName.k_H.equals(dir)) {
                    splitDir = "horizontal";
                } else if (ASName.k_V.equals(dir)) {
                    splitDir = "vertical";
                } else if (ASName.k_N.equals(dir)) {
                    splitDir = "none";
                }
                if (splitDir != null) {
                    atts.addAttribute("", "splitDirection", "splitDirection", "CDATA", splitDir);
                }
            }
            if (split.hasPosition()) {
                double position = split.getPostion();
                atts.addAttribute("", "splitPosition", "splitPosition", "CDATA", Integer.toString((int)position));
            }
            ch.startElement("initialView", atts);
            ch.endElement("initialView");
            atts.clear();
        }
    }
}

