/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.UnsynchronizedStack;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFIgnoringHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XPDFSAXHandler
extends DefaultHandler
implements XPDFErrorHandler {
    UnsynchronizedStack<XPDFHandler> handlers = new UnsynchronizedStack();
    UnsynchronizedStack<Boolean> elementIsNewHandler = new UnsynchronizedStack();
    ErrorHandler eh = null;
    Locator locator = null;

    public XPDFSAXHandler(XPDFHandler root, ErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.eh = eh;
        this.handlers.push(root);
        this.elementIsNewHandler.push(Boolean.TRUE);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String ns, String qName, String lName, Attributes att) throws SAXException {
        XPDFAttributes xpdfAtt = new XPDFAttributes(att);
        try {
            XPDFHandler handler = this.handlers.peek().fromXPDFStartElement(lName, xpdfAtt, this);
            this.elementIsNewHandler.push(handler == null ? Boolean.FALSE : Boolean.TRUE);
            if (handler != null) {
                handler.fromXPDFStart(xpdfAtt, this);
                this.handlers.push(handler);
            }
            xpdfAtt.reportUnusedAttributesAsErrors(this);
        }
        catch (Exception e) {
            throw new SAXException("Error in instantiating PDF objects", e);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        super.characters(chars, start, length);
        try {
            this.handlers.peek().fromXPDFCharacters(chars, start, length, this);
        }
        catch (Exception e) {
            throw new SAXException("Error in instantiating PDF objects", e);
        }
    }

    @Override
    public void endElement(String ns, String lName, String qName) throws SAXException {
        super.endElement(ns, lName, qName);
        try {
            Boolean b = this.elementIsNewHandler.pop();
            if (Boolean.TRUE.equals(b)) {
                XPDFHandler handler = this.handlers.pop();
                handler.fromXPDFEnd(this);
            }
            this.handlers.peek().fromXPDFEndElement(lName, this);
        }
        catch (Exception e) {
            throw new SAXException("Error in instantiating PDF objects", e);
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        super.endPrefixMapping(arg0);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        super.startPrefixMapping(arg0, arg1);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void XPDFFatalError(String message) throws SAXException {
        this.fatalError(new SAXParseException(message, this.locator));
    }

    @Override
    public void XPDFError(String message) throws SAXException {
        this.error(new SAXParseException(message, this.locator));
    }

    @Override
    public void XPDFWarning(String message) throws SAXException {
        this.warning(new SAXParseException(message, this.locator));
    }

    @Override
    public void XPDFErrorIfNotWhitespace(char[] chars, int start, int length) throws SAXException {
        for (int i = start; i < start + length; ++i) {
            char ch = chars[i];
            if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ') continue;
            this.XPDFError("non-whitespace not allowed");
        }
    }

    @Override
    public XPDFHandler XPDFInvalidElement(String name) throws SAXException {
        this.XPDFError("Element '" + name + "' not allowed");
        return XPDFIgnoringHandler.ignoringHandler;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.eh == null) {
            throw e;
        }
        this.eh.fatalError(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.eh == null) {
            throw e;
        }
        this.eh.error(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.eh == null) {
            throw e;
        }
        this.eh.warning(e);
    }
}

