/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class InsertionContentHandler
implements ContentHandler,
LexicalHandler {
    private boolean firstElement = true;
    private boolean succeeded;
    private boolean copy;
    private boolean validate;
    private XMLElement element;
    private ContentHandler contentHandler;
    int xmlDepth = 0;

    public InsertionContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.copy = true;
    }

    public InsertionContentHandler(ContentHandler contentHandler, XMLElement element) {
        this.contentHandler = contentHandler;
        this.validate = true;
        if (!this.validate) {
            this.copy = true;
        }
        this.element = element;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.copy) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.copy) {
            --this.xmlDepth;
            if (this.validate && this.xmlDepth == 0) {
                this.copy = false;
            }
            this.contentHandler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.copy) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.firstElement && this.validate && this.element.matches(uri, localName)) {
            this.succeeded = true;
            this.copy = true;
        }
        this.firstElement = false;
        if (this.copy) {
            ++this.xmlDepth;
            this.contentHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).comment(arg0, arg1, arg2);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).endCDATA();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).endDTD();
        }
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).endEntity(arg0);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).startCDATA();
        }
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).startDTD(arg0, arg1, arg2);
        }
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
        if (this.copy && this.contentHandler instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.contentHandler)).startEntity(arg0);
        }
    }
}

