/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationRedaction
extends XFDFAnnotation {
    static final String ATTR_QUAD = "coords";
    static final String ATTR_IC = "interior-color";
    static final String ATTR_RO = "RO";
    static final String ATTR_OLT = "overlay-text";
    static final String ATTR_RPT = "overlay-text-repeat";
    static final String ATTR_DA = "defaultappearance";
    static final String ATTR_Q = "justification\u0094";
    static final String ATTR_START = "start";
    static final String ATTR_END = "end";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";
    static final String ELEM_REDA = "redact";
    static final String ATTR_MIMETYPE = "mimetype";

    public XFDFAnnotationRedaction(PDFAnnotationRedaction pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationRedaction(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        if (((PDFAnnotationRedaction)this.pdfAnnot).hasJustification()) {
            double just = ((PDFAnnotationRedaction)this.pdfAnnot).getJustification();
            annotsAtts.addAttribute("", ATTR_Q, ATTR_Q, "CDATA", String.valueOf(just));
        }
        if (((PDFAnnotationRedaction)this.pdfAnnot).hasOverlayText()) {
            String olt = ((PDFAnnotationRedaction)this.pdfAnnot).getOverlayText();
            annotsAtts.addAttribute("", ATTR_OLT, ATTR_OLT, "CDATA", olt);
        }
        if (((PDFAnnotationRedaction)this.pdfAnnot).hasRepeat()) {
            boolean rpt = ((PDFAnnotationRedaction)this.pdfAnnot).getRepeat();
            annotsAtts.addAttribute("", ATTR_RPT, ATTR_RPT, "CDATA", rpt ? "yes" : "");
        }
        this.addCoordXFDFAttribute(annotsAtts);
        try {
            if (((PDFAnnotationRedaction)this.pdfAnnot).hasRO()) {
                PDFXObjectForm ro = ((PDFAnnotationRedaction)this.pdfAnnot).getRO();
                ASName subtype = ro.getSubtype();
                if (subtype != null) {
                    annotsAtts.addAttribute("", ATTR_MIMETYPE, ATTR_MIMETYPE, "CDATA", subtype.asString());
                }
                handler.startElement("", ELEM_REDA, ELEM_REDA, annotsAtts);
                this.createXFDFStreamData(handler, ro.getCosStream());
            }
            this.createXFDFExData3DMarkup(handler);
            this.createXFDFDefaultAppearance(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_REDA, ELEM_REDA);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationRedaction rdaAnnot = PDFAnnotationRedaction.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(rdaAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            int attrInd;
            block17: {
                this.fillMarkupAttributes(rdaAnnot, elemAttrs);
                this.fillBorderStyleAttributes(rdaAnnot, elemAttrs);
                this.fillInteriorColorAttribute(rdaAnnot, elemAttrs);
                this.fillCaptionAttribute(rdaAnnot, elemAttrs);
                this.fillIntentAttribute(rdaAnnot, elemAttrs);
                this.fillCoordAttribute(rdaAnnot, elemAttrs);
                this.fillInteriorColorAttribute(rdaAnnot, elemAttrs);
                attrInd = XFDFAnnotationRedaction.findAttribute(ATTR_RO, elemAttrs);
                if (attrInd >= 0) {
                    try {
                        String ro = elemAttrs.getValue(attrInd);
                        InputByteStream ibs = null;
                        if (ro == null || ro.length() == 0) break block17;
                        try {
                            ibs = this.pdfDoc.getStreamManager().getInputByteStream(ro.getBytes());
                            PDFXObjectForm xObj = PDFXObjectForm.newInstance(this.pdfDoc, PDFRectangle.newInstance(this.pdfDoc, 0.0, 0.0, 0.0, 0.0), null, ibs);
                            rdaAnnot.setRO(xObj);
                        }
                        finally {
                            if (ibs != null) {
                                ibs.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                }
            }
            if ((attrInd = XFDFAnnotationRedaction.findAttribute(ATTR_OLT, elemAttrs)) >= 0) {
                String olt = elemAttrs.getValue(attrInd);
                rdaAnnot.setOverlayText(olt);
            }
            if ((attrInd = XFDFAnnotationRedaction.findAttribute(ATTR_RPT, elemAttrs)) >= 0) {
                boolean rpt = false;
                if (elemAttrs.getValue(attrInd).toString().equalsIgnoreCase("yes")) {
                    rpt = true;
                }
                rdaAnnot.setRepeat(rpt);
            }
            if ((attrInd = XFDFAnnotationRedaction.findAttribute(ATTR_DA, elemAttrs)) >= 0) {
                String da = elemAttrs.getValue(attrInd);
                rdaAnnot.setDA(da);
            }
            if ((attrInd = XFDFAnnotationRedaction.findAttribute(ATTR_Q, elemAttrs)) >= 0) {
                int justification = Integer.parseInt(elemAttrs.getValue(attrInd));
                rdaAnnot.setJustification(justification);
            }
            if ((attrInd = XFDFAnnotationRedaction.findAttribute("rotation", elemAttrs)) != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                rdaAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    rdaAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(rdaAnnot, gotPage)) {
                this.pdfAnnot = rdaAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

