/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.xfa.Node;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;

public final class SOMExpressionUtils {
    public static String trimSomExpression(String somExpr) {
        StringBuilder acroformSomExpr = new StringBuilder(somExpr.length());
        String[] nodeArray = somExpr.split("\\.", 3);
        if (nodeArray.length > 1 && nodeArray[0].equalsIgnoreCase("xfa[0]") && (nodeArray[1].equalsIgnoreCase("template[0]") || nodeArray[1].equalsIgnoreCase("form[0]"))) {
            for (int i = 2; i < nodeArray.length; ++i) {
                acroformSomExpr.append(nodeArray[i]);
            }
            return acroformSomExpr.toString();
        }
        return somExpr;
    }

    public static String computeSOMName(String somExpression, TemplateModel templateModel) throws PDFInvalidXMLException {
        StringBuilder acroformSomExpr = new StringBuilder();
        try {
            Node node = templateModel.resolveNode(somExpression, false, false, false);
            if (node == null) {
                throw new PDFInvalidXMLException("Unable to find requested node.");
            }
            String somName = node.getSOMExpression();
            String[] nodeArray = somName.split("\\.", 3);
            for (int i = 2; i < nodeArray.length; ++i) {
                acroformSomExpr.append(nodeArray[i]);
            }
        }
        catch (ExFull e) {
            throw new PDFInvalidXMLException(e);
        }
        return acroformSomExpr.toString();
    }
}

