/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler;

import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.ScriptObject;
import com.adobe.internal.pdftoolkit.services.xfa.impl.JavaScriptHandler;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ut.ExFull;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class GibsonLiveObject
extends ScriptableObject {
    private static final long serialVersionUID = -2263492138887058350L;
    private XFAObjectProc getPropProc = null;
    private XFAObjectProc setPropProc = null;
    private XFAObjectProc resolvePropProc = null;
    private AppModel appModel = null;
    public static final String CLASSNAME = "XFAObject";
    private static final Method mInvokeMethod;
    protected transient JavaScriptHandler moHandler;
    protected transient ScriptObject moScriptObj;
    protected transient Obj moXFAObject;

    public GibsonLiveObject(JavaScriptHandler handler, Obj xfaObject, AppModel appModel) {
        this.moXFAObject = xfaObject;
        this.moHandler = handler;
        this.appModel = appModel;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        try {
            if (this.moScriptObj != null) {
                this.moScriptObj.put(name, start, value);
            } else {
                try {
                    this.moXFAObject.setScriptProperty(name, this.moHandler.variantToArg(value), false);
                }
                catch (ExFull oEx) {
                    this.moHandler.throwError(oEx);
                }
            }
        }
        catch (ExFull e) {
            this.handleExceptions(this.setPropProc == XFAObjectProc.Set, e);
        }
        catch (RhinoException e) {
            this.handleExceptions(this.setPropProc == XFAObjectProc.Set, e);
        }
    }

    public static Object invoke(Context cx, Scriptable obj, Object[] args, Function func) {
        GibsonLiveObject oThis = (GibsonLiveObject)obj;
        try {
            DependencyTracker oDependencyTracker = oThis.moHandler.getAppModel().dependencyTracker();
            Arg oRetVal = new Arg();
            String sFunctionName = ((FunctionObject)func).getFunctionName();
            Arg[] oArgs = new Arg[args.length];
            for (int i = 0; i < args.length; ++i) {
                oArgs[i] = oThis.moHandler.variantToArg(args[i]);
            }
            oThis.moXFAObject.invokeFunction(oRetVal, sFunctionName, oArgs, oDependencyTracker, false);
            ScriptDebugger oDebugger = oThis.moHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.resolvedValue(sFunctionName, oRetVal);
            }
            return oThis.moHandler.argToVariant(oRetVal, oThis.appModel);
        }
        catch (ExFull oEx) {
            oThis.moHandler.throwError(oEx);
            return Undefined.instance;
        }
    }

    public void setScriptObject(ScriptObject oScriptObj) {
        this.moScriptObj = oScriptObj;
    }

    public Obj getXFAObject() {
        return this.moXFAObject;
    }

    @Override
    public Object get(String name, Scriptable start) {
        try {
            if (name.equals("Function")) {
                return super.get(name, start);
            }
            if (this.moScriptObj != null) {
                return this.moScriptObj.get(name, start);
            }
            try {
                ScriptFuncObj scriptFuncObj = this.moXFAObject.getScriptMethodInfo(name);
                if (scriptFuncObj != null && !this.moXFAObject.validateUsageFailedIsFatal(scriptFuncObj.getXFAVersion(), scriptFuncObj.getAvailability())) {
                    return new FunctionObject(name, mInvokeMethod, this);
                }
                DependencyTracker oDependencyTracker = this.moHandler.getAppModel().dependencyTracker();
                Arg oArg = new Arg();
                this.moXFAObject.getScriptProperty(oArg, name, oDependencyTracker, false, false);
                this.resolveArg(name, start, oArg);
                ScriptDebugger oDebugger = this.moHandler.getDebugger();
                if (oDebugger != null) {
                    oDebugger.resolvedValue(name, oArg);
                }
                return this.moHandler.argToVariant(oArg, this.appModel);
            }
            catch (ExFull oEx) {
                try {
                    this.moHandler.throwError(oEx);
                    return Scriptable.NOT_FOUND;
                }
                catch (ExFull e) {
                    this.handleExceptions(this.getPropProc == XFAObjectProc.Get, e);
                }
            }
        }
        catch (RhinoException e) {
            this.handleExceptions(this.getPropProc == XFAObjectProc.Get, e);
        }
        return Scriptable.NOT_FOUND;
    }

    private void handleExceptions(boolean suppressExceptions, RuntimeException e) {
        if (!suppressExceptions) {
            throw e;
        }
    }

    protected void resolveArg(String name, Scriptable start, Arg arg) {
        if (arg.getArgType() != 8) {
            return;
        }
        this.moXFAObject = this.moXFAObject.getScriptThis();
        if (name.startsWith("$")) {
            Arg oArg = new Arg();
            this.moXFAObject.getScriptProperty(oArg, name.substring(1), this.moHandler.getAppModel().dependencyTracker(), false, false);
            if (oArg.getArgType() != 8) {
                arg.assign(oArg);
                return;
            }
        }
        if (this.resolvePropProc == XFAObjectProc.Resolve) {
            this.resolve(name, arg);
        } else if (this.resolvePropProc == XFAObjectProc.Resolve28) {
            this.resolve28(name, arg);
        }
    }

    private void resolveImpl(String name, Arg arg) {
        if (!(this.moXFAObject instanceof Node)) {
            return;
        }
        Node poNodeImpl = (Node)this.moXFAObject;
        Node oRetNode = poNodeImpl.resolveNode(name);
        if (oRetNode != null) {
            arg.setObject(oRetNode);
        }
    }

    public Obj getXFAObj() {
        return this.moXFAObject;
    }

    private void resolve28(String name, Arg arg) {
        this.resolveImpl(name, arg);
    }

    private void resolve(String name, Arg arg) {
        Node oContext;
        if (this.moXFAObject == this.appModel) {
            return;
        }
        JavaScriptHandler.XFAObjectMapImpl pObjectMap = this.moHandler.getObjectMap(this.appModel, false);
        if (pObjectMap != null && pObjectMap.bStrictScopeMode() && (oContext = this.appModel.getContext()) != this.moXFAObject) {
            return;
        }
        this.resolveImpl(name, arg);
    }

    public void setSetPropProc(XFAObjectProc setPropProc) {
        this.setPropProc = setPropProc;
    }

    public void setGetPropProc(XFAObjectProc getPropProc) {
        this.getPropProc = getPropProc;
    }

    public void setResolvePropProc(XFAObjectProc resolvePropProc) {
        this.resolvePropProc = resolvePropProc;
    }

    static {
        Method m;
        block2: {
            m = null;
            try {
                m = GibsonLiveObject.class.getMethod("invoke", Context.class, Scriptable.class, Object[].class, Function.class);
            }
            catch (NoSuchMethodException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        mInvokeMethod = m;
    }

    public static enum XFAObjectProc {
        Get28,
        Get,
        Set28,
        Set,
        Resolve28,
        Resolve;

    }
}

