/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.WSDLConnectionSetProxy;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.EventPseudoModel;
import com.adobe.xfa.Node;
import com.adobe.xfa.connectionset.ConnectionSetModel;
import com.adobe.xfa.connectionset.proxies.ConnectionSetProxy;
import com.adobe.xfa.connectionset.proxies.WSDLConnectionSetProxy;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.soap.SOAP;

public class Execute
extends FormModel.Execute
implements WSDLConnectionSetProxy.ConnectionSetProxyHandler {
    private DocumentContext moDocContext;

    public Execute(DocumentContext oDocContext) {
        this.moDocContext = oDocContext;
    }

    @Override
    public Object clone() {
        return new Execute(this.moDocContext);
    }

    @Override
    public void execute(String sConnection, int meRunAt, int meExecuteType) {
        FormModel oFormModel = this.moDocContext.getFormModel();
        AppModel oAppModel = oFormModel.getAppModel();
        ConnectionSetModel oConnectionSetModel = ConnectionSetModel.getConnectionSetModel(oAppModel, false);
        if (oConnectionSetModel == null) {
            return;
        }
        for (Node oNode = oConnectionSetModel.getFirstXFAChild(); oNode != null; oNode = oNode.getNextXFASibling()) {
            String sName;
            if (!oNode.isSameClass("wsdlConnection") || !(sName = oNode.getName()).equals(sConnection)) continue;
            if (meExecuteType == 0x600001) {
                oConnectionSetModel.execute(oNode.getName(), true);
                this.moDocContext.enumFields(DocumentContext.EnumFieldsCode.UPDATE_BOTH);
                continue;
            }
            oConnectionSetModel.execute(oNode.getName(), false);
        }
    }

    @Override
    public void handleProxy(ConnectionSetProxy oProxy, WSDLConnectionSetProxy.Notifications eNotice, SOAP oSOAPModel, Object handlerData) {
        DocumentContext oDocumentContext = (DocumentContext)handlerData;
        AppModel oAppModel = oDocumentContext.getFormModel().getAppModel();
        EventPseudoModel oEvent = (EventPseudoModel)oAppModel.lookupPseudoModel("$event");
        EventPseudoModel.EventInfo oEventInfo = null;
        if (oEvent != null) {
            oEventInfo = oEvent.getEventInfo();
        }
        if (eNotice == WSDLConnectionSetProxy.Notifications.PREEXECUTE) {
            if (oProxy instanceof WSDLConnectionSetProxy) {
                WSDLConnectionSetProxy oWSDLProxy = (WSDLConnectionSetProxy)oProxy;
                oDocumentContext.eventOccurred(4915218, oWSDLProxy.getWSDLConnectionNode(), oEventInfo);
            }
        } else if (eNotice == WSDLConnectionSetProxy.Notifications.POSTEXECUTE) {
            if (oSOAPModel.getFaultNode() != null) {
                oEventInfo.setSOAPFaultCode(oSOAPModel.getFaultCode());
                oEventInfo.setSOAPFaultString(oSOAPModel.getFaultString());
            }
            if (oProxy instanceof WSDLConnectionSetProxy) {
                WSDLConnectionSetProxy oWSDLProxy = (WSDLConnectionSetProxy)oProxy;
                oDocumentContext.eventOccurred(4915219, oWSDLProxy.getWSDLConnectionNode(), oEventInfo);
            }
        }
    }
}

