/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.form.CosDocument;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Node;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.TemplateModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class XFADOM {
    protected AppModel appModel = null;
    protected ConfigurationModel configurationModel = null;
    protected TemplateModel templateModel = null;
    protected DataModel dataModel = null;
    protected FormModel formModel = null;
    protected PDFDocument pdfDocument;
    protected boolean mDirty = false;
    protected List<String> dirtyPackets = null;

    protected XFADOM() {
    }

    XFADOM(PDFDocument pdfDoc, DocumentContext xfaDocumentContext) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDocument = pdfDoc;
        this.populateXFADOMS(xfaDocumentContext);
    }

    private void clearIteratedSignatureFieldsList() {
        XFADOMServiceListener xfaDOMServiceListener;
        if (this.formModel != null && (xfaDOMServiceListener = (XFADOMServiceListener)this.pdfDocument.getListenerRegistry().getListener(XFADOMServiceListener.class)) != null) {
            xfaDOMServiceListener.clearIteratedSignatureFieldsList();
        }
    }

    XFADOM(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFInvalidXMLException, PDFIOException, PDFSecurityException {
        this.pdfDocument = pdfDoc;
        this.appModel = new AppModel(null);
        Document xfaDoc = new Document(this.appModel);
        DocumentContext.addModelFactoriesToAppModel(this.appModel, pdfDoc, null);
        InputByteStream xfaStream = null;
        try {
            xfaStream = PDFFormSupport.getFullXFAStream(pdfDoc.getInteractiveForm());
            if (xfaStream != null) {
                this.loadXFADoc(xfaDoc, xfaStream);
                if (!CosDocument.isXFADoc(pdfDoc, xfaDoc, null, false, false, true)) {
                    throw new PDFInvalidDocumentException("This is an error with XFA packets : Either duplicate XFA packets are present OR template packet doesn't exist.");
                }
                this.templateModel = TemplateModel.getTemplateModel(this.appModel, false);
                this.configurationModel = ConfigurationModel.getConfigurationModel(this.appModel, false);
                this.dataModel = DataModel.getDataModel(this.appModel, false, false);
                this.formModel = FormModel.getFormModel(this.appModel, false);
                this.clearIteratedSignatureFieldsList();
            } else {
                this.appModel = null;
            }
        }
        catch (PDFIOException e) {
            this.appModel = null;
        }
        catch (PDFSecurityException e) {
            this.appModel = null;
        }
        catch (PDFInvalidXMLException e) {
            this.appModel = null;
            throw e;
        }
        finally {
            try {
                if (xfaStream != null) {
                    xfaStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDocument;
    }

    public Document getXFADocument() {
        return this.appModel.getDocument();
    }

    void populateXFADOMS(DocumentContext xfaDocumentContext) throws PDFInvalidParameterException {
        if (xfaDocumentContext == null) {
            throw new PDFInvalidParameterException("Null xfa document");
        }
        this.appModel = xfaDocumentContext.moAppModel;
        this.templateModel = TemplateModel.getTemplateModel(this.appModel, false);
        this.configurationModel = ConfigurationModel.getConfigurationModel(this.appModel, false);
        this.dataModel = DataModel.getDataModel(this.appModel, false, false);
        this.formModel = FormModel.getFormModel(this.appModel, false);
        this.clearIteratedSignatureFieldsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXFADoc(Document xfaDoc, InputByteStream xfaStream) throws PDFIOException, PDFInvalidXMLException {
        InputStream inputStream = null;
        try {
            inputStream = xfaStream.toInputStream();
            xfaDoc.load(inputStream, "UTF-8", false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                this.appModel.cleanDirtyFlags();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    public void setAppModel(AppModel appModel) {
        this.appModel = appModel;
    }

    public ConfigurationModel getConfigurationModel() {
        return this.configurationModel;
    }

    public void setConfigurationModel(ConfigurationModel configurationModel) {
        this.configurationModel = configurationModel;
    }

    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(TemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
        this.clearIteratedSignatureFieldsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormModel createFormModel() throws PDFInvalidParameterException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        XFAProcessingOptions xfaProcessingOptions = XFADOMService.getXFAProcessingOptions(this.pdfDocument);
        DocumentContext xfaDocumentContext = null;
        try {
            xfaDocumentContext = XFADOMService.createXFADocumentContext(this.pdfDocument, false, DocModAnalyzerParams.DocModAnalysisMode.MDPAllowDefaultPlusComments, xfaProcessingOptions);
            this.populateXFADOMS(xfaDocumentContext);
            FormModel formModel = this.formModel;
            return formModel;
        }
        finally {
            if (xfaDocumentContext != null) {
                xfaDocumentContext.destroy();
            }
        }
    }

    public boolean formModelExists() {
        if (this.appModel != null) {
            return FormModel.getFormModel(this.appModel, false) != null;
        }
        return false;
    }

    public boolean isChanged() {
        return this.mDirty;
    }

    public void setChanged() {
        this.mDirty = true;
    }

    public void clearChanged() {
        this.mDirty = false;
        this.appModel.cleanDirtyFlags();
    }

    public void savePacketsDirtyState() {
        this.dirtyPackets = new ArrayList<String>();
        for (Node oNext = this.appModel.getFirstXMLChild(); oNext != null; oNext = oNext.getNextXMLSibling()) {
            if (!oNext.isDirty()) continue;
            this.dirtyPackets.add(oNext.getName());
        }
    }

    public void restorePacketsDirtyState() {
        if (this.dirtyPackets == null || this.dirtyPackets.isEmpty()) {
            return;
        }
        for (Node oNext = this.appModel.getFirstXMLChild(); oNext != null; oNext = oNext.getNextXMLSibling()) {
            if (!this.dirtyPackets.contains(oNext.getName())) continue;
            oNext.setDirty();
        }
        this.dirtyPackets = null;
    }
}

