/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf.utils;

import com.adobe.internal.io.stream.BitInputStream;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.services.swf.utils.ShapeHelper;
import com.adobe.internal.pdftoolkit.services.swf.utils.TypeHelper;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineTag;
import flash.swf.types.FillStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ImageHelper {
    public static DefineShape createShapeForImage(DefineBits tag, double width, double height) {
        if (Double.isNaN(width)) {
            width = tag.width;
        }
        if (Double.isNaN(height)) {
            height = tag.height;
        }
        Matrix matrix = new Matrix();
        matrix.scaleX = 0x140000;
        matrix.scaleY = 0x140000;
        matrix.hasScale = true;
        matrix.scaleX = (int)StrictMath.rint(width * 20.0 * 65536.0 / (double)tag.width);
        matrix.scaleY = (int)StrictMath.rint(height * 20.0 * 65536.0 / (double)tag.height);
        FillStyle fs = new FillStyle(65, matrix, (DefineTag)tag);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.fillstyles = new ArrayList(1);
        sws.fillstyles.add(fs);
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(width, height);
        ShapeHelper.setStyles(shapeRecords, 0, 1, 0, true);
        sws.shapeRecords = shapeRecords;
        DefineShape defineShape = new DefineShape(83);
        defineShape.edgeBounds = defineShape.bounds = TypeHelper.rect(width, height);
        defineShape.shapeWithStyle = sws;
        return defineShape;
    }

    public static DefineBits createDefineBits(ARGBImage image, ARGBImage sMask, boolean isImageMask, int fillRGBValue) throws IOException {
        return ImageHelper.createDefineBitsLossless(image, sMask, isImageMask, fillRGBValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefineBitsLossless createDefineBitsLossless(ARGBImage image, ARGBImage sMask, boolean isImageMask, int fillRGBValue) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless(36);
        defineBitsLossless.format = 5;
        defineBitsLossless.width = width;
        defineBitsLossless.height = height;
        defineBitsLossless.data = new byte[width * height * 4];
        int rightBitShiftingToGetAlpha = sMask != null ? 0 : 24;
        int offset = 0;
        int pixel = 0;
        boolean[] mask = isImageMask ? image.getMask() : null;
        BitInputStream maskInputStream = null;
        int bitPadding = 0;
        if (isImageMask && mask == null) {
            maskInputStream = image.getImageBitInputStream();
            mask = new boolean[width * height];
            bitPadding = 8 - width % 8;
            bitPadding = bitPadding == 8 ? 0 : bitPadding;
        }
        try {
            Iterator<BufferedImage> imageItr = isImageMask ? null : image.getBufferedImagesIterator();
            Iterator<BufferedImage> sMaskItr = sMask != null ? sMask.getBufferedImagesIterator() : null;
            BufferedImage imageTile = imageItr != null && imageItr.hasNext() ? imageItr.next() : null;
            BufferedImage sMaskTile = sMaskItr != null && sMaskItr.hasNext() ? sMaskItr.next() : null;
            int y = 0;
            int ih = 0;
            int sh = 0;
            while (y < height) {
                if (imageTile != null && ih == imageTile.getHeight()) {
                    ih = 0;
                    BufferedImage bufferedImage = imageTile = imageItr.hasNext() ? imageItr.next() : null;
                }
                if (sMaskTile != null && sh == sMaskTile.getHeight()) {
                    sh = 0;
                    sMaskTile = sMaskItr.hasNext() ? sMaskItr.next() : null;
                }
                for (int x = 0; x < width; ++x) {
                    int index = y * width + x;
                    offset = index * 4;
                    if (isImageMask) {
                        if (maskInputStream != null) {
                            boolean bl = mask[index] = maskInputStream.read(1) != 1;
                        }
                        pixel = mask[index] ? fillRGBValue : 0;
                    } else {
                        pixel = ((DataBufferInt)imageTile.getRaster().getDataBuffer()).getData()[ih * width + x];
                    }
                    int alpha = (sMask != null ? ((DataBufferInt)sMaskTile.getRaster().getDataBuffer()).getData()[sh * width + x] : pixel) >> rightBitShiftingToGetAlpha & 0xFF;
                    defineBitsLossless.data[offset] = (byte)alpha;
                    if (alpha == 0) continue;
                    int red = pixel >> 16 & 0xFF;
                    defineBitsLossless.data[offset + 1] = (byte)(red * alpha / 255);
                    int green = pixel >> 8 & 0xFF;
                    defineBitsLossless.data[offset + 2] = (byte)(green * alpha / 255);
                    int blue = pixel & 0xFF;
                    defineBitsLossless.data[offset + 3] = (byte)(blue * alpha / 255);
                }
                if (bitPadding != 0 && maskInputStream != null) {
                    maskInputStream.skip(bitPadding);
                }
                ++y;
                ++ih;
                ++sh;
            }
            image.setMask(mask);
            DefineBitsLossless defineBitsLossless2 = defineBitsLossless;
            return defineBitsLossless2;
        }
        finally {
            if (maskInputStream != null) {
                maskInputStream.close();
            }
        }
    }

    public static DefineShape create9SlicedShape(DefineBits bitmap, Rect r, double width, double height) {
        if (Double.isNaN(width)) {
            width = bitmap.width;
        }
        if (Double.isNaN(height)) {
            height = bitmap.height;
        }
        int slt = r.xMin;
        int srt = r.xMax;
        int stt = r.yMin;
        int sbt = r.yMax;
        ArrayList<Object> shapeRecords = new ArrayList<Object>(50);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.fillstyles = new ArrayList(9);
        sws.shapeRecords = shapeRecords;
        Matrix matrix = new Matrix();
        matrix.scaleX = 0x140000;
        matrix.scaleY = 0x140000;
        matrix.hasScale = true;
        for (int i = 0; i < 9; ++i) {
            FillStyle fs = new FillStyle(66, matrix, (DefineTag)bitmap);
            sws.fillstyles.add(fs);
        }
        int dxa = slt;
        int dxb = srt - slt;
        int dxc = bitmap.width * 20 - srt;
        int dya = stt;
        int dyb = sbt - stt;
        int dyc = bitmap.height * 20 - sbt;
        shapeRecords.add(new StyleChangeRecord(0, dya, 0, 0, 1));
        shapeRecords.add(new StraightEdgeRecord(0, -dya));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 2));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 3));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 0, 6));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 0, 9));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StraightEdgeRecord(-dxc, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 8));
        shapeRecords.add(new StraightEdgeRecord(-dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 7));
        shapeRecords.add(new StraightEdgeRecord(-dxa, 0));
        shapeRecords.add(new StraightEdgeRecord(0, -dyc));
        shapeRecords.add(new StyleChangeRecord(0, 0, 4));
        shapeRecords.add(new StraightEdgeRecord(0, -dyb));
        shapeRecords.add(new StyleChangeRecord(dxa, 0, 0, 2, 1));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 5, 4));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 8, 7));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StyleChangeRecord(dxa + dxb, 0, 0, 3, 2));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 6, 5));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 9, 8));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StyleChangeRecord(0, dya, 0, 1, 4));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 2, 5));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 3, 6));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        shapeRecords.add(new StyleChangeRecord(0, dya + dyb, 0, 4, 7));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 5, 8));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 6, 9));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        DefineShape shape = new DefineShape(83);
        shape.edgeBounds = shape.bounds = TypeHelper.rect(width, height);
        shape.shapeWithStyle = sws;
        return shape;
    }
}

