/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.HiddenContentManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PixelInfo {
    List<Integer> contentItemsWithEffect = new ArrayList<Integer>();
    int currentColor;
    int backgroundColor = -1;
    int backgroundColorIndex = -1;

    PixelInfo() {
    }

    void put(int color, int currentContentIndex, HiddenContentManager.ContentEffect effect, ContentType contentType) {
        this.currentColor = color;
        if (color == this.backgroundColor) {
            int index = -1;
            Iterator<Integer> itr = this.contentItemsWithEffect.iterator();
            while (itr.hasNext()) {
                itr.next();
                if (++index <= this.backgroundColorIndex) continue;
                itr.remove();
            }
            return;
        }
        if (effect == HiddenContentManager.ContentEffect.Complete) {
            this.contentItemsWithEffect.clear();
            this.backgroundColor = -1;
            this.backgroundColorIndex = -1;
        }
        this.contentItemsWithEffect.add(currentContentIndex);
        if (contentType == ContentType.Path || contentType == ContentType.Image) {
            this.backgroundColor = color;
            this.backgroundColorIndex = this.contentItemsWithEffect.size() - 1;
        }
    }

    List<Integer> getItemsList() {
        return this.contentItemsWithEffect;
    }

    int getColor() {
        return this.currentColor;
    }
}

