/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryption;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.formflattener.FormFlattener;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class PDFOptimizer {
    private static final ASName[] catalogPrivateKeys = new ASName[]{ASName.create("FICL:Enfocus"), ASName.create("QITE_cache_2"), ASName.create("CSML:PProt"), ASName.create("CREO:PageletPreferences"), ASName.create("CREO_ViewAlternatesExist"), ASName.create("CREO_AlternateDocSize"), ASName.create("CAPT_Info"), ASName.create("AGFA_CMYKCCN"), ASName.create("AGFA_NORN_V"), ASName.create("AGFA_PSE_V"), ASName.create("DGAPChanges"), ASName.create("DLPrintSelect")};
    private static final ASName[] pagePrivateKeys = new ASName[]{ASName.k_LastModified, ASName.create("QITE_internal"), ASName.create("QITE_imposed_1"), ASName.create("QITE_pageid"), ASName.create("QInserted"), ASName.create("CAPT_Info"), ASName.create("OneVisionPageColorsInfo"), ASName.create("LGIDict"), ASName.create("AGFA_Duotone"), ASName.create("CREO_Tools"), ASName.create("CREO_Orientation"), ASName.create("CREO_ScaleFactor"), ASName.create("DLPrintSelect"), ASName.create("HDAG_Tools"), ASName.create("CSML:PProt"), ASName.create("CSML:PProtC")};

    private PDFOptimizer() {
    }

    static void doRootLevelOptimization(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFViewerPreferences viewerPref;
        PDFOptimizer.detect17E1Incompatibilities(pdfDoc);
        PDFCatalog catalog = pdfDoc.requireCatalog();
        catalog.setMetadata(null);
        catalog.setPieceInfo(null);
        catalog.setBookmarkRoot(null);
        catalog.setAdditionalActions(null);
        catalog.setOpenAction(null);
        PDFNameDictionary names = catalog.getNameDictionary();
        if (names != null) {
            names.setNamedDestinations(null);
            names.setNamedJavaScripts(null);
        }
        if ((viewerPref = catalog.getViewerPreferences()) != null) {
            viewerPref.setPrintScaling(null);
            viewerPref.setDuplex(null);
            viewerPref.setPickTrayByPDFSize(null);
            viewerPref.setPrintPageRange(null);
            viewerPref.setNumCopies(null);
        }
        for (int i = 0; i < catalogPrivateKeys.length; ++i) {
            catalog.getCosDictionary().remove(catalogPrivateKeys[i]);
        }
    }

    static void doPageLevelOptimization(PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        FormFlattener.flattenPage(null, pdfPage.getPDFDocument(), pdfPage, null, false);
        pdfPage.setAnnotationList(null);
        pdfPage.setThumbnail(null);
        pdfPage.setAdditionalActions(null);
        pdfPage.setStructParents(null);
        pdfPage.setPieceInfo(null);
        for (int i = 0; i < pagePrivateKeys.length; ++i) {
            pdfPage.getCosDictionary().remove(pagePrivateKeys[i]);
        }
    }

    static void doCosLevelOptimization(CosObject cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosStream stream;
        CosDictionary dict;
        CosObject metadata;
        if (cosObj instanceof CosDictionary && (metadata = (dict = (CosDictionary)cosObj).get(ASName.k_Metadata)) != null && metadata.getType() == 7) {
            dict.remove(ASName.k_Metadata);
        }
        if (cosObj.getType() == 7 && PDFOptimizer.hasLZWDecodeFilter(stream = (CosStream)cosObj)) {
            CosArray filters = stream.getDocument().createCosArray();
            CosArray filter = stream.getDocument().createCosArray();
            filter.addName(ASName.k_FlateDecode);
            filter.add(stream.getDocument().createCosNull());
            filters.add(filter);
            try {
                stream.setOutputFiltersList(filters);
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    static void doPostOptimization(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = pdfDoc.requireCatalog();
        PDFInteractiveForm acroform = catalog.getInteractiveForm();
        if (acroform != null) {
            acroform.setChildren(null);
        }
        catalog.setStructureRoot(null);
        catalog.setOCProperties(null);
        PDFMarkInfo markInfo = catalog.getMarkInfo();
        if (markInfo != null) {
            markInfo.setMarked(null);
            markInfo.setUserProperties(null);
        }
    }

    static void doXObjectOptimization(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        xObject.removeValue(ASName.k_StructParent);
        xObject.removeValue(ASName.k_StructParents);
        if (xObject instanceof PDFXObjectImage) {
            ((PDFXObjectImage)xObject).setAlternatesList(null);
        } else if (xObject instanceof PDFXObjectForm) {
            ((PDFXObjectForm)xObject).setPieceInfo(null);
        }
    }

    private static boolean hasLZWDecodeFilter(CosStream stream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray inputFilters = stream.getInputFiltersList();
        Iterator<CosObject> filtersItr = inputFilters.iterator();
        CosArray filterWithParams = null;
        while (filtersItr.hasNext()) {
            filterWithParams = (CosArray)filtersItr.next();
            if (filterWithParams.getName(0) != ASName.k_LZWDecode) continue;
            return true;
        }
        return false;
    }

    static void addContentDelimiter(ContentWriter contentWriter) {
        contentWriter.setInstructionDelimiter(32);
    }

    static void detect17E1Incompatibilities(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dict;
        Integer version;
        PDFEncryption pdfEncryption = pdfDoc.getEncryption();
        if (pdfEncryption == null) {
            return;
        }
        if (pdfEncryption.getDictionaryNameValue(ASName.k_Filter) == ASName.k_Standard && (version = pdfEncryption.getDictionaryIntValue(ASName.k_R)) != null && version <= 4) {
            return;
        }
        Integer algorithmUsed = pdfEncryption.getDictionaryIntValue(ASName.k_V);
        if (algorithmUsed == null) {
            return;
        }
        if (algorithmUsed > 4 && (dict = pdfEncryption.getDictionaryDictionaryValue(ASName.k_CF)) != null) {
            Iterator<ASName> keyItr = dict.keyIterator();
            ASName key = null;
            CosObject value = null;
            ASName cfmObj = null;
            while (keyItr.hasNext()) {
                key = keyItr.next();
                value = dict.get(key);
                if (!(value instanceof CosDictionary) || (cfmObj = ((CosDictionary)value).getName(ASName.k_CFM)) != ASName.k_AESV3) continue;
                throw new PDFSecurityException("Sanitization could not be performed because it's encrypted with some non-permitted parameters.");
            }
        }
    }

    static boolean fitLinesToBezierCurves(List<ASCoordinate> currentPath, List<Instruction> pathInstructions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SanitizationUtils.fitLinesToBezierCurves(currentPath, pathInstructions);
    }
}

