/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.RadialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.content.processor.Path;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class RasterRadialShading
extends RadialShadingPattern<RasterGraphicsState, RasterTextState, RasterContentItem> {
    protected GeneralPath currentPath = null;
    protected ASMatrix ctm;
    protected int DEFAULT_COLOR_VARIATION_NUMBER = 10;
    private static Integer id;
    private static RasterGraphicsState gState;

    public RasterRadialShading(RasterGraphicsState gState, int id) {
        super(gState, id);
        RasterRadialShading.id = new Integer(id);
        RasterRadialShading.gState = gState;
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        this.currentPath = this.getCurrentShadingPath();
        AffineTransform scale_transform = new AffineTransform();
        scale_transform.scale(rasterDocumentContext.getWidthScalingFactor(), rasterDocumentContext.getHeightScalingFactor());
        this.currentPath.transform(scale_transform);
        rasterDocumentContext.getTransformedPath(this.currentPath, rasterDocumentContext.getPageHeight());
        double[][] circleInfo = this.getCircleInfo();
        if (circleInfo == null || circleInfo.length == 0) {
            circleInfo = new double[1][2];
        }
        if (this.ctm == null) {
            this.ctm = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        if (!rasterDocumentContext.getIsScaled()) {
            circleInfo[0][0] = this.ctm.getx();
            circleInfo[0][1] = (double)rasterDocumentContext.getPageHeight() - this.ctm.gety();
        } else {
            circleInfo[0][0] = this.ctm.getx() * rasterDocumentContext.getWidthScalingFactor();
            circleInfo[0][1] = (double)rasterDocumentContext.getPageHeight() - this.ctm.gety() * rasterDocumentContext.getHeightScalingFactor();
        }
        AffineTransform transform = new AffineTransform(this.ctm.geta(), this.ctm.getc(), this.ctm.getb(), this.ctm.getd(), this.ctm.getx(), this.ctm.gety());
        this.postProcessing(this.getHeight(), this.getWidth(), rasterDocumentContext.getGraphics2d(), this.currentPath, transform, (int)circleInfo[0][1], ((RasterGraphicsState)this.getGState()).getFillShadingPatternName() != null);
    }

    void postProcessing(int height, int width, Graphics2D graphics2d, GeneralPath currentPath, AffineTransform transform, int pageHight, Boolean fill) {
        Color[] colors = this.getColors();
        double[][] circleInfo = this.getCircleInfo();
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Paint currentPaint = graphics2d.getPaint();
        currentPath = this.getPathForShadingPattern(pageHight, currentPath);
        if (currentPath == null) {
            return;
        }
        if (colors != null) {
            if (this.getIsCircle() && this.getIsSingleCircle()) {
                graphics2d.setColor(colors[0]);
                if (fill.booleanValue()) {
                    graphics2d.fill(currentPath);
                } else {
                    graphics2d.draw(currentPath);
                }
            } else {
                RasterRadialShadingPaint paint = null;
                if (colors.length > 2) {
                    paint = new RasterRadialShadingPaint();
                    paint.setTransform(transform);
                    paint.setCenterX(circleInfo[0][0]);
                    paint.setCenterY(circleInfo[0][1]);
                    graphics2d.setPaint(paint);
                } else if (colors.length == 0) {
                    Color color = new Color(GraphicsUtils.toARGB(((RasterGraphicsState)this.getGState()).getFillColorValues(), ((RasterGraphicsState)this.getGState()).getNonStrokeAlpha()));
                    graphics2d.setColor(color);
                } else {
                    graphics2d.setColor(colors[0]);
                }
                if (fill.booleanValue()) {
                    graphics2d.fill(currentPath);
                } else {
                    graphics2d.draw(currentPath);
                }
            }
        }
        graphics2d.setPaint(currentPaint);
    }

    private GeneralPath getPathForShadingPattern(int pageHight, GeneralPath currentPath) {
        Path boxPath = null;
        ASRectangle box = null;
        if (this.getBBox() != null) {
            try {
                box = new ASRectangle(this.getBBox());
            }
            catch (PDFInvalidParameterException e) {
                e.printStackTrace();
            }
            if (this.getMatrix() != null) {
                box = box.transform(new ASMatrix(this.getMatrix()));
            }
            box = new ASRectangle(box.left(), (double)pageHight - box.bottom(), box.right(), (double)pageHight - box.top());
            try {
                boxPath = new Path(box);
            }
            catch (PDFIOException | PDFInvalidDocumentException | PDFSecurityException e) {
                e.printStackTrace();
            }
            currentPath = boxPath.getPath();
        }
        return currentPath;
    }

    void setCTM(ASMatrix ctm) {
        this.ctm = ctm;
    }

    private double[] getLineIntersectionWithCircleAtShorterDistance(double x0, double y0, double x, double y, double x1, double y1, double r1) {
        if (x0 != x) {
            double m = (y - y0) / (x - x0);
            double c = y0 - m * x0;
            double d = c - y1;
            double A = 1.0 + m * m;
            double B = 2.0 * m * d - 2.0 * x1;
            double C = x1 * x1 + d * d - r1 * r1;
            double discriminant = B * B - 4.0 * A * C;
            double root1X = (-B + Math.sqrt(discriminant)) / (2.0 * A);
            double root1Y = m * root1X + c;
            double root2X = (-B - Math.sqrt(discriminant)) / (2.0 * A);
            double root2Y = m * root2X + c;
            if (this.getDistanceBetweenPoints(x0, y0, root1X, root1Y) < this.getDistanceBetweenPoints(x0, y0, root2X, root2Y)) {
                return new double[]{root1X, root1Y};
            }
            return new double[]{root2X, root2Y};
        }
        double root1Y = y1 + Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        double root2Y = y1 - Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        if (Math.abs(y0 - root1Y) < Math.abs(y0 - root2Y)) {
            return new double[]{x0, root1Y};
        }
        return new double[]{x0, root2Y};
    }

    private double[] getLineIntersectionWithCircleAtLargerDistance(double x0, double y0, double x, double y, double x1, double y1, double r1) {
        if (x0 != x) {
            double m = (y - y0) / (x - x0);
            double c = y0 - m * x0;
            double d = c - y1;
            double A = 1.0 + m * m;
            double B = 2.0 * m * d - 2.0 * x1;
            double C = x1 * x1 + d * d - r1 * r1;
            double discriminant = B * B - 4.0 * A * C;
            double root1X = (-B + Math.sqrt(discriminant)) / (2.0 * A);
            double root1Y = m * root1X + c;
            double root2X = (-B - Math.sqrt(discriminant)) / (2.0 * A);
            double root2Y = m * root2X + c;
            if (this.getDistanceBetweenPoints(x0, y0, root1X, root1Y) > this.getDistanceBetweenPoints(x0, y0, root2X, root2Y)) {
                return new double[]{root1X, root1Y};
            }
            return new double[]{root2X, root2Y};
        }
        double root1Y = y1 + Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        double root2Y = y1 - Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        if (Math.abs(y0 - root1Y) > Math.abs(y0 - root2Y)) {
            return new double[]{x0, root1Y};
        }
        return new double[]{x0, root2Y};
    }

    private double getDistanceBetweenPoints(double x0, double y0, double x1, double y1) {
        return Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
    }

    private double[] getLineIntersectionWithCircle(double x0, double y0, double x, double y, double x1, double y1, double r1) {
        if (x0 != x) {
            double m = (y - y0) / (x - x0);
            double c = y0 - m * x0;
            double d = c - y1;
            double A = 1.0 + m * m;
            double B = 2.0 * m * d - 2.0 * x1;
            double C = x1 * x1 + d * d - r1 * r1;
            double discriminant = B * B - 4.0 * A * C;
            double root1X = (-B + Math.sqrt(discriminant)) / (2.0 * A);
            double root1Y = m * root1X + c;
            double root2X = (-B - Math.sqrt(discriminant)) / (2.0 * A);
            double root2Y = m * root2X + c;
            if ((root1X - x) * (x - x0) >= 0.0) {
                return new double[]{root1X, root1Y};
            }
            return new double[]{root2X, root2Y};
        }
        double root1Y = y1 + Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        double root2Y = y1 - Math.sqrt(r1 * r1 - (x0 - x1) * (x0 - x1));
        if ((root1Y - y) * (y - y0) >= 0.0) {
            return new double[]{x0, root1Y};
        }
        return new double[]{x0, root2Y};
    }

    private double[] getCommonTangentsIntersectionPoint(double x0, double y0, double x1, double y1, double r0, double r1, double c1) {
        double[] pointCoords = new double[2];
        if (x0 != x1) {
            double m = (y1 - y0) / (x1 - x0);
            pointCoords[0] = x0 - c1 * (x1 - x0) / this.getDistanceBetweenPoints(x0, y0, x1, y1);
            pointCoords[1] = y0 - c1 * (y1 - y0) / this.getDistanceBetweenPoints(x0, y0, x1, y1);
        } else {
            pointCoords[0] = x0;
            pointCoords[1] = y0 < y1 ? y0 - c1 : y0 + c1;
        }
        return pointCoords;
    }

    private double getPointToLineDistance(double x, double y, double x0, double y0, double x1, double y1) {
        double d;
        if (x1 != x0) {
            double m = (y1 - y0) / (x1 - x0);
            double c = y1 - y0 - m * (x1 - x0);
            d = Math.abs(m * (x - x0) - (y - y0) + c) / Math.sqrt(m * m + 1.0);
        } else {
            d = Math.abs(x - x0);
        }
        return d;
    }

    private boolean pointLiesBetweenCommonTangents(double x, double y, double x0, double y0, double x1, double y1, double d2, double theta, double d1, double c0PlusC1, double r1, double x2, double y2) {
        double d = this.getPointToLineDistance(x, y, x0, y0, x1, y1);
        if (d2 == 0.0 || d / d2 <= Math.sin(theta)) {
            if (x2 != x0) {
                return (x0 - x2) * (x - x2) > 0.0;
            }
            return (y0 - y2) * (y - y2) > 0.0;
        }
        return false;
    }

    private boolean pointLiesBetweenParallelTangents(double x, double y, double x0, double y0, double x1, double y1, double r) {
        if (x1 != x0) {
            double m = (y1 - y0) / (x1 - x0);
            double c = y1 - y0 - m * (x1 - x0);
            double d = Math.abs(m * (x - x0) - (y - y0) + c) / Math.sqrt(m * m + 1.0);
            return d <= r;
        }
        double d = Math.abs(x - x0);
        return d <= r;
    }

    private void setPixelColorValues(int[] pixelsData, int index, Color[] colorsValue, int colorValueIndex) {
        double[] background = this.getBackground();
        int index3 = 255;
        if (background == null) {
            background = new double[3];
            index3 = 0;
        }
        if (colorValueIndex == -1 || colorValueIndex > colorsValue.length - 2) {
            pixelsData[index] = (int)(255.0 * background[0]);
            pixelsData[index + 1] = (int)(255.0 * background[1]);
            pixelsData[index + 2] = (int)(255.0 * background[2]);
            pixelsData[index + 3] = index3;
        } else if (colorsValue[colorValueIndex] != null) {
            pixelsData[index] = colorsValue[colorValueIndex].getRed();
            pixelsData[index + 1] = colorsValue[colorValueIndex].getGreen();
            pixelsData[index + 2] = colorsValue[colorValueIndex].getBlue();
            pixelsData[index + 3] = 255;
        }
    }

    private double[] reverseTransform(double currX0, double currY0, AffineTransform transform) {
        double[] coords = new double[2];
        double a = transform.getScaleX();
        double b = transform.getShearX();
        double c = transform.getShearY();
        double d = transform.getScaleY();
        coords[0] = (d * currX0 - c * currY0) / (a * d - b * c);
        coords[1] = (a * currY0 - b * currX0) / (a * d - b * c);
        return coords;
    }

    private class RasterRadialShadingPaintContext
    implements PaintContext {
        AffineTransform transform;
        ColorModel colorModel;
        double centerX;
        double centerY;
        double x0;
        double y0;
        double x1;
        double y1;
        double r0;
        double r1;
        double curX;
        double curY;
        double d0_Squared;
        double d1_Squared;
        double c0_Squared;
        double c0;
        double d0;
        double d1;
        int index;
        int tableLen;
        final int STARTING_COLOR_INDEX = 0;
        final int NO_FILL_COLOR_INDEX = -1;
        int ENDING_COLOR_INDEX = 0;
        int[] pixelsData;
        Color[] colorsValue;

        public RasterRadialShadingPaintContext(AffineTransform Tx, ColorModel colorModel, double centerX, double centerY) {
            this.transform = new AffineTransform(Tx);
            this.colorModel = colorModel;
            this.centerX = centerX;
            this.centerY = centerY;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            int[] pixelsData = new int[w * h * 4];
            this.pixelsData = pixelsData;
            double currX = 0.0;
            double currY = 0.0;
            this.colorsValue = RasterRadialShading.this.getColors();
            double[] coords = RasterRadialShading.this.getCoordinates();
            this.x0 = coords[0];
            this.y0 = coords[1];
            this.r0 = coords[2];
            this.x1 = coords[3];
            this.y1 = coords[4];
            this.r1 = coords[5];
            if (this.r0 == 0.0 && this.r1 == 0.0) {
                return raster;
            }
            boolean isOnlyShading = true;
            double[] matrix = RasterRadialShading.this.getMatrix();
            if (matrix != null) {
                isOnlyShading = false;
            }
            double[] radialDomain = RasterRadialShading.this.getDomain();
            double t0 = 0.0;
            double t1 = 1.0;
            if (radialDomain != null) {
                t0 = radialDomain[0];
                t1 = radialDomain[1];
            }
            if (t0 == 0.0 && t1 == 0.0) {
                return raster;
            }
            this.tableLen = this.colorsValue.length;
            this.ENDING_COLOR_INDEX = this.tableLen - 2;
            for (int yindex = 0; yindex < h; ++yindex) {
                for (int xindex = 0; xindex < w; ++xindex) {
                    currX = xindex + x;
                    currY = yindex + y;
                    if (isOnlyShading) {
                        currX -= this.centerX;
                        currY -= this.centerY;
                        currY *= -1.0;
                    } else {
                        currX -= this.transform.getTranslateX();
                        currY = currY - this.transform.getTranslateY() + (double)((this.x0 != this.x1 || this.y0 != this.y1) && this.r0 != this.r1 ? 100 : 50);
                        double midPoint = this.getMidYcordPointBetweentTwoCircle();
                        currY = -currY + 2.0 * midPoint;
                    }
                    double[] reverseTransformPoint = RasterRadialShading.this.reverseTransform(currX, currY, this.transform);
                    this.curX = reverseTransformPoint[0];
                    this.curY = reverseTransformPoint[1];
                    this.calculateVariables();
                    this.index = (yindex * w + xindex) * 4;
                    if (this.c0 <= Math.abs(this.r1 - this.r0)) {
                        if (this.r0 <= this.r1) {
                            pixelsData = this.setSphericalShadingColorsWithBiggerR1();
                            continue;
                        }
                        pixelsData = this.setSphericalShadingColorsWithBiggerR0();
                        continue;
                    }
                    pixelsData = this.c0 >= this.r0 + this.r1 ? this.setConicalShadingColorsForNonIntersectingCircles() : (this.r1 > this.r0 ? this.setConicalShadingColorsForIntersectingCirclesWithBiggerR1() : (this.r0 > this.r1 ? this.setConicalShadingColorsForIntersectingCirclesWithBiggerR0() : this.setConicalShadingColorsForIntersectingCirclesWithEqualRadii()));
                }
            }
            raster.setPixels(0, 0, w, h, pixelsData);
            return raster;
        }

        private void calculateVariables() {
            this.d1_Squared = (this.curX - this.x1) * (this.curX - this.x1) + (this.curY - this.y1) * (this.curY - this.y1);
            this.d0_Squared = (this.curX - this.x0) * (this.curX - this.x0) + (this.curY - this.y0) * (this.curY - this.y0);
            this.d0 = Math.sqrt(this.d0_Squared);
            this.d1 = Math.sqrt(this.d1_Squared);
            this.c0_Squared = (this.x1 - this.x0) * (this.x1 - this.x0) + (this.y1 - this.y0) * (this.y1 - this.y0);
            this.c0 = Math.sqrt(this.c0_Squared);
        }

        private double getMidYcordPointBetweentTwoCircle() {
            double[] arr = new double[]{this.y0 + this.r0, this.y0 - this.r0, this.y1 + this.r1, this.y1 - this.r1};
            double max = -1.7976931348623157E308;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < 4; ++i) {
                if (arr[i] < min) {
                    min = arr[i];
                }
                if (!(arr[i] > max)) continue;
                max = arr[i];
            }
            return min + (max - min) / 2.0;
        }

        private int[] setConicalShadingColorsForIntersectingCirclesWithEqualRadii() {
            if (RasterRadialShading.this.pointLiesBetweenParallelTangents(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1, this.r0)) {
                if (this.d0 <= this.r0 && this.d1 <= this.r1) {
                    if (RasterRadialShading.this.getIsExtendBefore()) {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                    } else {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                    }
                } else if (this.d1 <= this.r1) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else if (this.d1 > this.r1 && this.d0 * this.d0 > this.c0 * this.c0 + this.r1 * this.r1 && this.d1 < this.d0) {
                    if (RasterRadialShading.this.getIsExtendAfter()) {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                    } else {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                    }
                } else if (this.d0 > this.r0 && this.d1 * this.d1 > this.c0 * this.c0 + this.r0 * this.r0) {
                    if (RasterRadialShading.this.getIsExtendBefore()) {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                    } else {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                    }
                } else {
                    double pointToCentralLineDistance = RasterRadialShading.this.getPointToLineDistance(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1);
                    double theta = Math.asin(pointToCentralLineDistance / this.r0);
                    double base0 = Math.sqrt(this.d0_Squared - pointToCentralLineDistance * pointToCentralLineDistance);
                    double s = this.x1 != this.x0 && (this.curX - this.x0) * (this.x1 - this.x0) >= 0.0 || this.x1 == this.x0 && (this.curY - this.y0) * (this.y1 - this.y0) > 0.0 ? (base0 + this.r0 * Math.cos(theta)) / this.c0 : (this.r0 * Math.cos(theta) - base0) / this.c0;
                    int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
            return this.pixelsData;
        }

        private int[] setConicalShadingColorsForIntersectingCirclesWithBiggerR0() {
            double c1 = this.c0 * this.r1 / (this.r0 - this.r1);
            double theta = Math.asin(this.r1 / c1);
            double[] commonTangentsIntersectionPoint = RasterRadialShading.this.getCommonTangentsIntersectionPoint(this.x1, this.y1, this.x0, this.y0, this.r1, this.r0, c1);
            double x2 = commonTangentsIntersectionPoint[0];
            double y2 = commonTangentsIntersectionPoint[1];
            double d2_Squared = (this.curX - x2) * (this.curX - x2) + (this.curY - y2) * (this.curY - y2);
            double d2 = Math.sqrt(d2_Squared);
            if (this.d0 <= this.r0 && this.d1 <= this.r1) {
                if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else if (this.d1 <= this.r1 && this.d0 > this.r0) {
                double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircle(this.x0, this.y0, this.curX, this.curY, this.x1, this.y1, this.r1);
                double s = (this.d0 - this.r0) / (RasterRadialShading.this.getDistanceBetweenPoints(this.x0, this.y0, P3[0], P3[1]) - this.r0);
                int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
            } else if (RasterRadialShading.this.pointLiesBetweenCommonTangents(this.curX, this.curY, this.x1, this.y1, this.x0, this.y0, d2, theta, this.d0, this.c0 + c1, this.r0, x2, y2)) {
                if (this.d0 <= this.r0 || d2 * d2 > c1 * c1 - this.r1 * this.r1) {
                    if (this.d0 > this.r0 && d2 * d2 > (this.c0 + c1) * (this.c0 + c1) - this.r0 * this.r0) {
                        if (RasterRadialShading.this.getIsExtendBefore()) {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                        } else {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                        }
                    } else {
                        double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                        double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x0, this.y0, this.r0);
                        double s = 1.0 - (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    }
                } else if (RasterRadialShading.this.getIsExtendAfter()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
            return this.pixelsData;
        }

        private int[] setConicalShadingColorsForIntersectingCirclesWithBiggerR1() {
            double c1 = this.c0 * this.r0 / (this.r1 - this.r0);
            double theta = Math.asin(this.r0 / c1);
            double[] commonTangentsIntersectionPoint = RasterRadialShading.this.getCommonTangentsIntersectionPoint(this.x0, this.y0, this.x1, this.y1, this.r0, this.r1, c1);
            double x2 = commonTangentsIntersectionPoint[0];
            double y2 = commonTangentsIntersectionPoint[1];
            double d2_Squared = (this.curX - x2) * (this.curX - x2) + (this.curY - y2) * (this.curY - y2);
            double d2 = Math.sqrt(d2_Squared);
            if (this.d0 <= this.r0 && this.d1 <= this.r1) {
                if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else if (this.d1 <= this.r1 && this.d0 > this.r0) {
                double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircle(this.x0, this.y0, this.curX, this.curY, this.x1, this.y1, this.r1);
                double s = (this.d0 - this.r0) / (RasterRadialShading.this.getDistanceBetweenPoints(this.x0, this.y0, P3[0], P3[1]) - this.r0);
                int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
            } else if (RasterRadialShading.this.pointLiesBetweenCommonTangents(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1, d2, theta, this.d1, this.c0 + c1, this.r1, x2, y2)) {
                if (this.d0 <= this.r0 || d2 * d2 > c1 * c1 - this.r0 * this.r0) {
                    if (this.d0 > this.r0 && d2 * d2 > (this.c0 + c1) * (this.c0 + c1) - this.r1 * this.r1) {
                        if (RasterRadialShading.this.getIsExtendAfter()) {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                        } else {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                        }
                    } else {
                        double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x0, this.y0, this.r0);
                        double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                        double s = (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    }
                } else if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
            return this.pixelsData;
        }

        private int[] setConicalShadingColorsForNonIntersectingCircles() {
            if (this.r0 == this.r1) {
                this.setConicalShadingColorsForNonIntersectingCirclesWithEqualRadii();
            } else if (this.r0 < this.r1) {
                this.setConicalShadingColorsForNonIntersectingCirclesWithBiggerR1();
            } else {
                this.setConicalShadingColorsForNonIntersectingCirclesWithBiggerR0();
            }
            return this.pixelsData;
        }

        private void setConicalShadingColorsForNonIntersectingCirclesWithBiggerR0() {
            double c1 = this.c0 * this.r1 / (this.r0 - this.r1);
            double theta = Math.asin(this.r1 / c1);
            double[] commonTangentsIntersectionPoint = RasterRadialShading.this.getCommonTangentsIntersectionPoint(this.x1, this.y1, this.x0, this.y0, this.r1, this.r0, c1);
            double x2 = commonTangentsIntersectionPoint[0];
            double y2 = commonTangentsIntersectionPoint[1];
            double d2_Squared = (this.curX - x2) * (this.curX - x2) + (this.curY - y2) * (this.curY - y2);
            double d2 = Math.sqrt(d2_Squared);
            if (this.d1 <= this.r1) {
                if (RasterRadialShading.this.getIsExtendAfter()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else {
                    double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                    double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                    double s = 1.0 - (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                    int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                }
            } else if (RasterRadialShading.this.pointLiesBetweenCommonTangents(this.curX, this.curY, this.x1, this.y1, this.x0, this.y0, d2, theta, this.d0, this.c0 + c1, this.r0, x2, y2)) {
                if (d2 * d2 > c1 * c1 - this.r1 * this.r1) {
                    if (this.d0 > this.r0 && d2 * d2 > (this.c0 + c1) * (this.c0 + c1) - this.r0 * this.r0) {
                        if (RasterRadialShading.this.getIsExtendBefore()) {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                        } else {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                        }
                    } else {
                        double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                        double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x0, this.y0, this.r0);
                        double s = 1.0 - (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    }
                } else if (RasterRadialShading.this.getIsExtendAfter()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
        }

        private void setConicalShadingColorsForNonIntersectingCirclesWithBiggerR1() {
            double c1 = this.c0 * this.r0 / (this.r1 - this.r0);
            double theta = Math.asin(this.r0 / c1);
            double[] commonTangentsIntersectionPoint = RasterRadialShading.this.getCommonTangentsIntersectionPoint(this.x0, this.y0, this.x1, this.y1, this.r0, this.r1, c1);
            double x2 = commonTangentsIntersectionPoint[0];
            double y2 = commonTangentsIntersectionPoint[1];
            double d2_Squared = (this.curX - x2) * (this.curX - x2) + (this.curY - y2) * (this.curY - y2);
            double d2 = Math.sqrt(d2_Squared);
            if (this.d1 <= this.r1) {
                if (RasterRadialShading.this.getIsExtendAfter()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else {
                    double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                    double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtLargerDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                    double s = (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                    int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                }
            } else if (RasterRadialShading.this.pointLiesBetweenCommonTangents(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1, d2, theta, this.d1, this.c0 + c1, this.r1, x2, y2)) {
                if (this.d0 <= this.r0 || d2 * d2 > c1 * c1 - this.r0 * this.r0) {
                    if (d2 * d2 > (this.c0 + c1) * (this.c0 + c1) - this.r1 * this.r1) {
                        if (RasterRadialShading.this.getIsExtendAfter()) {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                        } else {
                            RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                        }
                    } else {
                        double[] P2 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x0, this.y0, this.r0);
                        double[] P3 = RasterRadialShading.this.getLineIntersectionWithCircleAtShorterDistance(x2, y2, this.curX, this.curY, this.x1, this.y1, this.r1);
                        double s = (d2 - RasterRadialShading.this.getDistanceBetweenPoints(x2, y2, P2[0], P2[1])) / RasterRadialShading.this.getDistanceBetweenPoints(P2[0], P2[1], P3[0], P3[1]);
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    }
                } else if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
        }

        private void setConicalShadingColorsForNonIntersectingCirclesWithEqualRadii() {
            if (this.d1 <= this.r1) {
                if (RasterRadialShading.this.getIsExtendAfter()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else if (RasterRadialShading.this.pointLiesBetweenParallelTangents(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1, this.r0)) {
                if (this.d1_Squared > this.c0_Squared + this.r0 * this.r0 && this.d0 > this.r0) {
                    if (RasterRadialShading.this.getIsExtendBefore()) {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                    } else {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                    }
                } else if (this.d0_Squared > this.c0_Squared + this.r1 * this.r1) {
                    if (RasterRadialShading.this.getIsExtendAfter()) {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
                    } else {
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                    }
                } else {
                    double pointToCentralLineDistance = RasterRadialShading.this.getPointToLineDistance(this.curX, this.curY, this.x0, this.y0, this.x1, this.y1);
                    double theta = Math.asin(pointToCentralLineDistance / this.r0);
                    double base0 = Math.sqrt(this.d0_Squared - pointToCentralLineDistance * pointToCentralLineDistance);
                    if (this.d0 <= this.r0) {
                        double s = this.x1 != this.x0 && (this.curX - this.x0) * (this.x1 - this.x0) >= 0.0 || this.x1 == this.x0 && (this.curY - this.y0) * (this.y1 - this.y0) > 0.0 ? (base0 + this.r0 * Math.cos(theta)) / this.c0 : (this.r0 * Math.cos(theta) - base0) / this.c0;
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    } else {
                        double s = (base0 + this.r0 * Math.cos(theta)) / this.c0;
                        int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
                        RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
                    }
                }
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
        }

        private int[] setSphericalShadingColorsWithBiggerR0() {
            double base = (this.d0_Squared - this.c0_Squared - this.d1_Squared) / (2.0 * this.d1);
            double height = Math.sqrt(Math.abs(this.c0_Squared - base * base));
            double D = Math.sqrt(this.r0 * this.r0 - height * height) - base;
            double s = this.d1 <= this.r1 ? -2.0 : (D != this.r1 ? (this.d1 - this.r1) / (D - this.r1) : 2.0);
            int t = (int)((1.0 - s) * (double)this.ENDING_COLOR_INDEX);
            if (s > 1.0) {
                if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else if (s <= 1.0 && s > 0.0) {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
            } else if (RasterRadialShading.this.getIsExtendAfter()) {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
            return this.pixelsData;
        }

        private int[] setSphericalShadingColorsWithBiggerR1() {
            double base = (this.d1_Squared - this.c0_Squared - this.d0_Squared) / (2.0 * this.d0);
            double height = Math.sqrt(Math.abs(this.c0_Squared - base * base));
            double D = Math.sqrt(this.r1 * this.r1 - height * height) - base;
            double s = this.d0 <= this.r0 ? -1.0 : (D != this.r0 ? (this.d0 - this.r0) / (D - this.r0) : 0.0);
            int t = (int)(s * (double)this.ENDING_COLOR_INDEX);
            if (s < 0.0) {
                if (RasterRadialShading.this.getIsExtendBefore()) {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, 0);
                } else {
                    RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
                }
            } else if (s <= 1.0) {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, t);
            } else if (RasterRadialShading.this.getIsExtendAfter()) {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, this.ENDING_COLOR_INDEX);
            } else {
                RasterRadialShading.this.setPixelColorValues(this.pixelsData, this.index, this.colorsValue, -1);
            }
            return this.pixelsData;
        }
    }

    private class RasterRadialShadingPaint
    implements Paint {
        private AffineTransform transform;
        private double centerX;
        private double centerY;

        private RasterRadialShadingPaint() {
        }

        public double getCenterX() {
            return this.centerX;
        }

        public void setCenterX(double centerX) {
            this.centerX = centerX;
        }

        public double getCenterY() {
            return this.centerY;
        }

        public void setCenterY(double centerY) {
            this.centerY = centerY;
        }

        public void setTransform(AffineTransform transform) {
            this.transform = transform;
        }

        @Override
        public int getTransparency() {
            return 0;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            return new RasterRadialShadingPaintContext(this.transform, cm, this.centerX, this.centerY);
        }
    }
}

