/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.color.ColorSpace;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.PDFToRasterConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

final class RasterPerformanceObserver {
    static final boolean isExceptionMode;
    private static final boolean updatePerformanceBaseNumbers;
    private static final boolean scanPerformance;
    private static final String perfNumbersFilePath;
    private static final int PERF_RATIO_THRESHOLD = 20;
    private static HashMap<ASName, Integer> expectedCSRatios;
    private static File file;
    private long startTime = -1L;

    RasterPerformanceObserver() {
    }

    void start() {
        this.startTime = System.nanoTime();
    }

    void stop(ARGBImage image, boolean softMaskPresent, boolean isImageMask) {
        long stopTime = System.nanoTime();
        if (this.startTime == -1L) {
            throw new RuntimeException("Raster performance observer is stopped without getting it started.");
        }
        if (!softMaskPresent) {
            if (updatePerformanceBaseNumbers) {
                RasterPerformanceObserver.updatePerformanceNumbers(image.getWidth() * image.getHeight(), stopTime - this.startTime, isImageMask, image.getColorSpace());
            } else if (scanPerformance) {
                RasterPerformanceObserver.checkImage(image.getWidth() * image.getHeight(), stopTime - this.startTime, isImageMask, image.getColorSpace());
            }
        }
    }

    private static void checkImage(int size, long timeTaken, boolean imageMask, ColorSpace cs) {
        ASName csName = imageMask ? ASName.k_ImageMask : cs.getName();
        double actualRatio = timeTaken / (long)size;
        Integer expectedRatio = expectedCSRatios.get(csName);
        if (expectedRatio != null && actualRatio > (double)expectedRatio.intValue()) {
            double percentageExceeded = (actualRatio - (double)expectedRatio.intValue()) / (double)expectedRatio.intValue();
            if (percentageExceeded < 0.4) {
                throw new RuntimeException(csName.asString() + " is taking 0 to 40% more time than expected.");
            }
            if (percentageExceeded < 0.8) {
                throw new RuntimeException(csName.asString() + " is taking 40 to 80% more time than expected.");
            }
            throw new RuntimeException(csName.asString() + " is taking 80% or more time than expected.");
        }
    }

    private static void updatePerformanceNumbers(int size, long timeTaken, boolean imageMask, ColorSpace cs) {
        ASName csName = imageMask ? ASName.k_ImageMask : cs.getName();
        double actualRatio = timeTaken / (long)size;
        Integer expectedRatio = expectedCSRatios.get(csName);
        if (expectedRatio == null || actualRatio > (double)expectedRatio.intValue()) {
            expectedCSRatios.put(csName, (int)actualRatio);
            RasterPerformanceObserver.flushPerfNumbers(20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushPerfNumbers(int percentage) {
        try {
            Set<Map.Entry<ASName, Integer>> set = expectedCSRatios.entrySet();
            Iterator<Map.Entry<ASName, Integer>> itr = set.iterator();
            FileWriter fWriter = new FileWriter(file);
            try {
                while (itr.hasNext()) {
                    Map.Entry<ASName, Integer> entry = itr.next();
                    fWriter.write(entry.getKey().asString(true) + " " + (100 + percentage) / 100 * entry.getValue() + " ");
                }
            }
            finally {
                if (fWriter != null) {
                    fWriter.flush();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties loadRasterProperties() {
        try {
            StringBuilder jarPath = new StringBuilder(PDFToRasterConverter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String pdfservices = new String("pdfservices.jar");
            jarPath.delete(jarPath.length() - pdfservices.length(), jarPath.length());
            jarPath.append("rasterization.properties");
            File file = new File(jarPath.toString());
            if (file.exists()) {
                Properties rasterProperties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                rasterProperties.load(fileInputStream);
                return rasterProperties;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        expectedCSRatios = new HashMap();
        file = null;
        Properties rasterProps = RasterPerformanceObserver.loadRasterProperties();
        if (rasterProps != null) {
            isExceptionMode = Boolean.valueOf((String)rasterProps.get("exceptionMode"));
            updatePerformanceBaseNumbers = Boolean.valueOf((String)rasterProps.get("updatePerformanceBaseNumbers"));
            scanPerformance = Boolean.valueOf((String)rasterProps.get("scanPerformance"));
            perfNumbersFilePath = (String)rasterProps.get("perfNumbersFilePath");
        } else {
            isExceptionMode = false;
            updatePerformanceBaseNumbers = false;
            scanPerformance = false;
            perfNumbersFilePath = "tests/qe/smoketest/baselines/devtests_dom/rasterizer/perfs.txt";
        }
        try {
            file = new File(perfNumbersFilePath);
            if (updatePerformanceBaseNumbers && !file.exists()) {
                file.getParentFile().mkdir();
                file.delete();
                if (!file.createNewFile()) {
                    PDFUtil.logWarning("Cannot create output file: " + file.getAbsolutePath());
                }
            }
            if (scanPerformance) {
                FileReader reader = new FileReader(file);
                char[] data = new char[(int)file.length()];
                reader.read(data);
                String[] split = new String(data).split(" ");
                for (int i = 0; i < split.length; i += 2) {
                    expectedCSRatios.put(ASName.create(split[i]), Integer.valueOf(split[i + 1]));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

