/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterRuntimeException;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class RasterDocumentContext
extends DocumentContext {
    private Graphics2D graphics2d;
    private Graphics2D graphics2dForXobject;
    private BufferedImage imageForXobject;
    private BufferedImage image;
    private int height;
    private int width;
    RasterizationOptions options;
    private double widthScalingFactor = 1.0;
    private double heightScalingFactor = 1.0;
    private boolean isScaled;
    private HashMap<String, BufferedImage> loadedTilingPatternsTiles = new HashMap();
    private GraphicsState.BlendingMode blendingMode = GraphicsState.BlendingMode.NORMAL;
    private double nonStrokeAlpha = 1.0;
    private boolean isGSSoftMask = false;
    private HashMap<ARGBImage, int[]> loadedImageMaskStreams = null;

    public HashMap<ARGBImage, int[]> getLoadedImageMaskStreams() {
        return this.loadedImageMaskStreams;
    }

    public void setLoadedImageMaskStreams(HashMap<ARGBImage, int[]> loadedImageMaskStreams) {
        this.loadedImageMaskStreams = loadedImageMaskStreams;
    }

    Graphics2D getGraphics2d() {
        return this.graphics2d;
    }

    public void setGraphics2d(Graphics2D graphics2d) {
        this.graphics2d = graphics2d;
    }

    BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    int getPageHeight() {
        return this.height;
    }

    void getTransformedPath(GeneralPath currentPath, double pageHeight) {
        if (pageHeight == 0.0) {
            return;
        }
        AffineTransform transform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, pageHeight);
        currentPath.transform(transform);
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void graphicsStateChanged() {
    }

    @Override
    public void destroy() {
        try {
            if (this.graphics2d != null) {
                this.graphics2d.dispose();
            }
        }
        finally {
            if (this.image != null) {
                this.image.flush();
            }
        }
    }

    RasterizationOptions getOptions() {
        return this.options;
    }

    public void setOptions(RasterizationOptions options) {
        this.options = options;
    }

    void setHeight(int height) {
        this.height = height;
    }

    double getWidthScalingFactor() {
        return this.widthScalingFactor;
    }

    public void setWidthScalingFactor(double widthScalingFactor) {
        this.widthScalingFactor = widthScalingFactor;
    }

    double getHeightScalingFactor() {
        return this.heightScalingFactor;
    }

    public void setHeightScalingFactor(double heightScalingFactor) {
        this.heightScalingFactor = heightScalingFactor;
    }

    public boolean getIsScaled() {
        return this.isScaled;
    }

    public void setIsScale(boolean isScaled) {
        this.isScaled = isScaled;
    }

    public HashMap<String, BufferedImage> getLoadedTilingPatternsTiles() {
        return this.loadedTilingPatternsTiles;
    }

    GraphicsState.BlendingMode getBlendingMode() {
        return this.blendingMode;
    }

    void setBlendingMode(GraphicsState.BlendingMode blendingMode) {
        this.blendingMode = blendingMode;
    }

    double getNonStrokeAlpha() {
        return this.nonStrokeAlpha;
    }

    void setNonStrokeAlpha(double nonStrokeAlpha) {
        this.nonStrokeAlpha = nonStrokeAlpha;
    }

    boolean getIsGSSoftMask() {
        return this.isGSSoftMask;
    }

    void setIsGSSoftMask(boolean isGSSoftMask) {
        this.isGSSoftMask = isGSSoftMask;
    }

    void handleException(Exception e, String message) {
        if (!this.getOptions().ignoreErrors()) {
            throw new RasterRuntimeException(message, e);
        }
    }

    public Graphics2D getGraphics2dForXobject() {
        return this.graphics2dForXobject;
    }

    public void setGraphics2dForXobject(Graphics2D graphics2dForXobject) {
        this.graphics2dForXobject = graphics2dForXobject;
    }

    public BufferedImage getImageForXobject() {
        return this.imageForXobject;
    }

    public void setImageForXobject(BufferedImage imageForXobject) {
        this.imageForXobject = imageForXobject;
    }
}

