/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.FactoryInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.MetaData;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDisplayArea;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterFactory;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;

public class RasterDocument
implements DocumentInterface<RasterGraphicsState, RasterTextState, RasterContentItem, RasterDisplayArea> {
    private List<RasterDisplayArea> displayAreaList;
    private BufferedImage image;
    private RasterFactory factory;

    @Override
    public List<RasterDisplayArea> getDisplayAreaList() {
        return this.displayAreaList;
    }

    @Override
    public void setDisplayAreaList(List<RasterDisplayArea> displayAreaList) {
        this.displayAreaList = displayAreaList;
    }

    public BufferedImage createPage(RasterDisplayArea displayArea, RasterizationOptions rasterConversionOptions, RasterDocumentContext context) throws PDFInvalidDocumentException {
        block11: {
            double[] bbox = displayArea.getBBox();
            Integer pageWidth = (int)Math.ceil(bbox[2] - bbox[0]);
            Integer pageHeight = (int)Math.ceil(bbox[3] - bbox[1]);
            pageWidth = pageWidth == 0 ? 9 : pageWidth;
            pageHeight = pageHeight == 0 ? 9 : pageHeight;
            AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, -bbox[0] * context.getWidthScalingFactor(), bbox[1] * context.getHeightScalingFactor());
            context.setWidth(pageWidth);
            context.setHeight(pageHeight);
            context.setOptions(rasterConversionOptions);
            this.image = new BufferedImage(Math.abs(pageWidth), Math.abs(pageHeight), 2);
            Graphics2D g2 = this.image.createGraphics();
            Color fillColor = Color.WHITE;
            Color backgroundColor = rasterConversionOptions.getBackgroundColor();
            if (backgroundColor == null) {
                g2.setColor(fillColor);
                g2.fillRect(0, 0, pageWidth - 1, pageHeight - 1);
            } else {
                g2.setColor(backgroundColor);
                g2.fillRect(0, 0, pageWidth - 1, pageHeight - 1);
            }
            Stroke stroke = g2.getStroke();
            if (stroke != null) {
                stroke = new BasicStroke();
                g2.setStroke(stroke);
                if (backgroundColor == null) {
                    g2.setColor(Color.WHITE);
                    g2.drawRect(0, 0, pageWidth - 1, pageHeight - 1);
                } else {
                    g2.setColor(backgroundColor);
                    g2.fillRect(0, 0, pageWidth - 1, pageHeight - 1);
                }
            }
            g2.transform(affineTransform);
            context.setGraphics2d(g2);
            context.setImage(this.image);
            RasterCallBackInterface manager = rasterConversionOptions.getCallBackManager();
            if (manager != null) {
                manager.initialize(this.image, g2);
            }
            ContentItemsList<RasterGraphicsState, RasterContentItem> contentItemsList = displayArea.getContentItems();
            Iterator<RasterContentItem> itr = contentItemsList.iterator();
            AbstractContentItem contentItem = null;
            try {
                while (itr.hasNext()) {
                    contentItem = (AbstractContentItem)((Object)itr.next());
                    contentItem.writeToDisplayArea(context);
                    if (manager != null && !manager.removeRasterizedGraphicsItems()) continue;
                    itr.remove();
                }
            }
            catch (Exception e) {
                if (rasterConversionOptions.ignoreErrors()) break block11;
                throw new PDFInvalidDocumentException(e);
            }
        }
        double rotation = displayArea.getDisplayRotation();
        if ((rotation %= 360.0) == 90.0 || rotation == 270.0) {
            BufferedImage rotatedImg = new BufferedImage(this.image.getHeight(), this.image.getWidth(), 2);
            return this.rotateImage(rotation, rotatedImg, this.image.getWidth(), this.image.getHeight());
        }
        if (rotation == 180.0) {
            BufferedImage rotatedImg = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            return this.rotateImage(rotation, rotatedImg, this.image.getWidth(), this.image.getHeight());
        }
        return this.image;
    }

    private BufferedImage rotateImage(double degrees, BufferedImage rotatedImg, int width, int height) {
        AffineTransform transform = new AffineTransform();
        double radians = Math.PI / 180 * degrees;
        if (degrees != 180.0) {
            transform.translate(0.5 * (double)height, 0.5 * (double)width);
            transform.rotate(radians);
            transform.translate(-0.5 * (double)width, -0.5 * (double)height);
        } else {
            transform.rotate(radians, rotatedImg.getWidth() / 2, rotatedImg.getHeight() / 2);
        }
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        op.filter(this.image, rotatedImg);
        return rotatedImg;
    }

    @Override
    public FactoryInterface<RasterGraphicsState, RasterTextState, RasterContentItem, RasterDisplayArea> getFactory() {
        return this.factory == null ? (this.factory = new RasterFactory()) : this.factory;
    }

    @Override
    public MetaData getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(MetaData metadata) {
    }
}

