/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.PDFToRasterConverter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;

public class PageRasterizer {
    PDFPageTreeNode pageRoot;
    Iterator<PDFPage> pageIterator;
    RasterizationOptions options;

    public PageRasterizer(PDFPageTreeNode pageRoot, RasterizationOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pageRoot == null) {
            throw new PDFInvalidDocumentException("PDF page can not be null.");
        }
        if (options == null) {
            throw new PDFInvalidDocumentException("Rasterization Options can not be null.");
        }
        this.pageRoot = pageRoot;
        this.pageIterator = this.pageRoot.iterator();
        this.options = options;
    }

    public boolean hasNext() {
        return this.pageIterator.hasNext();
    }

    public BufferedImage next() throws PDFInvalidContentException, PDFFontException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        PDFPage page = this.pageIterator.next();
        try {
            return PDFToRasterConverter.toBufferedImage(page, this.options.getFontSet(), this.options);
        }
        catch (PDFConfigurationException e) {
            throw new PDFRuntimeException("Configuration error while converting PDFPage to image ", e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

