/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSchemaUsageValidator;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSimpleType;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPValueType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;

class XMPDate
extends XMPSimpleType
implements XMPValueType {
    private static XMPDate _xmpDate = new XMPDate();
    private static final String format1 = "yyyy";
    private static final String format2 = "yyyy-MM";
    private static final String format3 = "yyyy-MM-dd";
    private static final String format4 = "yyyy-MM-dd'T'HH:mm";
    private static final String format5 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String format6 = "yyyy-MM-dd'T'HH:mm:ss.S";
    private static int format4Length = "yyyy-MM-dd'T'HH:mm".length() - 2;

    private XMPDate() {
    }

    public static XMPDate getInstance() {
        return _xmpDate;
    }

    private SimpleDateFormat getDateFormat(int length) {
        if (length == format1.length()) {
            SimpleDateFormat dateformat = new SimpleDateFormat(format1);
            dateformat.setLenient(false);
            return dateformat;
        }
        if (length == format2.length()) {
            SimpleDateFormat dateformat = new SimpleDateFormat(format2);
            dateformat.setLenient(false);
            return dateformat;
        }
        if (length == format3.length()) {
            SimpleDateFormat dateformat = new SimpleDateFormat(format3);
            dateformat.setLenient(false);
            return dateformat;
        }
        if (length == format4.length() - 2) {
            SimpleDateFormat dateformat = new SimpleDateFormat(format4);
            dateformat.setLenient(false);
            return dateformat;
        }
        if (length == format5.length() - 2) {
            SimpleDateFormat dateformat = new SimpleDateFormat(format5);
            dateformat.setLenient(false);
            return dateformat;
        }
        return null;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode a) {
        if (!super.isValid(a)) {
            return false;
        }
        Map<String, Set<String>> qualifierMap = XMPSchemaUsageValidator.getQualifierMap();
        if (qualifierMap != null && qualifierMap.containsKey(a.getNameSpaceURI()) && qualifierMap.get(a.getNameSpaceURI()).contains(a.getName())) {
            return true;
        }
        String value = a.getValue().trim();
        int length = value.length();
        if (length == 0) {
            return false;
        }
        String timeZone = "";
        boolean zTS = false;
        if (value.endsWith("Z")) {
            value = value.replaceAll("Z", "");
            zTS = true;
        } else {
            int indexOfLastPlus;
            int indexOfLastHyphen = value.lastIndexOf(45);
            int timeZonePos = Math.max(indexOfLastHyphen, indexOfLastPlus = value.lastIndexOf(43));
            if (timeZonePos >= format4Length) {
                timeZone = value.substring(timeZonePos + 1);
                value = value.substring(0, timeZonePos);
            }
        }
        SimpleDateFormat format = this.getDateFormat(value.length());
        if (format == null) {
            SimpleDateFormat longDateFormat = new SimpleDateFormat(format6);
            longDateFormat.setLenient(false);
            format = longDateFormat;
        }
        try {
            format.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        if (value.contains("T")) {
            if (timeZone.length() > 0) {
                try {
                    SimpleDateFormat timeZoneFormat = new SimpleDateFormat("HH:mm");
                    timeZoneFormat.setLenient(false);
                    timeZoneFormat.parse(timeZone);
                }
                catch (ParseException e) {
                    return false;
                }
            } else {
                return zTS;
            }
        }
        return true;
    }
}

