/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReferencedResources {
    private LinkedHashMap<ASName, ArrayList<GState>> colorSpaces;
    private HashSet<ASName> extGStateNames;
    private HashMap<ASName, Object> fontMap;
    private HashMap<ASName, Object> invisibleFontMap;
    private LinkedHashMap<ASName, ArrayList<GState>> xObjects;
    private LinkedHashMap<ASName, ArrayList<GState>> patterns;
    private HashSet<ASName> shadingNames;
    private HashSet<ASName> propertyNames;

    private void lazyInitColorSpaceNames() {
        if (this.colorSpaces == null) {
            this.colorSpaces = new LinkedHashMap();
        }
    }

    private void lazyInitExtGStateNames() {
        if (this.extGStateNames == null) {
            this.extGStateNames = new LinkedHashSet<ASName>();
        }
    }

    private void lazyInitFontMap() {
        if (this.fontMap == null) {
            this.fontMap = new LinkedHashMap<ASName, Object>();
        }
    }

    private void lazyInitInvisibleFontMap() {
        if (this.invisibleFontMap == null) {
            this.invisibleFontMap = new LinkedHashMap<ASName, Object>();
        }
    }

    private void lazyInitXObjects() {
        if (this.xObjects == null) {
            this.xObjects = new LinkedHashMap();
        }
    }

    private void lazyInitPatterns() {
        if (this.patterns == null) {
            this.patterns = new LinkedHashMap();
        }
    }

    private void lazyInitShadingNames() {
        if (this.shadingNames == null) {
            this.shadingNames = new LinkedHashSet<ASName>();
        }
    }

    private void lazyInitPropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = new LinkedHashSet<ASName>();
        }
    }

    boolean hasColorSpaces() {
        return this.colorSpaces != null && !this.colorSpaces.isEmpty();
    }

    LinkedHashMap<ASName, ArrayList<GState>> getColorSpaces() {
        return this.colorSpaces;
    }

    void addColorSpace(ASName name, GState gState) {
        this.lazyInitColorSpaceNames();
        ArrayList<GState> gStates = this.colorSpaces.get(name);
        if (gStates == null) {
            gStates = new ArrayList();
        }
        gStates.add(gState);
        this.colorSpaces.put(name, gStates);
    }

    boolean hasExtGStates() {
        return this.extGStateNames != null && !this.extGStateNames.isEmpty();
    }

    Set getExtGStateNames() {
        return this.extGStateNames;
    }

    void addExtGState(ASName name) {
        this.lazyInitExtGStateNames();
        this.extGStateNames.add(name);
    }

    public boolean hasFonts() {
        return this.fontMap != null && !this.fontMap.isEmpty();
    }

    public HashMap getFontMap() {
        return this.fontMap;
    }

    public Set getFontNames() {
        if (this.fontMap == null) {
            return null;
        }
        return this.fontMap.keySet();
    }

    void addFont(ASName name, Object fontInfo) {
        this.lazyInitFontMap();
        if (!this.fontMap.containsKey(name)) {
            if (fontInfo == null) {
                this.fontMap.put(name, fontInfo);
            } else {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.fontMap.put(name, l);
            }
        } else {
            Object oldFontInfo = this.fontMap.get(name);
            if (oldFontInfo == null) {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.fontMap.put(name, l);
            } else {
                List l = (List)oldFontInfo;
                l.add(fontInfo);
            }
        }
    }

    public HashMap getInvisibleFontMap() {
        return this.invisibleFontMap;
    }

    public Set getInvisibleFontNames() {
        if (this.invisibleFontMap == null) {
            return null;
        }
        return this.invisibleFontMap.keySet();
    }

    void addInvisibleFont(ASName name, Object fontInfo) {
        this.lazyInitInvisibleFontMap();
        if (!this.invisibleFontMap.containsKey(name)) {
            if (fontInfo == null) {
                this.invisibleFontMap.put(name, fontInfo);
            } else {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.invisibleFontMap.put(name, l);
            }
        } else {
            Object oldFontInfo = this.invisibleFontMap.get(name);
            if (oldFontInfo == null) {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.invisibleFontMap.put(name, l);
            } else {
                List l = (List)oldFontInfo;
                l.add(fontInfo);
            }
        }
    }

    boolean hasXObjects() {
        return this.xObjects != null && !this.xObjects.isEmpty();
    }

    LinkedHashMap<ASName, ArrayList<GState>> getXObjects() {
        return this.xObjects;
    }

    void addXObject(ASName name, GState gState) {
        this.lazyInitXObjects();
        ArrayList<GState> gStates = this.xObjects.get(name);
        if (gStates == null) {
            gStates = new ArrayList();
        }
        gStates.add(gState);
        this.xObjects.put(name, gStates);
    }

    boolean hasPatterns() {
        return this.patterns != null && !this.patterns.isEmpty();
    }

    LinkedHashMap<ASName, ArrayList<GState>> getPatterns() {
        return this.patterns;
    }

    void addPattern(ASName name, GState gState) {
        this.lazyInitPatterns();
        ArrayList<GState> gStates = this.patterns.get(name);
        if (gStates == null) {
            gStates = new ArrayList();
        }
        gStates.add(gState);
        this.patterns.put(name, gStates);
    }

    boolean hasShadings() {
        return this.shadingNames != null && !this.shadingNames.isEmpty();
    }

    Set getShadingNames() {
        return this.shadingNames;
    }

    void addShading(ASName name) {
        this.lazyInitShadingNames();
        this.shadingNames.add(name);
    }

    boolean hasProperties() {
        return this.propertyNames != null && !this.propertyNames.isEmpty();
    }

    Set getPropertyNames() {
        return this.propertyNames;
    }

    void addProperty(ASName name) {
        this.lazyInitPropertyNames();
        this.propertyNames.add(name);
    }

    boolean isEmpty() {
        return !this.hasColorSpaces() && !this.hasExtGStates() && !this.hasFonts() && !this.hasPatterns() && !this.hasProperties() && !this.hasShadings();
    }
}

